package com.cisdi.nudgeplus.sdk.utils;

public class AesException extends Exception {

    public final static int ValidateSignatureError = -50001;
    public final static int ParseXmlError = -50002;
    public final static int ComputeSignatureError = -50003;
    public final static int IllegalAesKey = -50004;
    public final static int ValidateCorpidError = -50005;
    public final static int EncryptAESError = -50006;
    public final static int DecryptAESError = -50007;
    public final static int IllegalBuffer = -50008;

    private int code;

    private static String getMessage(int code) {
        switch (code) {
            case ValidateSignatureError:
                return "签名验证错误";
            case ParseXmlError:
                return "xml解析失败";
            case ComputeSignatureError:
                return "sha加密生成签名失败";
            case IllegalAesKey:
                return "SymmetricKey非法";
            case ValidateCorpidError:
                return "corpid校验失败";
            case EncryptAESError:
                return "aes加密失败";
            case DecryptAESError:
                return "aes解密失败";
            case IllegalBuffer:
                return "解密后得到的buffer非法";
            default:
                return null;
        }
    }

    AesException(int code) {
        super(getMessage(code));
        this.code = code;
    }

}
