/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.datamng;

import com.cisdi.nudgeplus.sdk.exception.IllegalRequestException;
import com.cisdi.nudgeplus.sdk.utils.JsonUtils;
import com.cisdi.nudgeplus.sdk.utils.NudgePlusConfig;
import com.cisdi.nudgeplus.tmsbeans.beans.BaseResult;
import com.cisdi.nudgeplus.tmsbeans.beans.ErrorResult;
import com.cisdi.nudgeplus.tmsbeans.beans.ResultWapper;
import com.cisdi.nudgeplus.tmsbeans.beans.StatusCode;
import com.google.gson.JsonSyntaxException;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.imageio.ImageIO;

public final class ClientUtils {
    private static final String BASE_URL = NudgePlusConfig.getValue("baseURL");
    private static final String TEAM_URL = NudgePlusConfig.getValue("teamURL");
    private static final String POST_METHOD = "post";
    private static final String GET_METHOD = "get";
    private static final int READ_TIMEOUT = 30000;
    private static final int CONNECT_TIMEOUT = 5000;

    private ClientUtils() {
    }

    public static <T extends BaseResult> ResultWapper<T> get(String path, Map<String, String> params, Class<T> clazz) throws IllegalRequestException {
        if (params == null || params.isEmpty()) {
            throw new IllegalRequestException(" request params is null !");
        }
        InputStream responseInputStream = null;
        HttpURLConnection connection = null;
        try {
            URL realUrl = ClientUtils.getUrl(path, params);
            connection = ClientUtils.getHttpURLConnection(realUrl, GET_METHOD);
            responseInputStream = connection.getInputStream();
            String result = ClientUtils.dealResponseToString(responseInputStream);
            ResultWapper<T> resultWapper = ClientUtils.parseResponse(result, clazz);
            return resultWapper;
        }
        catch (IOException e) {
            throw new IllegalRequestException("send get request error,Probably the path is wrong", (Throwable)e);
        }
        finally {
            try {
                if (responseInputStream != null) {
                    responseInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static <T extends BaseResult> ResultWapper<T> post(String path, String token, String json, Class<T> clazz) throws IllegalRequestException {
        HttpURLConnection connection = null;
        InputStream responseInputStream = null;
        try {
            URL url = ClientUtils.getPostUrl(path, token, null);
            connection = ClientUtils.getHttpURLConnection(url, POST_METHOD);
            ClientUtils.sendPostRequestParam(connection, json);
            responseInputStream = connection.getInputStream();
            String result = ClientUtils.dealResponseToString(responseInputStream);
            ResultWapper<T> resultWapper = ClientUtils.parseResponse(result, clazz);
            return resultWapper;
        }
        catch (Exception e) {
            throw new IllegalRequestException(" send post request error:", (Throwable)e);
        }
        finally {
            try {
                if (responseInputStream != null) {
                    responseInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static <T extends BaseResult> ResultWapper<T> uploadMedia(String path, String token, String type, File media, Class<T> clazz) throws IllegalRequestException {
        HttpURLConnection connection = null;
        InputStream responseInputStream = null;
        try {
            URL url = ClientUtils.getPostUrl(path, token, type);
            connection = ClientUtils.getHttpURLConnection(url, POST_METHOD);
            ClientUtils.sendRequestForUploadMedia(type, media, connection);
            responseInputStream = connection.getInputStream();
            String result = ClientUtils.dealResponseToString(responseInputStream);
            ResultWapper<T> resultWapper = ClientUtils.parseResponse(result, clazz);
            return resultWapper;
        }
        catch (Exception e) {
            throw new IllegalRequestException("send post request error", (Throwable)e);
        }
        finally {
            try {
                if (responseInputStream != null) {
                    responseInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static void sendRequestForUploadMedia(String type, File media, HttpURLConnection httpURLConnection) throws IOException {
        String boundary = "----------" + System.currentTimeMillis();
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        DataOutputStream requestOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
        byte[] head = ClientUtils.getHeaderOfUploadedFileRequest(boundary, media, type);
        ((OutputStream)requestOutputStream).write(head);
        ClientUtils.writeFileToRequestOutputStream(media, requestOutputStream);
        byte[] foot = ClientUtils.getFootOfUploadedFileRequest(boundary);
        ((OutputStream)requestOutputStream).write(foot);
        ((OutputStream)requestOutputStream).flush();
        ((OutputStream)requestOutputStream).close();
    }

    private static URL getUrl(String urlStr, Map<String, String> params) throws MalformedURLException {
        if (params != null && !params.isEmpty()) {
            String param = ClientUtils.dealParamsMapToString(params);
            urlStr = urlStr + "?" + param;
        }
        return new URL(urlStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dealResponseToString(InputStream responseInputStream) {
        InputStreamReader responseInputReader = new InputStreamReader(responseInputStream);
        BufferedReader responseBufferedReader = new BufferedReader(responseInputReader);
        StringBuilder result = new StringBuilder();
        try {
            String line;
            while ((line = responseBufferedReader.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                responseInputReader.close();
                responseBufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    private static void closeBufferedReader(BufferedReader responseBufferedReader) {
        if (responseBufferedReader != null) {
            try {
                responseBufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String dealParamsMapToString(Map<String, String> params) {
        StringBuilder paramStr = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            paramStr.append(entry.getKey());
            paramStr.append("=");
            paramStr.append(entry.getValue());
            paramStr.append("&");
        }
        paramStr.substring(0, paramStr.length() - 1);
        return paramStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendPostRequestParam(HttpURLConnection httpURLConnection, String json) {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(httpURLConnection.getOutputStream());
            writer.print(json);
            writer.flush();
        }
    }

    private static URL getPostUrl(String urlStr, String token, String type) throws MalformedURLException, IllegalRequestException {
        if (token == null || "".equals(token)) {
            throw new IllegalRequestException("token is valid");
        }
        urlStr = urlStr + "?access_token=" + token;
        if (type != null && !"".equals(type)) {
            urlStr = urlStr + "&type=" + type;
        }
        return new URL(urlStr);
    }

    private static HttpURLConnection getHttpURLConnection(URL url, String requestMethod) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestProperty("accept", "*/*");
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.setReadTimeout(30000);
        if (GET_METHOD.equals(requestMethod)) {
            return httpURLConnection;
        }
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Charset", "UTF-8");
        httpURLConnection.setRequestProperty("content-type", "application/json");
        httpURLConnection.setRequestMethod("POST");
        return httpURLConnection;
    }

    private static void writeFileToRequestOutputStream(File media, OutputStream requestOutputStream) throws IOException {
        int bytes;
        DataInputStream inputStream = new DataInputStream(new FileInputStream(media));
        byte[] bufferOut = new byte[1024];
        while ((bytes = inputStream.read(bufferOut)) != -1) {
            requestOutputStream.write(bufferOut, 0, bytes);
        }
        inputStream.close();
    }

    private static byte[] getHeaderOfUploadedFileRequest(String boundary, File media, String type) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("--").append(boundary).append("\r\n").append("Content-Disposition: form-data;name=\"media\";filename=\"").append(media.getName()).append("\"\r\n");
        if ("image".equals(type) && ClientUtils.isPicture(media)) {
            sb.append("Content-Type:image/jpeg\r\n\r\n");
        } else {
            sb.append("Content-Type:application/octet-stream\r\n\r\n");
        }
        return sb.toString().getBytes("utf-8");
    }

    private static byte[] getFootOfUploadedFileRequest(String boundary) throws UnsupportedEncodingException {
        return ("\r\n--" + boundary + "--\r\n").getBytes("utf-8");
    }

    private static <T extends BaseResult> ResultWapper<T> parseResponse(String jsonStr, Class<T> clazz) throws IllegalRequestException {
        ResultWapper<BaseResult> result = new ResultWapper<BaseResult>();
        BaseResult bean = null;
        try {
            bean = (BaseResult)JsonUtils.jsonToBean(jsonStr, clazz);
        }
        catch (JsonSyntaxException e) {
            bean = new BaseResult();
            bean.setErrcode(40038);
            bean.setErrmsg(StatusCode.is(40038));
        }
        if (bean.getErrcode() != 0) {
            result.setError(true);
            result.setErrorResult(new ErrorResult(bean.getErrcode(), bean.getErrmsg()));
        } else {
            result.setResult(bean);
        }
        return result;
    }

    private static boolean isPicture(File media) {
        boolean isPicture = false;
        try {
            BufferedImage image = ImageIO.read(media);
            if (image != null) {
                isPicture = true;
            }
        }
        catch (IOException ex) {
            isPicture = false;
        }
        return isPicture;
    }
}

