/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.service;

import com.cisdi.nudgeplus.sdk.constants.PathConstants;
import com.cisdi.nudgeplus.sdk.datamng.ClientUtils;
import com.cisdi.nudgeplus.sdk.exception.IllegalMessageException;
import com.cisdi.nudgeplus.sdk.exception.IllegalRequestException;
import com.cisdi.nudgeplus.sdk.service.TokenService;
import com.cisdi.nudgeplus.tmsbeans.beans.MediaResult;
import com.cisdi.nudgeplus.tmsbeans.beans.ResultWapper;
import com.cisdi.nudgeplus.tmsbeans.beans.TicktetResult;
import java.util.HashMap;

public class JsapiService {
    public static String download(String mediaId) {
        return JsapiService.download(mediaId, TokenService.ACCESS_TOKEN);
    }

    public static String download(String mediaId, String token) {
        if (mediaId == null) {
            throw new IllegalMessageException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("access_token", token);
        map.put("media_id", mediaId);
        String path = PathConstants.BASE_URL + "/media/download/path";
        ResultWapper<MediaResult> resultWapper = ClientUtils.get(path, map, MediaResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMediaId();
    }

    public static TicktetResult getTicket() {
        return JsapiService.getTicket(TokenService.ACCESS_TOKEN);
    }

    public static TicktetResult getTicket(String token) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        String path = PathConstants.JSAPI_URL + "/js/ticket/get";
        ResultWapper<TicktetResult> resultWapper = ClientUtils.get(path, map, TicktetResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }
}

