/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.service;

import com.cisdi.nudgeplus.sdk.constants.PathConstants;
import com.cisdi.nudgeplus.sdk.datamng.ClientUtils;
import com.cisdi.nudgeplus.sdk.exception.IllegalMessageException;
import com.cisdi.nudgeplus.sdk.exception.IllegalRequestException;
import com.cisdi.nudgeplus.sdk.service.TokenService;
import com.cisdi.nudgeplus.sdk.utils.ClassUtils;
import com.cisdi.nudgeplus.sdk.utils.JsonUtils;
import com.cisdi.nudgeplus.tmsbeans.beans.MessageResult;
import com.cisdi.nudgeplus.tmsbeans.beans.ResultWapper;
import com.cisdi.nudgeplus.tmsbeans.model.ImageMsg;
import com.cisdi.nudgeplus.tmsbeans.model.MassMsg;
import com.cisdi.nudgeplus.tmsbeans.model.NewsMsg;
import com.cisdi.nudgeplus.tmsbeans.model.RichMsg;
import com.cisdi.nudgeplus.tmsbeans.model.TextMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.basics.MassSendRequest;
import com.cisdi.nudgeplus.tmsbeans.model.request.keyvalue.KeyValueMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.media.MediaMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.news.NewsMsgArticle;
import com.cisdi.nudgeplus.tmsbeans.model.request.news.NewsMsgParam;
import com.cisdi.nudgeplus.tmsbeans.model.request.process.ProcessMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.textcard.TextCardMsg;
import com.cisdi.nudgeplus.tmsbeans.model.response.ProcessMsgMassResponse;
import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.List;

public class MassMessageService {
    public static String sendTextMsg(List<String> userList, TextMsg textMsg) {
        return MassMessageService.sendTextMsg(userList, textMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendTextMsg(List<String> userList, TextMsg textMsg, String token) {
        if (textMsg == null) {
            throw new IllegalMessageException();
        }
        MassMsg msg = new MassMsg();
        msg.setTouser(userList);
        msg.setMsgtype("text");
        msg.setText(textMsg);
        String path = PathConstants.BASE_URL + "/message/mass/send";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMsgId();
    }

    public static String sendImageMsg(List<String> userList, ImageMsg imageMsg) {
        return MassMessageService.sendImageMsg(userList, imageMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendImageMsg(List<String> userList, ImageMsg imageMsg, String token) {
        if (imageMsg == null) {
            throw new IllegalMessageException();
        }
        MassMsg msg = new MassMsg();
        msg.setTouser(userList);
        msg.setMsgtype("image");
        msg.setImage(imageMsg);
        String path = PathConstants.BASE_URL + "/message/mass/send";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMsgId();
    }

    public static String sendRichMsg(List<String> userList, RichMsg richMsg) {
        return MassMessageService.sendRichMsg(userList, richMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendRichMsg(List<String> userList, RichMsg richMsg, String token) {
        if (richMsg == null) {
            throw new IllegalMessageException();
        }
        MassMsg msg = new MassMsg();
        msg.setTouser(userList);
        msg.setMsgtype("richmsg");
        msg.setRichMsg(richMsg);
        String path = PathConstants.BASE_URL + "/message/mass/send";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMsgId();
    }

    public static String sendNewsMsg(List<String> userList, NewsMsg newsMsg) {
        return MassMessageService.sendNewsMsg(userList, newsMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendNewsMsg(List<String> userList, NewsMsg newsMsg, String token) {
        if (newsMsg == null) {
            throw new IllegalMessageException();
        }
        MassSendRequest<NewsMsgParam> msg = new MassSendRequest<NewsMsgParam>();
        List<NewsMsgArticle> newsMsgArticleList = ClassUtils.convertNewsMsg(newsMsg.getArticles());
        NewsMsgParam newsMsgParam = new NewsMsgParam();
        newsMsgParam.setArticle_list(newsMsgArticleList);
        msg.setMessage(newsMsgParam);
        msg.setTo_users(userList);
        String path = PathConstants.BASE_URL + "/message/news/send/mass";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }

    public static String sendFileMsg(List<String> userList, MediaMsg mediaMsg) {
        return MassMessageService.sendFileMsg(userList, mediaMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendFileMsg(List<String> userList, MediaMsg mediaMsg, String token) {
        if (mediaMsg == null) {
            throw new IllegalMessageException();
        }
        MassSendRequest<MediaMsg> msg = new MassSendRequest<MediaMsg>();
        msg.setTo_users(userList);
        msg.setMessage(mediaMsg);
        String path = PathConstants.BASE_URL + "/message/file/send/mass";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }

    public static String sendTextCardMsg(List<String> userList, TextCardMsg textCardMsg) {
        return MassMessageService.sendTextCardMsg(userList, textCardMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendTextCardMsg(List<String> userList, TextCardMsg textCardMsg, String token) {
        if (textCardMsg == null) {
            throw new IllegalMessageException();
        }
        MassSendRequest<TextCardMsg> msg = new MassSendRequest<TextCardMsg>();
        msg.setTo_users(userList);
        msg.setMessage(textCardMsg);
        String path = PathConstants.BASE_URL + "/message/textCard/send/mass";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }

    public static String sendKeyValueMsg(List<String> userList, KeyValueMsg keyValueMsg) {
        return MassMessageService.sendKeyValueMsg(userList, keyValueMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendKeyValueMsg(List<String> userList, KeyValueMsg keyValueMsg, String token) {
        if (keyValueMsg == null) {
            throw new IllegalMessageException();
        }
        MassSendRequest<KeyValueMsg> msg = new MassSendRequest<KeyValueMsg>();
        msg.setTo_users(userList);
        msg.setMessage(keyValueMsg);
        String path = PathConstants.BASE_URL + "/message/keyValue/send/mass";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }

    public static List<ProcessMsgMassResponse> sendProcessMsg(List<String> userList, ProcessMsg processMsg) {
        return MassMessageService.sendProcessMsg(userList, processMsg, TokenService.ACCESS_TOKEN);
    }

    public static List<ProcessMsgMassResponse> sendProcessMsg(List<String> userList, ProcessMsg processMsg, String token) {
        if (processMsg == null) {
            throw new IllegalMessageException();
        }
        MassSendRequest<ProcessMsg> msg = new MassSendRequest<ProcessMsg>();
        msg.setTo_users(userList);
        msg.setMessage(processMsg);
        String path = PathConstants.BASE_URL + "/message/process/send/mass";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        ArrayList<ProcessMsgMassResponse> response = new ArrayList<ProcessMsgMassResponse>();
        for (int i = 0; i < ((ArrayList)resultWapper.getResult().getData()).size(); ++i) {
            ProcessMsgMassResponse processMsgMassResponse = new ProcessMsgMassResponse();
            processMsgMassResponse.setMsgId((String)((LinkedTreeMap)((ArrayList)resultWapper.getResult().getData()).get(i)).get((Object)"msg_id"));
            processMsgMassResponse.setOpenId((String)((LinkedTreeMap)((ArrayList)resultWapper.getResult().getData()).get(i)).get((Object)"open_id"));
            response.add(processMsgMassResponse);
        }
        return response;
    }
}

