/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.service;

import com.cisdi.nudgeplus.sdk.constants.ErrorConstants;
import com.cisdi.nudgeplus.sdk.constants.PathConstants;
import com.cisdi.nudgeplus.sdk.datamng.ClientUtils;
import com.cisdi.nudgeplus.sdk.exception.IllegalRequestException;
import com.cisdi.nudgeplus.sdk.service.TokenService;
import com.cisdi.nudgeplus.sdk.utils.JsonUtils;
import com.cisdi.nudgeplus.tmsbeans.beans.BaseResult;
import com.cisdi.nudgeplus.tmsbeans.beans.ResultWapper;
import com.cisdi.nudgeplus.tmsbeans.beans.member.AccountResult;
import com.cisdi.nudgeplus.tmsbeans.beans.member.OpenIdResult;
import com.cisdi.nudgeplus.tmsbeans.beans.member.PagedSyncUserDetailResult;
import com.cisdi.nudgeplus.tmsbeans.beans.member.PagedUserInfoResult;
import com.cisdi.nudgeplus.tmsbeans.beans.member.UserDetail;
import com.cisdi.nudgeplus.tmsbeans.model.request.member.RequestBatchCreateUsers;
import com.cisdi.nudgeplus.tmsbeans.model.request.member.RequestCreateUser;
import com.cisdi.nudgeplus.tmsbeans.model.request.member.RequestDeleteUsers;
import com.cisdi.nudgeplus.tmsbeans.model.request.member.RequestPagedOrgUserInfo;
import com.cisdi.nudgeplus.tmsbeans.model.request.member.RequestPagedSyncMember;
import com.cisdi.nudgeplus.tmsbeans.model.request.member.RequestPagedUserInfo;
import com.cisdi.nudgeplus.tmsbeans.model.request.member.RequestUpdateUser;
import com.cisdi.nudgeplus.tmsbeans.model.request.member.RequestUser;
import java.util.HashMap;

public class MemberService {
    public static PagedUserInfoResult pageOrgUserInfo(RequestPagedOrgUserInfo request) {
        return MemberService.pageOrgUserInfo(request, TokenService.ACCESS_TOKEN);
    }

    public static PagedUserInfoResult pageOrgUserInfo(RequestPagedOrgUserInfo request, String token) {
        String path;
        ResultWapper<PagedUserInfoResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        map.put("orgId", request.getOrgId());
        map.put("pageSize", String.valueOf(request.getPageSize()));
        map.put("requestPage", String.valueOf(request.getRequestPage()));
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        if ((resultWapper = ClientUtils.get(path = PathConstants.TEAM_URL + "/member/org/paged", map, PagedUserInfoResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }

    public static PagedUserInfoResult pageAllUserInfo(RequestPagedUserInfo request) {
        return MemberService.pageAllUserInfo(request, TokenService.ACCESS_TOKEN);
    }

    public static PagedUserInfoResult pageAllUserInfo(RequestPagedUserInfo request, String token) {
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        map.put("pageSize", String.valueOf(request.getPageSize()));
        map.put("requestPage", String.valueOf(request.getRequestPage()));
        map.put("accessToken", token);
        String path = PathConstants.TEAM_URL + "/member/all/paged";
        ResultWapper<PagedUserInfoResult> resultWapper = ClientUtils.get(path, map, PagedUserInfoResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }

    public static UserDetail getUserDetailInfo(RequestUser request) {
        return MemberService.getUserDetailInfo(request, TokenService.ACCESS_TOKEN);
    }

    public static UserDetail getUserDetailInfo(RequestUser request, String token) {
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        map.put("accountId", request.getAccountId());
        String path = PathConstants.TEAM_URL + "/member/detail";
        ResultWapper<UserDetail> resultWapper = ClientUtils.get(path, map, UserDetail.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }

    public static UserDetail getUserDetailInfo(String openId) {
        return MemberService.getUserDetailInfo(openId, TokenService.ACCESS_TOKEN);
    }

    public static UserDetail getUserDetailInfo(String openId, String token) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        map.put("openId", openId);
        String path = PathConstants.TEAM_URL + "/member/openid/detail";
        ResultWapper<UserDetail> resultWapper = ClientUtils.get(path, map, UserDetail.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }

    public static void deleteUser(RequestUser request) {
        MemberService.deleteUser(request, TokenService.ACCESS_TOKEN);
    }

    public static void deleteUser(RequestUser request, String token) {
        String path;
        ResultWapper<BaseResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        if (request.getDomainId() == null) {
            try {
                request.setDomainId(JsonUtils.getDomainIdByToken(token));
            }
            catch (Exception e) {
                throw new IllegalRequestException(ErrorConstants.TOKEN_ERRPO);
            }
        }
        if ((resultWapper = ClientUtils.post(path = PathConstants.TEAM_URL + "/member/delete/single/json", token, JsonUtils.beanToJson(request), BaseResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
    }

    public static void batchDeleteUsers(RequestDeleteUsers request) {
        MemberService.batchDeleteUsers(request, TokenService.ACCESS_TOKEN);
    }

    public static void batchDeleteUsers(RequestDeleteUsers request, String token) {
        String path;
        ResultWapper<BaseResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        if (request.getDomainId() == null) {
            try {
                request.setDomainId(JsonUtils.getDomainIdByToken(token));
            }
            catch (Exception e) {
                throw new IllegalRequestException(ErrorConstants.TOKEN_ERRPO);
            }
        }
        if ((resultWapper = ClientUtils.post(path = PathConstants.TEAM_URL + "/member/delete/batch/json", token, JsonUtils.beanToJson(request), BaseResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
    }

    public static void updateUserInfo(RequestUpdateUser request) {
        MemberService.updateUserInfo(request, TokenService.ACCESS_TOKEN);
    }

    public static void updateUserInfo(RequestUpdateUser request, String token) {
        String path;
        ResultWapper<BaseResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        if (request.getDomainId() == null) {
            try {
                request.setDomainId(JsonUtils.getDomainIdByToken(token));
            }
            catch (Exception e) {
                throw new IllegalRequestException(ErrorConstants.TOKEN_ERRPO);
            }
        }
        if ((resultWapper = ClientUtils.post(path = PathConstants.TEAM_URL + "/member/update/single/json", token, JsonUtils.beanToJson(request), BaseResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
    }

    public static PagedSyncUserDetailResult syncUsers(RequestPagedSyncMember request) {
        return MemberService.syncUsers(request, TokenService.ACCESS_TOKEN);
    }

    public static PagedSyncUserDetailResult syncUsers(RequestPagedSyncMember request, String token) {
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        map.put("syncTime", String.valueOf(request.getSyncTime()));
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        map.put("pageSize", String.valueOf(request.getPageSize()));
        map.put("requestPage", String.valueOf(request.getRequestPage()));
        String path = PathConstants.TEAM_URL + "/member/sync";
        ResultWapper<PagedSyncUserDetailResult> resultWapper = ClientUtils.get(path, map, PagedSyncUserDetailResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }

    public static String getAccountId(String openId) {
        return MemberService.getAccountId(openId, TokenService.ACCESS_TOKEN);
    }

    public static String getAccountId(String openId, String token) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        map.put("openId", openId);
        String path = PathConstants.TEAM_URL + "/member/account/get";
        ResultWapper<AccountResult> resultWapper = ClientUtils.get(path, map, AccountResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getAccountId();
    }

    public static String getOpenId(RequestUser request) {
        return MemberService.getOpenId(request, TokenService.ACCESS_TOKEN);
    }

    public static String getOpenId(RequestUser request, String token) {
        String path;
        ResultWapper<OpenIdResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        map.put("accountId", request.getAccountId());
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        if ((resultWapper = ClientUtils.get(path = PathConstants.TEAM_URL + "/member/openid/get", map, OpenIdResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getOpenId();
    }

    public static void batchCreateNewUsers(RequestBatchCreateUsers request) {
        MemberService.batchCreateNewUsers(request, TokenService.ACCESS_TOKEN);
    }

    public static void batchCreateNewUsers(RequestBatchCreateUsers request, String token) {
        String path;
        ResultWapper<BaseResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        if (request.getDomainId() == null) {
            try {
                request.setDomainId(JsonUtils.getDomainIdByToken(token));
            }
            catch (Exception e) {
                throw new IllegalRequestException(ErrorConstants.TOKEN_ERRPO);
            }
        }
        if ((resultWapper = ClientUtils.post(path = PathConstants.TEAM_URL + "/member/create/batch/json", token, JsonUtils.beanToJson(request), BaseResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
    }

    public static void createNewUser(RequestCreateUser request) {
        MemberService.createNewUser(request, TokenService.ACCESS_TOKEN);
    }

    public static void createNewUser(RequestCreateUser request, String token) {
        String path;
        ResultWapper<BaseResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        if (request.getDomainId() == null) {
            try {
                request.setDomainId(JsonUtils.getDomainIdByToken(token));
            }
            catch (Exception e) {
                throw new IllegalRequestException(ErrorConstants.TOKEN_ERRPO);
            }
        }
        if ((resultWapper = ClientUtils.post(path = PathConstants.TEAM_URL + "/member/create/single/json", token, JsonUtils.beanToJson(request), BaseResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
    }
}

