/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.service;

import com.cisdi.nudgeplus.sdk.constants.PathConstants;
import com.cisdi.nudgeplus.sdk.datamng.ClientUtils;
import com.cisdi.nudgeplus.sdk.exception.IllegalRequestException;
import com.cisdi.nudgeplus.sdk.utils.NudgePlusConfig;
import com.cisdi.nudgeplus.tmsbeans.beans.ResultWapper;
import com.cisdi.nudgeplus.tmsbeans.beans.UserInfoResult;
import java.util.HashMap;

public class OAuthService {
    public static UserInfoResult getUserInfo(String appid, String secret, String qtCode) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("grant_type", "client_credential");
        queryParams.put("appid", appid);
        queryParams.put("secret", secret);
        queryParams.put("qt_code", qtCode);
        UserInfoResult userInfo = null;
        try {
            String path = PathConstants.BASE_URL + "/oauth2/userinfo";
            ResultWapper<UserInfoResult> resultWapper = ClientUtils.get(path, queryParams, UserInfoResult.class);
            if (resultWapper.isError()) {
                throw new IllegalRequestException(resultWapper.getErrorResult());
            }
            userInfo = resultWapper.getResult();
        }
        catch (IllegalRequestException e) {
            e.printStackTrace();
        }
        return userInfo;
    }

    public static UserInfoResult getUserInfo(String qtCode) {
        return OAuthService.getUserInfo(NudgePlusConfig.getValue("APP_ID"), NudgePlusConfig.getValue("APP_SECRET"), qtCode);
    }
}

