/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.service;

import com.cisdi.nudgeplus.sdk.constants.ErrorConstants;
import com.cisdi.nudgeplus.sdk.constants.PathConstants;
import com.cisdi.nudgeplus.sdk.datamng.ClientUtils;
import com.cisdi.nudgeplus.sdk.exception.IllegalRequestException;
import com.cisdi.nudgeplus.sdk.service.TokenService;
import com.cisdi.nudgeplus.sdk.utils.JsonUtils;
import com.cisdi.nudgeplus.tmsbeans.beans.BaseResult;
import com.cisdi.nudgeplus.tmsbeans.beans.ResultWapper;
import com.cisdi.nudgeplus.tmsbeans.beans.org.NewOrgResult;
import com.cisdi.nudgeplus.tmsbeans.beans.org.OrgBaseResult;
import com.cisdi.nudgeplus.tmsbeans.beans.org.OrgSyncListResult;
import com.cisdi.nudgeplus.tmsbeans.beans.org.OrgTreeResultResult;
import com.cisdi.nudgeplus.tmsbeans.beans.org.PagedOrgResult;
import com.cisdi.nudgeplus.tmsbeans.beans.org.SumUserResult;
import com.cisdi.nudgeplus.tmsbeans.model.request.org.RequestNewOrg;
import com.cisdi.nudgeplus.tmsbeans.model.request.org.RequestOrg;
import com.cisdi.nudgeplus.tmsbeans.model.request.org.RequestOrgName;
import com.cisdi.nudgeplus.tmsbeans.model.request.org.RequestOrgSycInfo;
import com.cisdi.nudgeplus.tmsbeans.model.request.org.RequestPagedOrg;
import java.util.HashMap;

public class OrgService {
    public static OrgTreeResultResult getOrganizationList(RequestOrg request) {
        return OrgService.getOrganizationList(request, TokenService.ACCESS_TOKEN);
    }

    public static OrgTreeResultResult getOrganizationList(RequestOrg request, String token) {
        String path;
        ResultWapper<OrgTreeResultResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        map.put("orgId", request.getOrgId());
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        if ((resultWapper = ClientUtils.get(path = PathConstants.TEAM_URL + "/org/list", map, OrgTreeResultResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }

    public static PagedOrgResult pagedOrganizationList(RequestPagedOrg request) {
        return OrgService.pagedOrganizationList(request, TokenService.ACCESS_TOKEN);
    }

    public static PagedOrgResult pagedOrganizationList(RequestPagedOrg request, String token) {
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        if (request.getOrgId() != null) {
            map.put("orgId", request.getOrgId());
        }
        map.put("pageSize", String.valueOf(request.getPageSize()));
        map.put("requestPage", String.valueOf(request.getRequestPage()));
        String path = PathConstants.TEAM_URL + "/org/paged";
        ResultWapper<PagedOrgResult> resultWapper = ClientUtils.get(path, map, PagedOrgResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }

    public static OrgBaseResult getOrganizationDetail(RequestOrg request) {
        return OrgService.getOrganizationDetail(request, TokenService.ACCESS_TOKEN);
    }

    public static OrgBaseResult getOrganizationDetail(RequestOrg request, String token) {
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        map.put("orgId", request.getOrgId());
        String path = PathConstants.TEAM_URL + "/org/detail";
        ResultWapper<OrgBaseResult> resultWapper = ClientUtils.get(path, map, OrgBaseResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }

    public static int sumUserOfOrganization(RequestOrg request) {
        return OrgService.sumUserOfOrganization(request, TokenService.ACCESS_TOKEN);
    }

    public static int sumUserOfOrganization(RequestOrg request, String token) {
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        map.put("orgId", request.getOrgId());
        String path = PathConstants.TEAM_URL + "/org/member/count";
        ResultWapper<SumUserResult> resultWapper = ClientUtils.get(path, map, SumUserResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMemberCount();
    }

    public static void deleteTheUnderlyingOrg(RequestOrg request) {
        OrgService.deleteTheUnderlyingOrg(request, TokenService.ACCESS_TOKEN);
    }

    public static void deleteTheUnderlyingOrg(RequestOrg request, String token) {
        String path;
        ResultWapper<BaseResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        if (request.getDomainId() == null) {
            try {
                request.setDomainId(JsonUtils.getDomainIdByToken(token));
            }
            catch (Exception e) {
                throw new IllegalRequestException(ErrorConstants.TOKEN_ERRPO);
            }
        }
        if ((resultWapper = ClientUtils.post(path = PathConstants.TEAM_URL + "/org/delete/json", token, JsonUtils.beanToJson(request), BaseResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
    }

    public static String createNewOrg(RequestNewOrg request) {
        return OrgService.createNewOrg(request, TokenService.ACCESS_TOKEN);
    }

    public static String createNewOrg(RequestNewOrg request, String token) {
        String path;
        ResultWapper<NewOrgResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        if (request.getDomainId() == null) {
            try {
                request.setDomainId(JsonUtils.getDomainIdByToken(token));
            }
            catch (Exception e) {
                throw new IllegalRequestException(ErrorConstants.TOKEN_ERRPO);
            }
        }
        if ((resultWapper = ClientUtils.post(path = PathConstants.TEAM_URL + "/org/create/json", token, JsonUtils.beanToJson(request), NewOrgResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getOrgId();
    }

    public static void updateOrg(RequestOrgName request) {
        OrgService.updateOrg(request, TokenService.ACCESS_TOKEN);
    }

    public static void updateOrg(RequestOrgName request, String token) {
        String path;
        ResultWapper<BaseResult> resultWapper;
        if (request == null) {
            throw new IllegalRequestException();
        }
        if (request.getDomainId() == null) {
            try {
                request.setDomainId(JsonUtils.getDomainIdByToken(token));
            }
            catch (Exception e) {
                throw new IllegalRequestException(ErrorConstants.TOKEN_ERRPO);
            }
        }
        if ((resultWapper = ClientUtils.post(path = PathConstants.TEAM_URL + "/org/update/json", token, JsonUtils.beanToJson(request), BaseResult.class)).isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
    }

    public static OrgSyncListResult synOrgInfo(RequestOrgSycInfo request) {
        return OrgService.synOrgInfo(request, TokenService.ACCESS_TOKEN);
    }

    public static OrgSyncListResult synOrgInfo(RequestOrgSycInfo request, String token) {
        if (request == null) {
            throw new IllegalRequestException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", token);
        if (request.getDomainId() != null) {
            map.put("domainId", request.getDomainId());
        }
        map.put("syncTime", String.valueOf(request.getSyncTime()));
        String path = PathConstants.TEAM_URL + "/org/sync";
        ResultWapper<OrgSyncListResult> resultWapper = ClientUtils.get(path, map, OrgSyncListResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult();
    }
}

