/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.service;

import com.cisdi.nudgeplus.sdk.constants.PathConstants;
import com.cisdi.nudgeplus.sdk.datamng.ClientUtils;
import com.cisdi.nudgeplus.sdk.exception.IllegalMessageException;
import com.cisdi.nudgeplus.sdk.exception.IllegalRequestException;
import com.cisdi.nudgeplus.sdk.service.TokenService;
import com.cisdi.nudgeplus.sdk.utils.ClassUtils;
import com.cisdi.nudgeplus.sdk.utils.JsonUtils;
import com.cisdi.nudgeplus.tmsbeans.beans.MessageResult;
import com.cisdi.nudgeplus.tmsbeans.beans.ResultWapper;
import com.cisdi.nudgeplus.tmsbeans.model.ImageMsg;
import com.cisdi.nudgeplus.tmsbeans.model.NewsMsg;
import com.cisdi.nudgeplus.tmsbeans.model.RichMsg;
import com.cisdi.nudgeplus.tmsbeans.model.ServiceMsg;
import com.cisdi.nudgeplus.tmsbeans.model.TextMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.basics.ServiceSendRequest;
import com.cisdi.nudgeplus.tmsbeans.model.request.media.MediaMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.news.NewsMsgArticle;
import com.cisdi.nudgeplus.tmsbeans.model.request.news.NewsMsgParam;
import java.util.List;

public class ServiceMessageService {
    public static String sendTextMsg(TextMsg textMsg) {
        return ServiceMessageService.sendTextMsg(textMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendTextMsg(TextMsg textMsg, String token) {
        if (textMsg == null) {
            throw new IllegalMessageException();
        }
        ServiceMsg msg = new ServiceMsg();
        msg.setMsgtype("text");
        msg.setText(textMsg);
        String path = PathConstants.BASE_URL + "/message/service/send";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMsgId();
    }

    public static String sendImageMsg(ImageMsg imageMsg) {
        return ServiceMessageService.sendImageMsg(imageMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendImageMsg(ImageMsg imageMsg, String token) {
        if (imageMsg == null) {
            throw new IllegalMessageException();
        }
        ServiceMsg msg = new ServiceMsg();
        msg.setMsgtype("image");
        msg.setImage(imageMsg);
        String path = PathConstants.BASE_URL + "/message/service/send";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMsgId();
    }

    public static String sendRichMsg(RichMsg richMsg) {
        return ServiceMessageService.sendRichMsg(richMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendRichMsg(RichMsg richMsg, String token) {
        if (richMsg == null) {
            throw new IllegalMessageException();
        }
        ServiceMsg msg = new ServiceMsg();
        msg.setMsgtype("richmsg");
        msg.setRichMsg(richMsg);
        String path = PathConstants.BASE_URL + "/message/service/send";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMsgId();
    }

    public static String sendNewsMsg(NewsMsg newsMsg) {
        return ServiceMessageService.sendNewsMsg(newsMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendNewsMsg(NewsMsg newsMsg, String token) {
        if (newsMsg == null) {
            throw new IllegalMessageException();
        }
        ServiceSendRequest<NewsMsgParam> msg = new ServiceSendRequest<NewsMsgParam>();
        List<NewsMsgArticle> newsMsgArticleList = ClassUtils.convertNewsMsg(newsMsg.getArticles());
        NewsMsgParam newsMsgParam = new NewsMsgParam();
        newsMsgParam.setArticle_list(newsMsgArticleList);
        msg.setMessage(newsMsgParam);
        String path = PathConstants.BASE_URL + "/message/news/send/service";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }

    public static String sendFileMsg(MediaMsg mediaMsg) {
        return ServiceMessageService.sendFileMsg(mediaMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendFileMsg(MediaMsg mediaMsg, String token) {
        if (mediaMsg == null) {
            throw new IllegalMessageException();
        }
        ServiceSendRequest<MediaMsg> msg = new ServiceSendRequest<MediaMsg>();
        msg.setMessage(mediaMsg);
        String path = PathConstants.BASE_URL + "/message/file/send/service";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }
}

