/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.service;

import com.cisdi.nudgeplus.sdk.constants.PathConstants;
import com.cisdi.nudgeplus.sdk.datamng.ClientUtils;
import com.cisdi.nudgeplus.sdk.exception.IllegalMessageException;
import com.cisdi.nudgeplus.sdk.exception.IllegalRequestException;
import com.cisdi.nudgeplus.sdk.service.TokenService;
import com.cisdi.nudgeplus.sdk.utils.ClassUtils;
import com.cisdi.nudgeplus.sdk.utils.JsonUtils;
import com.cisdi.nudgeplus.tmsbeans.beans.MessageResult;
import com.cisdi.nudgeplus.tmsbeans.beans.ResultWapper;
import com.cisdi.nudgeplus.tmsbeans.model.ImageMsg;
import com.cisdi.nudgeplus.tmsbeans.model.Msg;
import com.cisdi.nudgeplus.tmsbeans.model.NewsMsg;
import com.cisdi.nudgeplus.tmsbeans.model.RichMsg;
import com.cisdi.nudgeplus.tmsbeans.model.TextMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.basics.SingleSendRequest;
import com.cisdi.nudgeplus.tmsbeans.model.request.keyvalue.KeyValueMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.media.MediaMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.news.NewsMsgArticle;
import com.cisdi.nudgeplus.tmsbeans.model.request.news.NewsMsgParam;
import com.cisdi.nudgeplus.tmsbeans.model.request.process.ProcessMsg;
import com.cisdi.nudgeplus.tmsbeans.model.request.textcard.TextCardMsg;
import com.google.gson.internal.LinkedTreeMap;
import java.util.List;

public class SingleMessageService {
    public static String sendTextMsg(String toUser, TextMsg textMsg) {
        return SingleMessageService.sendTextMsg(toUser, textMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendTextMsg(String toUser, TextMsg textMsg, String token) {
        if (textMsg == null) {
            throw new IllegalMessageException();
        }
        Msg msg = new Msg();
        msg.setTouser(toUser);
        msg.setMsgtype("text");
        msg.setText(textMsg);
        String path = PathConstants.BASE_URL + "/message/single/send";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMsgId();
    }

    public static String sendImageMsg(String toUser, ImageMsg imageMsg) {
        return SingleMessageService.sendImageMsg(toUser, imageMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendImageMsg(String toUser, ImageMsg imageMsg, String token) {
        if (imageMsg == null) {
            throw new IllegalMessageException();
        }
        Msg msg = new Msg();
        msg.setTouser(toUser);
        msg.setMsgtype("image");
        msg.setImage(imageMsg);
        String path = PathConstants.BASE_URL + "/message/single/send";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMsgId();
    }

    public static String sendRichMsg(String toUser, RichMsg richMsg) {
        return SingleMessageService.sendRichMsg(toUser, richMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendRichMsg(String toUser, RichMsg richMsg, String token) {
        if (richMsg == null) {
            throw new IllegalMessageException();
        }
        Msg msg = new Msg();
        msg.setTouser(toUser);
        msg.setMsgtype("richmsg");
        msg.setRichMsg(richMsg);
        String path = PathConstants.BASE_URL + "/message/single/send";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getMsgId();
    }

    public static String sendNewsMsg(String toUser, NewsMsg newsMsg) {
        return SingleMessageService.sendNewsMsg(toUser, newsMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendNewsMsg(String toUser, NewsMsg newsMsg, String token) {
        if (newsMsg == null) {
            throw new IllegalMessageException();
        }
        SingleSendRequest<NewsMsgParam> msg = new SingleSendRequest<NewsMsgParam>();
        List<NewsMsgArticle> newsMsgArticleList = ClassUtils.convertNewsMsg(newsMsg.getArticles());
        NewsMsgParam newsMsgParam = new NewsMsgParam();
        newsMsgParam.setArticle_list(newsMsgArticleList);
        msg.setMessage(newsMsgParam);
        msg.setTo_user(toUser);
        String path = PathConstants.BASE_URL + "/message/news/send/single";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }

    public static String sendFileMsg(String toUser, MediaMsg mediaMsg) {
        return SingleMessageService.sendFileMsg(toUser, mediaMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendFileMsg(String toUser, MediaMsg mediaMsg, String token) {
        if (mediaMsg == null) {
            throw new IllegalMessageException();
        }
        SingleSendRequest<MediaMsg> msg = new SingleSendRequest<MediaMsg>();
        msg.setTo_user(toUser);
        msg.setMessage(mediaMsg);
        String path = PathConstants.BASE_URL + "/message/file/send/single";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }

    public static String sendTextCardMsg(String toUser, TextCardMsg textCardMsg) {
        return SingleMessageService.sendTextCardMsg(toUser, textCardMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendTextCardMsg(String toUser, TextCardMsg textCardMsg, String token) {
        if (textCardMsg == null) {
            throw new IllegalMessageException();
        }
        SingleSendRequest<TextCardMsg> msg = new SingleSendRequest<TextCardMsg>();
        msg.setTo_user(toUser);
        msg.setMessage(textCardMsg);
        String path = PathConstants.BASE_URL + "/message/textCard/send/single";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }

    public static String sendKeyValueMsg(String toUser, KeyValueMsg keyValueMsg) {
        return SingleMessageService.sendKeyValueMsg(toUser, keyValueMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendKeyValueMsg(String toUser, KeyValueMsg keyValueMsg, String token) {
        if (keyValueMsg == null) {
            throw new IllegalMessageException();
        }
        SingleSendRequest<KeyValueMsg> msg = new SingleSendRequest<KeyValueMsg>();
        msg.setTo_user(toUser);
        msg.setMessage(keyValueMsg);
        String path = PathConstants.BASE_URL + "/message/keyValue/send/single";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return resultWapper.getResult().getData().toString();
    }

    public static String sendProcessMsg(String toUser, ProcessMsg processMsg) {
        return SingleMessageService.sendProcessMsg(toUser, processMsg, TokenService.ACCESS_TOKEN);
    }

    public static String sendProcessMsg(String toUser, ProcessMsg processMsg, String token) {
        if (processMsg == null) {
            throw new IllegalMessageException();
        }
        SingleSendRequest<ProcessMsg> msg = new SingleSendRequest<ProcessMsg>();
        msg.setTo_user(toUser);
        msg.setMessage(processMsg);
        String path = PathConstants.BASE_URL + "/message/process/send/single";
        ResultWapper<MessageResult> resultWapper = ClientUtils.post(path, token, JsonUtils.beanToJson(msg), MessageResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        return (String)((LinkedTreeMap)resultWapper.getResult().getData()).get((Object)"msg_id");
    }
}

