/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.service;

import com.cisdi.nudgeplus.sdk.constants.PathConstants;
import com.cisdi.nudgeplus.sdk.datamng.ClientUtils;
import com.cisdi.nudgeplus.sdk.exception.IllegalRequestException;
import com.cisdi.nudgeplus.sdk.utils.NudgePlusConfig;
import com.cisdi.nudgeplus.tmsbeans.beans.ResultWapper;
import com.cisdi.nudgeplus.tmsbeans.beans.TokenResult;
import java.util.HashMap;

public class TokenService {
    public static String ACCESS_TOKEN = "";

    public static synchronized void refreshToken(String appid, String secret) {
        TokenResult token = null;
        try {
            token = TokenService.getToken(appid, secret);
        }
        catch (IllegalRequestException e) {
            e.printStackTrace();
        }
        if (token != null) {
            ACCESS_TOKEN = token.getAccessToken();
        }
    }

    public static TokenResult getToken(String appid, String secret) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("grant_type", "client_credential");
        queryParams.put("appid", appid);
        queryParams.put("secret", secret);
        String path = PathConstants.BASE_URL + "/token";
        ResultWapper<TokenResult> resultWapper = ClientUtils.get(path, queryParams, TokenResult.class);
        if (resultWapper.isError()) {
            throw new IllegalRequestException(resultWapper.getErrorResult());
        }
        TokenResult token = resultWapper.getResult();
        return token;
    }

    public static TokenResult getToken() {
        return TokenService.getToken(NudgePlusConfig.getValue("APP_ID"), NudgePlusConfig.getValue("APP_SECRET"));
    }
}

