/*
 * Decompiled with CFR 0.152.
 */
package com.cisdi.nudgeplus.sdk.utils;

import com.cisdi.nudgeplus.sdk.utils.AesException;
import com.cisdi.nudgeplus.sdk.utils.ByteGroup;
import com.cisdi.nudgeplus.sdk.utils.PKCS7Encoder;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class QTBizMsgCrypt {
    static Charset CHARSET = Charset.forName("utf-8");
    Base64 base64 = new Base64();
    byte[] aesKey;
    String token;

    public QTBizMsgCrypt(String token, String encodingAesKey) {
        if (encodingAesKey.length() != 43) {
            try {
                throw new AesException(-50004);
            }
            catch (AesException e) {
                e.printStackTrace();
            }
        }
        this.token = token;
        this.aesKey = Base64.decodeBase64((String)(encodingAesKey + "="));
    }

    public String encrypt(String text) throws AesException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] textBytes = text.getBytes(CHARSET);
        byteCollector.addBytes(textBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            String base64Encrypted = this.base64.encodeToString(encrypted);
            return base64Encrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-50006);
        }
    }

    public String decrypt(String text) throws AesException {
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64.decodeBase64((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-50007);
        }
        return new String(original).trim();
    }
}

