/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util.i18n;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.annotation.processing.AnnotationProcessor;
import jlibs.core.annotation.processing.Environment;
import jlibs.core.lang.model.ModelUtil;
import jlibs.core.util.i18n.Bundle;
import jlibs.core.util.i18n.Bundles;
import jlibs.core.util.i18n.Interfaces;
import jlibs.core.util.i18n.PropertiesUtil;
import jlibs.core.util.i18n.ResourceBundle;

@SupportedAnnotationTypes(value={"jlibs.core.util.i18n.ResourceBundle", "jlibs.core.util.i18n.Bundle"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"ResourceBundle.basename"})
public class BundleAnnotationProcessor
extends AnnotationProcessor {
    private static String basename;
    private static Map<String, Info> infos;

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block24: {
            basename = Environment.get().getOptions().get("ResourceBundle.basename");
            if (basename == null) {
                basename = "Bundle";
            }
            try {
                for (TypeElement annotation : annotations) {
                    if (annotation.getQualifiedName().contentEquals(ResourceBundle.class.getName())) {
                        for (Element elem : roundEnv.getElementsAnnotatedWith(annotation)) {
                            TypeElement c = (TypeElement)elem;
                            String pakage = ModelUtil.getPackage((Element)c);
                            if (c.getKind() != ElementKind.INTERFACE) {
                                throw new AnnotationError(elem, ResourceBundle.class.getName() + " annotation can be applied only for interface");
                            }
                            Info info = infos.get(pakage);
                            if (info == null) {
                                info = new Info(c, ModelUtil.getAnnotationMirror((Element)c, ResourceBundle.class));
                                infos.put(pakage, info);
                            }
                            info.addResourceBundle(c);
                        }
                        continue;
                    }
                    for (Element elem : roundEnv.getElementsAnnotatedWith(annotation)) {
                        String pakage = ModelUtil.getPackage((Element)elem);
                        Info info = infos.get(pakage);
                        if (info == null) {
                            info = new Info(elem, ModelUtil.getAnnotationMirror((Element)elem, Bundle.class));
                            infos.put(pakage, info);
                        }
                        info.addBundle(elem);
                    }
                }
                for (Info info : infos.values()) {
                    info.generate();
                }
            }
            catch (AnnotationError error) {
                error.report();
                break block24;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                for (Info info : infos.values()) {
                    try {
                        info.close();
                    }
                    catch (IOException ignore) {}
                }
                infos.clear();
            }
            for (Info info : infos.values()) {
                try {
                    info.close();
                }
                catch (IOException ignore) {}
            }
            infos.clear();
        }
        return true;
    }

    static {
        infos = new HashMap<String, Info>();
    }

    private static class Info {
        private String pakage;
        private BufferedWriter props;
        private Map<String, Element> entries = new HashMap<String, Element>();
        private Interfaces interfaces;
        private Bundles bundles;

        public Info(Element element, AnnotationMirror mirror) throws IOException {
            this.pakage = ModelUtil.getPackage((Element)element);
            if (ModelUtil.exists((String)this.pakage, (String)(basename + ".properties"))) {
                throw new AnnotationError(element, mirror, basename + ".properties in package " + this.pakage + " already exists in source path");
            }
            FileObject resource = Environment.get().getFiler().createResource(StandardLocation.CLASS_OUTPUT, this.pakage, basename + ".properties", new Element[0]);
            this.props = new BufferedWriter(resource.openWriter());
        }

        public void addResourceBundle(TypeElement clazz) throws IOException {
            if (this.interfaces == null) {
                this.interfaces = new Interfaces(this.entries);
            }
            this.interfaces.add(clazz);
        }

        public void addBundle(Element element) throws IOException {
            if (this.bundles == null) {
                this.bundles = new Bundles();
            }
            this.bundles.add(element);
        }

        public void generate() throws IOException {
            PropertiesUtil.writeComments(this.props, " DON'T EDIT THIS FILE. THIS IS GENERATED BY JLIBS");
            PropertiesUtil.writeComments(this.props, " @author Santhosh Kumar T");
            this.props.newLine();
            if (this.interfaces != null) {
                this.interfaces.generateClass(basename);
                this.interfaces.generateProperties(this.props);
            }
            if (this.bundles != null) {
                this.bundles.generateProperties(this.entries, this.props);
            }
            this.close();
        }

        public void close() throws IOException {
            if (this.interfaces != null) {
                this.interfaces.close();
                this.interfaces = null;
            }
            if (this.props != null) {
                this.props.close();
                this.props = null;
            }
        }
    }
}

