/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util.i18n;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.annotation.processing.Environment;
import jlibs.core.annotation.processing.Printer;
import jlibs.core.lang.StringUtil;
import jlibs.core.lang.model.ModelUtil;
import jlibs.core.util.i18n.LocaleContext;
import jlibs.core.util.i18n.Message;
import jlibs.core.util.i18n.PropertiesUtil;
import jlibs.core.util.i18n.ResourceBundle;

class Interfaces {
    private List<String> interfaces = new ArrayList<String>();
    private Printer printer;
    private Map<String, ExecutableElement> entries;
    private Map<Element, Map<String, ExecutableElement>> classes = new HashMap<Element, Map<String, ExecutableElement>>();

    Interfaces(Map entries) {
        this.entries = entries;
    }

    public void add(TypeElement clazz) throws IOException {
        if (this.printer == null) {
            this.printer = Printer.get((TypeElement)clazz, ResourceBundle.class, (String)"${package}._Bundle");
        }
        this.interfaces.add(clazz.getSimpleName().toString());
        while (clazz != null && !clazz.getQualifiedName().contentEquals(Object.class.getName())) {
            for (ExecutableElement method : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                this.add(method);
            }
            clazz = ModelUtil.getSuper((TypeElement)clazz);
        }
    }

    private void add(ExecutableElement method) {
        AnnotationMirror mirror = ModelUtil.getAnnotationMirror((Element)method, Message.class);
        if (mirror == null) {
            throw new AnnotationError((Element)method, Message.class.getName() + " annotation is missing on this method");
        }
        if (!ModelUtil.isAssignable((TypeMirror)method.getReturnType(), String.class)) {
            if (!ModelUtil.isAssignable((TypeMirror)method.getReturnType(), Throwable.class)) {
                throw new AnnotationError((Element)method, "method annotated with " + Message.class.getName() + " must return java.lang.String or a subclass of java.lang.Throwable");
            }
            Element element = ((DeclaredType)method.getReturnType()).asElement();
            boolean foundValidConstructor = false;
            for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                List<? extends VariableElement> params = constructor.getParameters();
                if (params.size() != 2 || !ModelUtil.isAssignable((TypeMirror)params.get(0).asType(), String.class) || !ModelUtil.isAssignable((TypeMirror)params.get(1).asType(), String.class)) continue;
                foundValidConstructor = true;
                break;
            }
            if (!foundValidConstructor) {
                String className = ModelUtil.toString((TypeMirror)method.getReturnType(), (boolean)false);
                throw new AnnotationError((Element)method, "Constructor " + className + "(String errorCode, String message) not found");
            }
        }
        String signature = ModelUtil.signature((ExecutableElement)method, (boolean)false);
        for (ExecutableElement m : this.entries.values()) {
            if (!signature.equals(ModelUtil.signature((ExecutableElement)m, (boolean)false))) continue;
            throw new AnnotationError((Element)method, "clashes with similar method in " + m.getEnclosingElement() + " interface");
        }
        AnnotationMirror messageMirror = ModelUtil.getAnnotationMirror((Element)method, Message.class);
        String key = (String)ModelUtil.getAnnotationValue((Element)method, (AnnotationMirror)messageMirror, (String)"key");
        if (StringUtil.isEmpty((CharSequence)key)) {
            key = method.getSimpleName().toString();
        }
        ExecutableElement clash = this.entries.put(key, method);
        Element interfase = method.getEnclosingElement();
        if (clash != null) {
            throw new AnnotationError((Element)method, "key '" + key + "' is already used by \"" + ModelUtil.signature((ExecutableElement)clash, (boolean)false) + "\" in " + clash.getEnclosingElement() + " interface");
        }
        Map<String, ExecutableElement> methods = this.classes.get(interfase);
        if (methods == null) {
            methods = new HashMap<String, ExecutableElement>();
            this.classes.put(interfase, methods);
        }
        methods.put(key, method);
    }

    /*
     * WARNING - void declaration
     */
    public void generateClass(String basename) throws IOException {
        this.printer.printPackage();
        this.printer.importClass(java.util.ResourceBundle.class);
        this.printer.importClass(MessageFormat.class);
        this.printer.importClass(LocaleContext.class);
        this.printer.emptyLine(true);
        this.printer.printClassDoc();
        this.printer.println("@SuppressWarnings(\"unchecked\")");
        this.printer.println("public class " + this.printer.generatedClazz + " implements " + StringUtil.join(this.interfaces.iterator(), (String)", ") + "{");
        ++this.printer.indent;
        this.printer.println("public static final " + this.printer.generatedClazz + " INSTANCE = new " + this.printer.generatedClazz + "();");
        this.printer.emptyLine(true);
        this.printer.printlns(new String[]{"private final ResourceBundle BUNDLE(){", "indent++", "return ResourceBundle.getBundle(\"" + this.printer.generatedPakage.replace('.', '/') + "/" + basename + "\", LocaleContext.getLocale());", "indent--", "}"});
        this.printer.emptyLine(true);
        for (Map.Entry<Element, Map<String, ExecutableElement>> methods : this.classes.entrySet()) {
            this.printer.emptyLine(true);
            this.printer.println("/*-------------------------------------------------[ " + methods.getKey().getSimpleName() + " ]---------------------------------------------------*/");
            this.printer.emptyLine(true);
            for (Map.Entry<String, ExecutableElement> entry : methods.getValue().entrySet()) {
                String key = entry.getKey();
                ExecutableElement method = entry.getValue();
                this.printer.println("@Override");
                boolean returnsException = ModelUtil.isAssignable((TypeMirror)method.getReturnType(), Throwable.class);
                String returnType = returnsException ? ModelUtil.toString((TypeMirror)method.getReturnType(), (boolean)false) : "String";
                this.printer.print("public " + returnType + " " + method.getSimpleName() + "(");
                int i = 0;
                StringBuilder params = new StringBuilder();
                for (VariableElement variableElement : method.getParameters()) {
                    String paramName = variableElement.getSimpleName().toString();
                    params.append(", ");
                    if (i > 0) {
                        this.printer.print(", ");
                    }
                    params.append(paramName);
                    this.printer.print(ModelUtil.toString((TypeMirror)variableElement.asType(), (boolean)false) + " " + paramName);
                    ++i;
                }
                if (params.length() == 0) {
                    params.append(", new Object[0]");
                }
                this.printer.println("){");
                ++this.printer.indent;
                String message = "MessageFormat.format(BUNDLE().getString(\"" + key + "\")" + params + ")";
                if (returnsException) {
                    void var13_19;
                    int packageIgnoreCount;
                    String string = this.printer.generatedPakage;
                    String option = Environment.get().getOptions().get("ResourceBundle.ignorePackageCount");
                    int n = packageIgnoreCount = option == null ? 2 : Integer.parseInt(option);
                    if (packageIgnoreCount == -1) {
                        String string2 = "";
                    } else {
                        void var13_17;
                        int dot;
                        for (int j = 0; j < packageIgnoreCount && (dot = var13_17.indexOf(".")) != -1; ++j) {
                            String string3 = var13_17.substring(dot + 1);
                        }
                    }
                    String errorCode = StringUtil.capitalize((String)key);
                    if (!var13_19.isEmpty()) {
                        errorCode = (String)var13_19 + "." + errorCode;
                    }
                    this.printer.println(" return new " + returnType + "(\"" + errorCode + "\", " + message + ");");
                } else {
                    this.printer.println("return " + message + ";");
                }
                --this.printer.indent;
                this.printer.println("}");
            }
        }
        --this.printer.indent;
        this.printer.println("}");
        this.close();
    }

    public void generateProperties(BufferedWriter props) throws IOException {
        Elements elemUtil = Environment.get().getElementUtils();
        for (Map.Entry<Element, Map<String, ExecutableElement>> methods : this.classes.entrySet()) {
            PropertiesUtil.writeComments(props, "-------------------------------------------------[ " + methods.getKey().getSimpleName() + " ]---------------------------------------------------");
            props.newLine();
            for (Map.Entry<String, ExecutableElement> entry : methods.getValue().entrySet()) {
                int argCount;
                String key = entry.getKey();
                ExecutableElement method = entry.getValue();
                String doc = elemUtil.getDocComment(method);
                String methodDoc = ModelUtil.getMethodDoc((String)doc);
                if (!StringUtil.isEmpty((CharSequence)methodDoc)) {
                    PropertiesUtil.writeComments(props, " " + methodDoc);
                }
                int i = 0;
                Map paramDocs = ModelUtil.getMethodParamDocs((String)doc);
                for (VariableElement variableElement : method.getParameters()) {
                    String paramName = variableElement.getSimpleName().toString();
                    String paramDoc = (String)paramDocs.get(paramName);
                    if (StringUtil.isEmpty((CharSequence)paramDoc)) {
                        PropertiesUtil.writeComments(props, " {" + i + "} " + paramName);
                    } else {
                        PropertiesUtil.writeComments(props, " {" + i + "} " + paramName + " ==> " + paramDoc);
                    }
                    ++i;
                }
                AnnotationMirror messageMirror = ModelUtil.getAnnotationMirror((Element)method, Message.class);
                String string = (String)ModelUtil.getAnnotationValue((Element)method, (AnnotationMirror)messageMirror, (String)"value");
                try {
                    new MessageFormat(string);
                }
                catch (IllegalArgumentException ex) {
                    throw new AnnotationError((Element)method, messageMirror, ModelUtil.getRawAnnotationValue((Element)method, (AnnotationMirror)messageMirror, (String)"value"), "Invalid Message Format: " + ex.getMessage());
                }
                NavigableSet<Integer> args = PropertiesUtil.findArgs(string);
                int n = argCount = args.size() == 0 ? 0 : (Integer)args.last() + 1;
                if (argCount != method.getParameters().size()) {
                    throw new AnnotationError((Element)method, "no of args in message format doesn't match with the number of parameters this method accepts");
                }
                for (i = 0; i < argCount; ++i) {
                    if (args.remove(i)) continue;
                    throw new AnnotationError((Element)method, messageMirror, "{" + i + "} is missing in message");
                }
                PropertiesUtil.writeProperty(props, key, string);
                props.newLine();
            }
        }
    }

    public void close() throws IOException {
        if (this.printer != null) {
            this.printer.close();
            this.printer = null;
        }
    }
}

