/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.futures;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class FutureUtils {
    public static <T> CompletableFuture<T> toCompletableFuture(ListenableFuture<T> listenableFuture, ExecutorService executor) {
        final CompletableListenableFuture<T> completable = new CompletableListenableFuture<T>(listenableFuture);
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                completable.complete(result);
            }

            public void onFailure(Throwable t) {
                completable.completeExceptionally(t);
            }
        }, (Executor)executor);
        return completable;
    }

    private static final class CompletableListenableFuture<T>
    extends CompletableFuture<T> {
        private final ListenableFuture<T> listenableFuture;

        public CompletableListenableFuture(ListenableFuture<T> listenableFuture) {
            this.listenableFuture = listenableFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = this.listenableFuture.cancel(mayInterruptIfRunning);
            super.cancel(mayInterruptIfRunning);
            return result;
        }
    }
}

