/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.statement;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.StatementWrapper;
import com.datastax.driver.core.StatementWrapperUtils;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Update;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementHelper {
    public static final String BEGIN_BATCH = "begin batch";
    public static final String OTHER_STATEMENT = "other statement";
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementHelper.class);
    private static final Pattern SELECT_PATTERN = Pattern.compile("select .*");
    private static final Pattern INSERT_PATTERN = Pattern.compile("insert .*");
    private static final Pattern UPDATE_PATTERN = Pattern.compile("update .*");
    private static final Pattern DELETE_PATTERN = Pattern.compile("delete .*");
    private static final Pattern BATCH_PATTERN = Pattern.compile("begin\\w*batch .*");

    public static String maybeGetNormalizedQueryString(Statement statement) {
        return StatementHelper.normalizeQueryString(StatementHelper.maybeGetQueryString(statement));
    }

    public static String normalizeQueryString(String queryString) {
        return queryString.toLowerCase().trim().replaceAll("\n", "");
    }

    public static boolean isSelectStatement(Statement statement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Is '%s' Select statement ? ", statement.toString()));
        }
        return SELECT_PATTERN.matcher(StatementHelper.maybeGetNormalizedQueryString(statement)).matches();
    }

    public static boolean isSelectStatement(PreparedStatement preparedStatement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Is '%s' Select statement ? ", preparedStatement.getQueryString()));
        }
        String queryString = preparedStatement.getQueryString().toLowerCase().trim().replaceAll("\n", "");
        return SELECT_PATTERN.matcher(queryString).matches();
    }

    public static boolean isInsertStatement(Statement statement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Is '%s' Insert statement ? ", statement.toString()));
        }
        if (StatementHelper.isSimpleStatement(statement)) {
            return INSERT_PATTERN.matcher(StatementHelper.maybeGetNormalizedQueryString(statement)).matches();
        }
        return statement instanceof Insert || statement instanceof Insert.Options;
    }

    public static boolean isUpdateStatement(Statement statement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Is '%s' Update statement ? ", statement.toString()));
        }
        if (StatementHelper.isSimpleStatement(statement)) {
            return UPDATE_PATTERN.matcher(StatementHelper.maybeGetNormalizedQueryString(statement)).matches();
        }
        return statement instanceof Update.Where || statement instanceof Update.Options;
    }

    public static boolean isDeleteStatement(Statement statement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Is '%s' Delete statement ? ", statement.toString()));
        }
        if (StatementHelper.isSimpleStatement(statement)) {
            return DELETE_PATTERN.matcher(StatementHelper.maybeGetNormalizedQueryString(statement)).matches();
        }
        return statement instanceof Delete.Where || statement instanceof Delete.Options;
    }

    public static boolean isBatchStatement(Statement statement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Is '%s' Batch statement ? ", statement.toString()));
        }
        return statement instanceof BatchStatement || BATCH_PATTERN.matcher(StatementHelper.maybeGetNormalizedQueryString(statement)).matches();
    }

    public static boolean isUpsertStatement(Statement statement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Is '%s' Upsert statement ? ", statement.toString()));
        }
        return StatementHelper.isInsertStatement(statement) || StatementHelper.isUpdateStatement(statement) || StatementHelper.isBatchStatement(statement);
    }

    public static boolean isSimpleStatement(Statement statement) {
        return statement instanceof SimpleStatement;
    }

    public static boolean isDMLStatement(Statement statement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Is '%s' DML statement ? ", statement.toString()));
        }
        return StatementHelper.isSelectStatement(statement) || StatementHelper.isUpsertStatement(statement) || StatementHelper.isDeleteStatement(statement);
    }

    private static String maybeGetQueryString(Statement statement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Maybe get query string from %s ", statement.toString()));
        }
        if (statement instanceof RegularStatement) {
            return ((RegularStatement)statement).getQueryString();
        }
        if (statement instanceof BoundStatement) {
            return ((BoundStatement)statement).preparedStatement().getQueryString();
        }
        if (statement instanceof BatchStatement) {
            return BEGIN_BATCH;
        }
        if (statement instanceof StatementWrapper) {
            return StatementHelper.maybeGetQueryString(StatementWrapperUtils.getWrappedStatement((StatementWrapper)statement));
        }
        return OTHER_STATEMENT;
    }
}

