/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.counter.AchillesCounter;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.consistency.ConsistencyConverter;
import info.archinnov.achilles.internal.consistency.ConsistencyOverrider;
import info.archinnov.achilles.internal.context.facade.DaoOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.internal.statement.StatementGenerator;
import info.archinnov.achilles.internal.statement.cache.CacheManager;
import info.archinnov.achilles.internal.statement.cache.StatementCacheKey;
import info.archinnov.achilles.internal.statement.prepared.PreparedStatementBinder;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.internal.statement.wrapper.BoundStatementWrapper;
import info.archinnov.achilles.internal.statement.wrapper.RegularStatementWrapper;
import info.archinnov.achilles.internal.utils.Pair;
import info.archinnov.achilles.listener.LWTResultListener;
import info.archinnov.achilles.query.slice.SliceQueryProperties;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoContext {
    private static final Logger log = LoggerFactory.getLogger(DaoContext.class);
    protected Cache<StatementCacheKey, PreparedStatement> dynamicPSCache;
    protected Map<Class<?>, PreparedStatement> selectPSs;
    protected Map<AchillesCounter.CQLQueryType, PreparedStatement> counterQueryMap;
    protected Map<Class<?>, Map<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>>> clusteredCounterQueryMap;
    protected Session session;
    protected CacheManager cacheManager;
    protected PreparedStatementBinder binder = PreparedStatementBinder.Singleton.INSTANCE.get();
    protected StatementGenerator statementGenerator = StatementGenerator.Singleton.INSTANCE.get();
    protected ConsistencyOverrider overrider = ConsistencyOverrider.Singleton.INSTANCE.get();
    protected AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();
    protected ExecutorService executorService;
    protected static final Function<ResultSet, Row> RESULTSET_TO_ROW = new Function<ResultSet, Row>(){

        public Row apply(ResultSet resultSet) {
            return resultSet.one();
        }
    };

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void pushInsertStatement(DaoOperations context, List<PropertyMeta> pms) {
        log.debug("Push insert statement for PersistenceContext '{}' and properties '{}'", (Object)context, pms);
        PreparedStatement ps = this.cacheManager.getCacheForEntityInsert(this.session, this.dynamicPSCache, context, pms);
        BoundStatementWrapper bsWrapper = this.binder.bindForInsert(context, ps, pms);
        context.pushStatement(bsWrapper);
    }

    public void pushUpdateStatement(DaoOperations context, List<PropertyMeta> pms) {
        log.debug("Push update statement for PersistenceContext '{}' and properties '{}'", (Object)context, pms);
        PreparedStatement ps = this.cacheManager.getCacheForFieldsUpdate(this.session, this.dynamicPSCache, context, pms);
        BoundStatementWrapper bsWrapper = this.binder.bindForUpdate(context, ps, pms);
        context.pushStatement(bsWrapper);
    }

    public void pushCollectionAndMapUpdateStatement(DaoOperations context, DirtyCheckChangeSet changeSet) {
        CollectionAndMapChangeType changeType = changeSet.getChangeType();
        PropertyMeta propertyMeta = changeSet.getPropertyMeta();
        if (log.isDebugEnabled()) {
            log.debug("Push update statement for PersistenceContext '{}' and collection/map property '{}' for change type '{}'", new Object[]{context, propertyMeta, changeType});
        }
        if (changeType == CollectionAndMapChangeType.SET_TO_LIST_AT_INDEX || changeType == CollectionAndMapChangeType.REMOVE_FROM_LIST_AT_INDEX) {
            info.archinnov.achilles.type.ConsistencyLevel writeLevel = this.overrider.getWriteLevel(context);
            Pair<Update.Where, Object[]> pair = this.statementGenerator.generateCollectionAndMapUpdateOperation(context, changeSet);
            if (context.getOptions().isIfExists()) {
                ((Update.Where)pair.left).ifExists();
            }
            context.pushStatement(new RegularStatementWrapper(context.getEntityClass(), (RegularStatement)pair.left, (Object[])pair.right, ConsistencyConverter.getCQLLevel(writeLevel), context.getLWTResultListener(), context.getSerialConsistencyLevel()));
        } else {
            PreparedStatement ps = this.cacheManager.getCacheForCollectionAndMapOperation(this.session, this.dynamicPSCache, context, propertyMeta, changeSet);
            BoundStatementWrapper bsWrapper = this.binder.bindForCollectionAndMapUpdate(context, ps, changeSet);
            context.pushStatement(bsWrapper);
        }
    }

    public Row loadProperty(DaoOperations context, PropertyMeta pm) {
        log.debug("Load property '{}' for PersistenceContext '{}'", (Object)pm, (Object)context);
        PreparedStatement ps = this.cacheManager.getCacheForFieldSelect(this.session, this.dynamicPSCache, context, pm);
        ListenableFuture<ResultSet> resultSetFuture = this.executeReadWithConsistency(context, ps, pm.structure().isStaticColumn());
        ListenableFuture<Row> futureRows = this.asyncUtils.transformFuture(resultSetFuture, RESULTSET_TO_ROW);
        return this.asyncUtils.buildInterruptible(futureRows).getImmediately();
    }

    public void bindForDeletion(DaoOperations context, EntityMeta entityMeta) {
        log.debug("Push delete statement for PersistenceContext '{}'", (Object)context);
        PreparedStatement preparedStatement = this.cacheManager.getCacheForDeletion(this.session, this.dynamicPSCache, context);
        info.archinnov.achilles.type.ConsistencyLevel consistencyLevel = this.overrider.getWriteLevel(context);
        BoundStatementWrapper bsWrapper = this.binder.bindForDeletion(context, preparedStatement, entityMeta.structure().hasOnlyStaticColumns(), consistencyLevel);
        context.pushStatement(bsWrapper);
    }

    public void bindForSimpleCounterIncrement(DaoOperations context, PropertyMeta counterMeta, Long increment) {
        log.debug("Push simple counter increment statement for PersistenceContext '{}' and value '{}'", (Object)context, (Object)increment);
        PreparedStatement ps = this.counterQueryMap.get((Object)AchillesCounter.CQLQueryType.INCR);
        info.archinnov.achilles.type.ConsistencyLevel writeLevel = this.overrider.getWriteLevel(context, counterMeta);
        BoundStatementWrapper bsWrapper = this.binder.bindForSimpleCounterIncrementDecrement(context, ps, counterMeta, increment, writeLevel);
        context.pushCounterStatement(bsWrapper);
    }

    public ListenableFuture<ResultSet> incrementSimpleCounter(DaoOperations context, PropertyMeta counterMeta, Long increment, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel) {
        log.debug("Increment immediately simple counter for PersistenceContext '{}' and value '{}'", (Object)context, (Object)increment);
        PreparedStatement ps = this.counterQueryMap.get((Object)AchillesCounter.CQLQueryType.INCR);
        BoundStatementWrapper bsWrapper = this.binder.bindForSimpleCounterIncrementDecrement(context, ps, counterMeta, increment, consistencyLevel);
        return context.executeImmediate(bsWrapper);
    }

    public ListenableFuture<ResultSet> decrementSimpleCounter(DaoOperations context, PropertyMeta counterMeta, Long decrement, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel) {
        log.debug("Decrement immediately simple counter for PersistenceContext '{}' and value '{}'", (Object)context, (Object)decrement);
        PreparedStatement ps = this.counterQueryMap.get((Object)AchillesCounter.CQLQueryType.DECR);
        BoundStatementWrapper bsWrapper = this.binder.bindForSimpleCounterIncrementDecrement(context, ps, counterMeta, decrement, consistencyLevel);
        return context.executeImmediate(bsWrapper);
    }

    public Long getSimpleCounter(DaoOperations context, PropertyMeta counterMeta, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel) {
        if (log.isDebugEnabled()) {
            log.debug("Get simple counter value for counterMeta '{}' PersistenceContext '{}' using Consistency level '{}'", new Object[]{counterMeta, context, consistencyLevel});
        }
        PreparedStatement ps = this.counterQueryMap.get((Object)AchillesCounter.CQLQueryType.SELECT);
        BoundStatementWrapper bsWrapper = this.binder.bindForSimpleCounterSelect(context, ps, counterMeta, consistencyLevel);
        ListenableFuture<ResultSet> resultSetFuture = context.executeImmediate(bsWrapper);
        ListenableFuture<Row> futureRow = this.asyncUtils.transformFuture(resultSetFuture, RESULTSET_TO_ROW);
        Row row = this.asyncUtils.buildInterruptible(futureRow).getImmediately();
        return (Long)this.rowToLongFunction("counter_value").apply((Object)row);
    }

    public void bindForSimpleCounterDelete(DaoOperations context, PropertyMeta counterMeta) {
        log.debug("Push simple counter deletion statement for counterMeta '{}' and PersistenceContext '{}'", (Object)counterMeta, (Object)context);
        PreparedStatement ps = this.counterQueryMap.get((Object)AchillesCounter.CQLQueryType.DELETE);
        BoundStatementWrapper bsWrapper = this.binder.bindForSimpleCounterDelete(context, ps, counterMeta);
        context.pushCounterStatement(bsWrapper);
    }

    public void pushClusteredCounterIncrementStatement(DaoOperations context, PropertyMeta counterMeta, Long increment) {
        if (log.isDebugEnabled()) {
            log.debug("Push clustered counter increment statement for counterMeta '{}' and PersistenceContext '{}' and value '{}'", new Object[]{counterMeta, context, increment});
        }
        PreparedStatement ps = this.clusteredCounterQueryMap.get(context.getEntityClass()).get((Object)AchillesCounter.CQLQueryType.INCR).get(counterMeta.getPropertyName());
        BoundStatementWrapper bsWrapper = this.binder.bindForClusteredCounterIncrementDecrement(context, ps, counterMeta, increment);
        context.pushCounterStatement(bsWrapper);
    }

    public ListenableFuture<Row> getClusteredCounter(DaoOperations context) {
        log.debug("Get clustered counter for PersistenceContext '{}'", (Object)context);
        EntityMeta entityMeta = context.getEntityMeta();
        PreparedStatement ps = this.clusteredCounterQueryMap.get(entityMeta.getEntityClass()).get((Object)AchillesCounter.CQLQueryType.SELECT).get(AchillesCounter.ClusteredCounterStatement.SELECT_ALL.name());
        info.archinnov.achilles.type.ConsistencyLevel consistencyLevel = this.overrider.getReadLevel(context);
        BoundStatementWrapper bsWrapper = this.binder.bindForClusteredCounterSelect(context, ps, false, consistencyLevel);
        ListenableFuture<ResultSet> resultSetFuture = context.executeImmediate(bsWrapper);
        return this.asyncUtils.transformFuture(resultSetFuture, RESULTSET_TO_ROW);
    }

    public Long getClusteredCounterColumn(DaoOperations context, PropertyMeta counterMeta) {
        log.debug("Get clustered counter for PersistenceContext '{}'", (Object)context);
        String propertyName = counterMeta.getPropertyName();
        String cqlColumnName = counterMeta.getCQLColumnName();
        PreparedStatement ps = this.clusteredCounterQueryMap.get(context.getEntityClass()).get((Object)AchillesCounter.CQLQueryType.SELECT).get(propertyName);
        info.archinnov.achilles.type.ConsistencyLevel readLevel = this.overrider.getReadLevel(context, counterMeta);
        BoundStatementWrapper bsWrapper = this.binder.bindForClusteredCounterSelect(context, ps, counterMeta.structure().isStaticColumn(), readLevel);
        ListenableFuture<ResultSet> resultSetFuture = context.executeImmediate(bsWrapper);
        ListenableFuture<Row> futureRow = this.asyncUtils.transformFuture(resultSetFuture, RESULTSET_TO_ROW);
        Row row = this.asyncUtils.buildInterruptible(futureRow).getImmediately();
        return (Long)this.rowToLongFunction(cqlColumnName).apply((Object)row);
    }

    public void bindForClusteredCounterDelete(DaoOperations context) {
        log.debug("Push clustered counter deletion statement for PersistenceContext '{}'", (Object)context);
        PreparedStatement ps = this.clusteredCounterQueryMap.get(context.getEntityClass()).get((Object)AchillesCounter.CQLQueryType.DELETE).get(AchillesCounter.ClusteredCounterStatement.DELETE_ALL.name());
        BoundStatementWrapper bsWrapper = this.binder.bindForClusteredCounterDelete(context, ps);
        context.pushCounterStatement(bsWrapper);
    }

    public ListenableFuture<Row> loadEntity(DaoOperations context) {
        log.debug("Load entity for PersistenceContext '{}'", (Object)context);
        Class entityClass = context.getEntityClass();
        PreparedStatement ps = this.selectPSs.get(entityClass);
        EntityMeta entityMeta = context.getEntityMeta();
        ListenableFuture<ResultSet> resultSetFuture = this.executeReadWithConsistency(context, ps, entityMeta.structure().hasOnlyStaticColumns());
        return this.asyncUtils.transformFuture(resultSetFuture, RESULTSET_TO_ROW);
    }

    public BoundStatementWrapper bindForSliceQuerySelect(SliceQueryProperties<?> sliceQueryProperties) {
        PreparedStatement ps = this.cacheManager.getCacheForSliceSelectAndIterator(this.session, this.dynamicPSCache, sliceQueryProperties);
        return this.buildBSForSliceQuery(sliceQueryProperties, sliceQueryProperties.getReadConsistencyLevel(), ps);
    }

    public BoundStatementWrapper bindForSliceQueryDelete(SliceQueryProperties<?> sliceQueryProperties) {
        PreparedStatement ps = this.cacheManager.getCacheForSliceDelete(this.session, this.dynamicPSCache, sliceQueryProperties);
        return this.buildBSForSliceQuery(sliceQueryProperties, sliceQueryProperties.getWriteConsistencyLevel(), ps);
    }

    private BoundStatementWrapper buildBSForSliceQuery(final SliceQueryProperties<?> sliceQueryProperties, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, final PreparedStatement ps) {
        final Object[] boundValues = sliceQueryProperties.getBoundValues();
        Supplier<BoundStatement> bs = new Supplier<BoundStatement>(){

            public BoundStatement get() {
                BoundStatement bs = ps.bind(boundValues);
                sliceQueryProperties.setFetchSizeToStatement((Statement)bs);
                return bs;
            }
        };
        return new BoundStatementWrapper(sliceQueryProperties.getEntityClass(), bs, boundValues, ConsistencyConverter.getCQLLevel(consistencyLevel), (Optional<LWTResultListener>)Optional.absent(), (Optional<ConsistencyLevel>)Optional.absent());
    }

    private ListenableFuture<ResultSet> executeReadWithConsistency(DaoOperations context, PreparedStatement ps, boolean onlyStaticColumns) {
        info.archinnov.achilles.type.ConsistencyLevel readLevel = this.overrider.getReadLevel(context);
        BoundStatementWrapper bsWrapper = this.binder.bindStatementWithOnlyPKInWhereClause(context, ps, onlyStaticColumns, readLevel);
        return context.executeImmediate(bsWrapper);
    }

    public ListenableFuture<ResultSet> execute(AbstractStatementWrapper statementWrapper) {
        return statementWrapper.executeAsync(this.session, this.executorService);
    }

    public PreparedStatement prepare(RegularStatement statement) {
        return this.session.prepare(statement.getQueryString());
    }

    private Function<Row, Long> rowToLongFunction(final String counterColumnName) {
        return new Function<Row, Long>(){

            public Long apply(Row row) {
                Long counterValue = null;
                if (row != null && !row.isNull(counterColumnName)) {
                    counterValue = row.getLong(counterColumnName);
                }
                return counterValue;
            }
        };
    }

    public Session getSession() {
        return this.session;
    }

    public Configuration getDriverConfig() {
        return this.session.getCluster().getConfiguration();
    }

    void setDynamicPSCache(Cache<StatementCacheKey, PreparedStatement> dynamicPSCache) {
        this.dynamicPSCache = dynamicPSCache;
    }

    void setSelectPSs(Map<Class<?>, PreparedStatement> selectPSs) {
        this.selectPSs = selectPSs;
    }

    void setCounterQueryMap(Map<AchillesCounter.CQLQueryType, PreparedStatement> counterQueryMap) {
        this.counterQueryMap = counterQueryMap;
    }

    void setClusteredCounterQueryMap(Map<Class<?>, Map<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>>> clusteredCounterQueryMap) {
        this.clusteredCounterQueryMap = clusteredCounterQueryMap;
    }

    void setSession(Session session) {
        this.session = session;
    }

    void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

