/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.parsing.context.ParsingResult;
import info.archinnov.achilles.internal.table.SchemaReader;
import info.archinnov.achilles.internal.table.TableCreator;
import info.archinnov.achilles.internal.table.TableUpdater;
import info.archinnov.achilles.internal.table.TableValidator;
import java.util.Map;
import java.util.Set;

public class SchemaContext {
    private ConfigurationContext configContext;
    private Cluster cluster;
    private Session session;
    private String keyspaceName;
    private Map<Class<?>, EntityMeta> entityMetaMap;
    private boolean hasCounter;
    protected TableCreator tableCreator = TableCreator.Singleton.INSTANCE.get();
    protected TableValidator tableValidator = TableValidator.Singleton.INSTANCE.get();
    protected TableUpdater tableUpdater = TableUpdater.Singleton.INSTANCE.get();
    protected SchemaReader schemaReader = SchemaReader.Singleton.INSTANCE.get();

    public SchemaContext(ConfigurationContext configContext, Session session, String keyspaceName, Cluster cluster, ParsingResult parsingResult) {
        this.configContext = configContext;
        this.session = session;
        this.keyspaceName = keyspaceName;
        this.cluster = cluster;
        this.entityMetaMap = parsingResult.getMetaMap();
        this.hasCounter = parsingResult.hasSimpleCounter();
    }

    public Session getSession() {
        return this.session;
    }

    public boolean hasSimpleCounter() {
        return this.hasCounter;
    }

    public Set<Map.Entry<Class<?>, EntityMeta>> entityMetaEntrySet() {
        return this.entityMetaMap.entrySet();
    }

    public void validateForEntity(EntityMeta entityMeta, TableMetadata tableMetaData) {
        this.tableValidator.validateForEntity(entityMeta, tableMetaData, this.configContext);
    }

    public void validateAchillesCounter() {
        this.tableValidator.validateAchillesCounter(this.cluster.getMetadata().getKeyspace(this.keyspaceName), this.keyspaceName);
    }

    public Map<String, TableMetadata> fetchTableMetaData() {
        return this.schemaReader.fetchTableMetaData(this.cluster, this.entityMetaMap.values());
    }

    public void createTableForEntity(EntityMeta entityMeta) {
        this.tableCreator.createTableForEntity(this.session, entityMeta, this.configContext);
    }

    public void createTableForCounter() {
        this.tableCreator.createTableForCounter(this.session, this.configContext);
    }

    public void updateForEntity(EntityMeta entityMeta, TableMetadata tableMetaData) {
        this.tableUpdater.updateTableForEntity(this.session, entityMeta, tableMetaData);
    }

    public boolean achillesCounterTableExists() {
        return this.cluster.getMetadata().getKeyspace(this.keyspaceName).getTable("achilles_counter_table") != null;
    }
}

