/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.interceptor.Interceptor;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaConfig;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaInterceptors;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaSliceQuerySupport;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaStructure;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaTranscoder;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.internal.utils.Pair;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.InsertStrategy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EntityMeta {
    public static final Predicate<EntityMeta> CLUSTERED_COUNTER_FILTER = new Predicate<EntityMeta>(){

        public boolean apply(EntityMeta meta) {
            return meta.clusteredCounter;
        }
    };
    public static final Predicate<EntityMeta> EXCLUDE_CLUSTERED_COUNTER_FILTER = new Predicate<EntityMeta>(){

        public boolean apply(EntityMeta meta) {
            return !meta.clusteredCounter;
        }
    };
    private Class<?> entityClass;
    private String className;
    protected String tableName;
    protected String keyspaceName;
    protected String qualifiedTableName;
    protected String tableComment;
    private Class<?> idClass;
    private Map<String, PropertyMeta> propertyMetas;
    private List<PropertyMeta> allMetasExceptCounters;
    private List<PropertyMeta> allMetasExceptIdAndCounters;
    protected PropertyMeta idMeta;
    private Map<Method, PropertyMeta> getterMetas;
    private Map<Method, PropertyMeta> setterMetas;
    private List<PropertyMeta> allMetasExceptId;
    protected boolean clusteredEntity = false;
    protected boolean clusteredCounter = false;
    protected boolean hasOnlyStaticColumns = false;
    protected boolean hasStaticColumns = false;
    protected List<Interceptor<?>> interceptors = new ArrayList();
    protected Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels;
    protected InsertStrategy insertStrategy;
    protected boolean schemaUpdateEnabled = false;
    private final EntityMetaInterceptors forInterception = new EntityMetaInterceptors(this);
    private final EntityMetaSliceQuerySupport forSliceQuery = new EntityMetaSliceQuerySupport(this);
    private final EntityMetaTranscoder forTranscoding = new EntityMetaTranscoder(this);
    private final EntityMetaOperations forOperations = new EntityMetaOperations(this);
    private final EntityMetaStructure structure = new EntityMetaStructure(this);
    private final EntityMetaConfig config = new EntityMetaConfig(this);

    public EntityMetaInterceptors forInterception() {
        return this.forInterception;
    }

    public EntityMetaSliceQuerySupport forSliceQuery() {
        return this.forSliceQuery;
    }

    public EntityMetaTranscoder forTranscoding() {
        return this.forTranscoding;
    }

    public EntityMetaOperations forOperations() {
        return this.forOperations;
    }

    public EntityMetaStructure structure() {
        return this.structure;
    }

    public EntityMetaConfig config() {
        return this.config;
    }

    public <T> Class<T> getEntityClass() {
        return this.entityClass;
    }

    void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public String getClassName() {
        return this.className;
    }

    void setClassName(String className) {
        this.className = className;
    }

    void setQualifiedTableName(String qualifiedTableName) {
        this.qualifiedTableName = qualifiedTableName;
    }

    void setTableName(String tableName) {
        this.tableName = tableName;
    }

    void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public Map<String, PropertyMeta> getPropertyMetas() {
        return this.propertyMetas;
    }

    void setPropertyMetas(Map<String, PropertyMeta> propertyMetas) {
        this.propertyMetas = propertyMetas;
    }

    public PropertyMeta getIdMeta() {
        return this.idMeta;
    }

    void setIdMeta(PropertyMeta idMeta) {
        this.idMeta = idMeta;
    }

    public Map<Method, PropertyMeta> getGetterMetas() {
        return this.getterMetas;
    }

    void setGetterMetas(Map<Method, PropertyMeta> getterMetas) {
        this.getterMetas = getterMetas;
    }

    public Map<Method, PropertyMeta> getSetterMetas() {
        return this.setterMetas;
    }

    void setSetterMetas(Map<Method, PropertyMeta> setterMetas) {
        this.setterMetas = setterMetas;
    }

    void setClusteredEntity(boolean clusteredEntity) {
        this.clusteredEntity = clusteredEntity;
    }

    void setConsistencyLevels(Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels) {
        this.consistencyLevels = consistencyLevels;
    }

    void setInsertStrategy(InsertStrategy insertStrategy) {
        this.insertStrategy = insertStrategy;
    }

    void setSchemaUpdateEnabled(boolean schemaUpdateEnabled) {
        this.schemaUpdateEnabled = schemaUpdateEnabled;
    }

    public <T> Class<T> getIdClass() {
        return this.idClass;
    }

    void setIdClass(Class<?> idClass) {
        this.idClass = idClass;
    }

    public List<PropertyMeta> getAllMetas() {
        return new ArrayList<PropertyMeta>(this.propertyMetas.values());
    }

    public List<PropertyMeta> getAllCounterMetas() {
        return FluentIterable.from(this.propertyMetas.values()).filter((Predicate)PropertyType.COUNTER_TYPE).toList();
    }

    public List<PropertyMeta> getAllStaticMetas() {
        return FluentIterable.from(this.propertyMetas.values()).filter(PropertyMeta.STATIC_COLUMN_FILTER).toList();
    }

    void setClusteredCounter(boolean clusteredCounter) {
        this.clusteredCounter = clusteredCounter;
    }

    public List<PropertyMeta> getAllMetasExceptId() {
        return this.allMetasExceptId;
    }

    void setAllMetasExceptId(List<PropertyMeta> allMetasExceptId) {
        this.allMetasExceptId = allMetasExceptId;
    }

    public List<PropertyMeta> getAllMetasExceptIdAndCounters() {
        return this.allMetasExceptIdAndCounters;
    }

    void setAllMetasExceptIdAndCounters(List<PropertyMeta> allMetasExceptIdAndCounters) {
        this.allMetasExceptIdAndCounters = allMetasExceptIdAndCounters;
    }

    public List<PropertyMeta> getAllMetasExceptCounters() {
        return this.allMetasExceptCounters;
    }

    void setAllMetasExceptCounters(List<PropertyMeta> allMetasExceptCounters) {
        this.allMetasExceptCounters = allMetasExceptCounters;
    }

    void setHasOnlyStaticColumns(boolean hasOnlyStaticColumns) {
        this.hasOnlyStaticColumns = hasOnlyStaticColumns;
    }

    public boolean hasStaticColumns() {
        return this.hasStaticColumns;
    }

    public void setHasStaticColumns(boolean hasStaticColumns) {
        this.hasStaticColumns = hasStaticColumns;
    }

    public List<Interceptor<?>> getInterceptors() {
        return this.interceptors;
    }

    public String toString() {
        ArrayList<String> propertyNames = new ArrayList<String>(this.propertyMetas.keySet());
        Collections.sort(propertyNames);
        return Objects.toStringHelper(this.getClass()).add("className", (Object)this.className).add("qualifiedTableName", (Object)this.qualifiedTableName).add("propertyMetas", (Object)StringUtils.join(propertyNames, (String)",")).add("idMeta", (Object)this.idMeta).add("clusteredEntity", this.clusteredEntity).add("consistencyLevels", this.consistencyLevels).toString();
    }

    public static enum EntityState {
        MANAGED(true),
        NOT_MANAGED(false);

        private final boolean managed;

        private EntityState(boolean managed) {
            this.managed = managed;
        }

        public boolean isManaged() {
            return this.managed;
        }
    }
}

