/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.interceptor.Interceptor;
import info.archinnov.achilles.internal.interceptor.AchillesInternalInterceptor;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaView;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.List;

public class EntityMetaInterceptors
extends EntityMetaView {
    protected EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();

    protected EntityMetaInterceptors(EntityMeta meta) {
        super(meta);
    }

    public void addInterceptor(Interceptor<?> interceptor) {
        this.meta.getInterceptors().add(interceptor);
    }

    public List<Interceptor<?>> getInterceptors() {
        return this.meta.getInterceptors();
    }

    public void intercept(Object entity, Event event) {
        Object realObject = this.proxifier.getRealObject(entity);
        List<Interceptor<?>> interceptors = this.getInterceptorsForEvent(event);
        if (interceptors.size() > 0) {
            for (Interceptor<?> interceptor : interceptors) {
                if (AchillesInternalInterceptor.class.isAssignableFrom(interceptor.getClass())) {
                    interceptor.onEvent(entity);
                    continue;
                }
                interceptor.onEvent(realObject);
            }
            Validator.validateNotNull(this.meta.forOperations().getPrimaryKey(realObject), "The primary key should not be null after intercepting the event '%s'", event);
        }
    }

    protected List<Interceptor<?>> getInterceptorsForEvent(Event event) {
        return FluentIterable.from(this.meta.getInterceptors()).filter(this.getFilterForEvent(event)).toList();
    }

    private Predicate<? super Interceptor<?>> getFilterForEvent(final Event event) {
        return new Predicate<Interceptor<?>>(){

            public boolean apply(Interceptor<?> interceptor) {
                return interceptor != null && interceptor.events() != null && interceptor.events().contains(event);
            }
        };
    }
}

