/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.internal.metadata.codec.ListCodec;
import info.archinnov.achilles.internal.metadata.codec.MapCodec;
import info.archinnov.achilles.internal.metadata.codec.SetCodec;
import info.archinnov.achilles.internal.metadata.holder.CompoundPKProperties;
import info.archinnov.achilles.internal.metadata.holder.CounterProperties;
import info.archinnov.achilles.internal.metadata.holder.IndexProperties;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaCacheSupport;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaConfig;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaRowExtractor;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaSliceQueryContext;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaSliceQuerySupport;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaStatementGenerator;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaStructure;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaTableCreator;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaTableValidator;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaTranscoder;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaTypedQuery;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaValues;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.internal.utils.Pair;
import info.archinnov.achilles.json.DefaultJacksonMapper;
import info.archinnov.achilles.type.ConsistencyLevel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class PropertyMeta {
    public static final Predicate<PropertyMeta> STATIC_COLUMN_FILTER = new Predicate<PropertyMeta>(){

        public boolean apply(PropertyMeta pm) {
            return pm.structure().isStaticColumn();
        }
    };
    public static final Predicate<PropertyMeta> COUNTER_COLUMN_FILTER = new Predicate<PropertyMeta>(){

        public boolean apply(PropertyMeta pm) {
            return pm.structure().isCounter();
        }
    };
    public static final Function<PropertyMeta, String> GET_CQL_COLUMN_NAME = new Function<PropertyMeta, String>(){

        public String apply(PropertyMeta meta) {
            return meta.getCQLColumnName();
        }
    };
    public static final Function<String, String> TO_LOWER_CASE = new Function<String, String>(){

        public String apply(String name) {
            return name.toLowerCase();
        }
    };
    public static final Function<PropertyMeta, List<String>> GET_CQL_COLUMN_NAMES_FROM_COMPOUND_PK = new Function<PropertyMeta, List<String>>(){

        public List<String> apply(PropertyMeta compoundPKMeta) {
            return compoundPKMeta.getCompoundPKProperties().getCQLComponentNames();
        }
    };
    ObjectMapper defaultJacksonMapperForCounter = DefaultJacksonMapper.COUNTER.get();
    private CompoundPKProperties compoundPKProperties;
    private String entityClassName;
    private Class<?> valueClass;
    private Class<?> keyClass;
    private Class<?> cqlValueClass;
    private Class<?> cqlKeyClass;
    private PropertyType type;
    String propertyName;
    String cqlColumnName;
    Method getter;
    Method setter;
    private Field field;
    CounterProperties counterProperties;
    private IndexProperties indexProperties;
    private Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels;
    private boolean timeUUID = false;
    private boolean emptyCollectionAndMapIfNull = false;
    private boolean staticColumn = false;
    private Codec simpleCodec;
    private ListCodec listCodec;
    private SetCodec setCodec;
    private MapCodec mapCodec;
    private final PropertyMetaRowExtractor forRowExtraction = new PropertyMetaRowExtractor(this);
    private final PropertyMetaStatementGenerator forStatementGeneration = new PropertyMetaStatementGenerator(this);
    private final PropertyMetaCacheSupport forCache = new PropertyMetaCacheSupport(this);
    private final PropertyMetaTableValidator forTableValidation = new PropertyMetaTableValidator(this);
    private final PropertyMetaTableCreator forTableCreation = new PropertyMetaTableCreator(this);
    private final PropertyMetaSliceQuerySupport forSliceQuery = new PropertyMetaSliceQuerySupport(this);
    private final PropertyMetaSliceQueryContext forSliceQueryContext = new PropertyMetaSliceQueryContext(this);
    private final PropertyMetaTypedQuery forTypedQuery = new PropertyMetaTypedQuery(this);
    private final PropertyMetaTranscoder forTranscoding = new PropertyMetaTranscoder(this);
    private final PropertyMetaStructure structure = new PropertyMetaStructure(this);
    private final PropertyMetaConfig config = new PropertyMetaConfig(this);
    private final PropertyMetaValues forValues = new PropertyMetaValues(this);

    public PropertyMetaRowExtractor forRowExtraction() {
        return this.forRowExtraction;
    }

    public PropertyMetaStatementGenerator forStatementGeneration() {
        return this.forStatementGeneration;
    }

    public PropertyMetaCacheSupport forCache() {
        return this.forCache;
    }

    public PropertyMetaTableValidator forTableValidation() {
        return this.forTableValidation;
    }

    public PropertyMetaTableCreator forTableCreation() {
        return this.forTableCreation;
    }

    public PropertyMetaSliceQuerySupport forSliceQuery() {
        return this.forSliceQuery;
    }

    public PropertyMetaSliceQueryContext forSliceQueryContext() {
        return this.forSliceQueryContext;
    }

    public PropertyMetaTypedQuery forTypedQuery() {
        return this.forTypedQuery;
    }

    public PropertyMetaTranscoder forTranscoding() {
        return this.forTranscoding;
    }

    public PropertyMetaStructure structure() {
        return this.structure;
    }

    public PropertyMetaConfig config() {
        return this.config;
    }

    public PropertyMetaValues forValues() {
        return this.forValues;
    }

    public PropertyType type() {
        return this.type;
    }

    public void setType(PropertyType propertyType) {
        this.type = propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public <T> Class<T> getKeyClass() {
        return this.keyClass;
    }

    public void setKeyClass(Class<?> keyClass) {
        this.keyClass = keyClass;
    }

    public <T> Class<T> getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    <T> Class<T> getCqlValueClass() {
        return this.cqlValueClass;
    }

    void setCqlValueClass(Class<?> cqlValueClass) {
        this.cqlValueClass = cqlValueClass;
    }

    <T> Class<T> getCQLKeyClass() {
        return this.cqlKeyClass;
    }

    void setCQLKeyClass(Class<?> cqlKeyClass) {
        this.cqlKeyClass = cqlKeyClass;
    }

    public Method getGetter() {
        return this.getter;
    }

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    CompoundPKProperties getCompoundPKProperties() {
        return this.compoundPKProperties;
    }

    void setCompoundPKProperties(CompoundPKProperties compoundPKProperties) {
        this.compoundPKProperties = compoundPKProperties;
    }

    public void setIdMetaForCounterProperties(PropertyMeta idMeta) {
        this.counterProperties.setIdMeta(idMeta);
    }

    public CounterProperties getCounterProperties() {
        return this.counterProperties;
    }

    void setCounterProperties(CounterProperties counterProperties) {
        this.counterProperties = counterProperties;
    }

    Pair<ConsistencyLevel, ConsistencyLevel> getConsistencyLevels() {
        return this.consistencyLevels;
    }

    public void setConsistencyLevels(Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels) {
        this.consistencyLevels = consistencyLevels;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    void setEntityClassName(String entityClassName) {
        this.entityClassName = entityClassName;
    }

    IndexProperties getIndexProperties() {
        return this.indexProperties;
    }

    public void setIndexProperties(IndexProperties indexProperties) {
        this.indexProperties = indexProperties;
    }

    boolean isTimeUUID() {
        return this.timeUUID;
    }

    void setTimeUUID(boolean timeUUID) {
        this.timeUUID = timeUUID;
    }

    boolean isEmptyCollectionAndMapIfNull() {
        return this.emptyCollectionAndMapIfNull;
    }

    void setEmptyCollectionAndMapIfNull(boolean emptyCollectionAndMapIfNull) {
        this.emptyCollectionAndMapIfNull = emptyCollectionAndMapIfNull;
    }

    boolean isStaticColumn() {
        return this.staticColumn;
    }

    void setStaticColumn(boolean staticColumn) {
        this.staticColumn = staticColumn;
    }

    public String getCQLColumnName() {
        return this.cqlColumnName;
    }

    public void setCQLColumnName(String cqlColumnName) {
        this.cqlColumnName = cqlColumnName;
    }

    Codec getSimpleCodec() {
        return this.simpleCodec;
    }

    public void setSimpleCodec(Codec simpleCodec) {
        this.simpleCodec = simpleCodec;
    }

    ListCodec getListCodec() {
        return this.listCodec;
    }

    public void setListCodec(ListCodec listCodec) {
        this.listCodec = listCodec;
    }

    SetCodec getSetCodec() {
        return this.setCodec;
    }

    public void setSetCodec(SetCodec setCodec) {
        this.setCodec = setCodec;
    }

    MapCodec getMapCodec() {
        return this.mapCodec;
    }

    public void setMapCodec(MapCodec mapCodec) {
        this.mapCodec = mapCodec;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("type", (Object)this.type).add("entityClassName", (Object)this.entityClassName).add("propertyName", (Object)this.propertyName).add("keyClass", this.keyClass).add("valueClass", this.valueClass).add("counterProperties", (Object)this.counterProperties).add("compoundPKProperties", (Object)this.compoundPKProperties).add("consistencyLevels", this.consistencyLevels).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entityClassName, this.propertyName, this.type});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyMeta other = (PropertyMeta)obj;
        return Objects.equal((Object)this.entityClassName, (Object)other.getEntityClassName()) && Objects.equal((Object)this.propertyName, (Object)other.getPropertyName()) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type()));
    }
}

