/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import info.archinnov.achilles.annotations.ClusteringColumn;
import info.archinnov.achilles.annotations.PartitionKey;
import info.archinnov.achilles.internal.metadata.parsing.ComponentOrderingParser;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentOrderingParser
extends ComponentOrderingParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultComponentOrderingParser.class);

    public DefaultComponentOrderingParser(PropertyParsingContext context) {
        super(context);
    }

    @Override
    Map<Integer, Field> extractComponentsOrdering(Class<?> compoundPKClass) {
        log.trace("Extract components ordering from compound primary key class {} ", (Object)compoundPKClass.getCanonicalName());
        String compoundPKClassName = compoundPKClass.getCanonicalName();
        ImmutableList partitionComponents = FluentIterable.from((Iterable)ReflectionUtils.getAllFields(compoundPKClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(PartitionKey.class)})).toSortedList((Comparator)new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                PartitionKey order1 = o1.getAnnotation(PartitionKey.class);
                PartitionKey order2 = o2.getAnnotation(PartitionKey.class);
                return new Integer(order1.value()).compareTo(new Integer(order2.value()));
            }
        });
        ImmutableList clusteringColumns = FluentIterable.from((Iterable)ReflectionUtils.getAllFields(compoundPKClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(ClusteringColumn.class)})).toSortedList((Comparator)new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                ClusteringColumn order1 = o1.getAnnotation(ClusteringColumn.class);
                ClusteringColumn order2 = o2.getAnnotation(ClusteringColumn.class);
                return new Integer(order1.value()).compareTo(new Integer(order2.value()));
            }
        });
        this.validatePartitionComponentsOrder((List<Field>)partitionComponents, String.format("The partition components ordering is wrong for @CompoundPrimaryKey class '%s'", compoundPKClassName));
        this.validateClusteringColumnsOrder((List<Field>)clusteringColumns, String.format("The clustering keys ordering is wrong for @CompoundPrimaryKey class '%s'", compoundPKClassName));
        HashMap<Integer, Field> result = new HashMap<Integer, Field>();
        for (int i = 1; i <= partitionComponents.size() + clusteringColumns.size(); ++i) {
            if (i <= partitionComponents.size()) {
                result.put(i, (Field)partitionComponents.get(i - 1));
                continue;
            }
            result.put(i, (Field)clusteringColumns.get(i - 1 - partitionComponents.size()));
        }
        Validator.validateBeanMappingTrue(result.size() > 1, String.format("There should be at least 2 fields annotated with @PartitionKey or @ClusteringColumn for the @CompoundPrimaryKey class '%s'", compoundPKClassName), new Object[0]);
        return result;
    }

    @Override
    List<Create.Options.ClusteringOrder> extractClusteringOrder(Class<?> compoundPKClass) {
        log.trace("Extract clustering component order from compound primary key class {} ", (Object)compoundPKClass.getCanonicalName());
        ImmutableList clusteringColumns = FluentIterable.from((Iterable)ReflectionUtils.getAllFields(compoundPKClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(ClusteringColumn.class)})).toSortedList((Comparator)new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                ClusteringColumn order1 = o1.getAnnotation(ClusteringColumn.class);
                ClusteringColumn order2 = o2.getAnnotation(ClusteringColumn.class);
                return new Integer(order1.value()).compareTo(new Integer(order2.value()));
            }
        });
        ArrayList<Create.Options.ClusteringOrder> sortOrders = new ArrayList<Create.Options.ClusteringOrder>();
        for (Field clusteringColumn : clusteringColumns) {
            ClusteringColumn annotation = clusteringColumn.getAnnotation(ClusteringColumn.class);
            String cqlColumnName = this.introspector.inferCQLColumnName(clusteringColumn, this.context.getClassNamingStrategy());
            this.validateNotStaticColumn(clusteringColumn);
            sortOrders.add(new Create.Options.ClusteringOrder(cqlColumnName, annotation.reversed() ? Create.Options.ClusteringOrder.Sorting.DESC : Create.Options.ClusteringOrder.Sorting.ASC));
        }
        return sortOrders;
    }

    private void validatePartitionComponentsOrder(List<Field> partitionComponents, String errorMessage) {
        int clusteringOrderSum = 0;
        for (Field partitionComponent : partitionComponents) {
            PartitionKey partitionKey = partitionComponent.getAnnotation(PartitionKey.class);
            clusteringOrderSum += partitionKey.value();
        }
        int checkForPartitionKey = partitionComponents.size() * (partitionComponents.size() + 1) / 2;
        Validator.validateBeanMappingTrue(checkForPartitionKey == clusteringOrderSum, errorMessage, new Object[0]);
    }

    private void validateClusteringColumnsOrder(List<Field> clusteringColumns, String errorMessage) {
        int clusteringOrderSum = 0;
        for (Field clusteringColumn : clusteringColumns) {
            ClusteringColumn clusteringColumnAnnotation = clusteringColumn.getAnnotation(ClusteringColumn.class);
            clusteringOrderSum += clusteringColumnAnnotation.value();
        }
        int checkForClusteringColumns = clusteringColumns.size() * (clusteringColumns.size() + 1) / 2;
        Validator.validateBeanMappingTrue(checkForClusteringColumns == clusteringOrderSum, errorMessage, new Object[0]);
    }
}

