/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy;

import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.proxy.ProxyInterceptor;
import info.archinnov.achilles.internal.proxy.UpdateProxyInterceptor;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyChecker;
import info.archinnov.achilles.internal.validation.Validator;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyInterceptorBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(ProxyInterceptorBuilder.class);
    private T target;
    private Set<Method> alreadyLoaded = new HashSet<Method>();
    private EntityOperations context;

    public static <T> ProxyInterceptorBuilder<T> builder(EntityOperations context, T entity) {
        return new ProxyInterceptorBuilder<T>(context, entity);
    }

    public ProxyInterceptorBuilder(EntityOperations context, T entity) {
        Validator.validateNotNull(context, "PersistenceContext for interceptor should not be null", new Object[0]);
        Validator.validateNotNull(entity, "Target entity for interceptor should not be null", new Object[0]);
        this.context = context;
        this.target = entity;
    }

    public ProxyInterceptor<T> build() {
        log.debug("Build proxy interceptor for entity of class {}", (Object)this.context.getEntityMeta().getClassName());
        ProxyInterceptor<T> interceptor = new ProxyInterceptor<T>();
        EntityMeta entityMeta = this.context.getEntityMeta();
        String className = this.context.getEntityClass().getCanonicalName();
        Validator.validateNotNull(this.target, "Target object for interceptor of '%s' should not be null", className);
        Validator.validateNotNull(entityMeta.getGetterMetas(), "Getters metadata for interceptor of '%s' should not be null", className);
        Validator.validateNotNull(entityMeta.getSetterMetas(), "Setters metadata for interceptor of '%s' should not be null", className);
        Validator.validateNotNull(entityMeta.getIdMeta(), "Id metadata for '%s' should not be null", className);
        interceptor.setTarget(this.target);
        interceptor.setEntityOperations(this.context);
        interceptor.setGetterMetas(entityMeta.getGetterMetas());
        interceptor.setSetterMetas(entityMeta.getSetterMetas());
        interceptor.setIdGetter(entityMeta.getIdMeta().getGetter());
        interceptor.setIdSetter(entityMeta.getIdMeta().getSetter());
        interceptor.setDirtyMap(new HashMap<Method, DirtyChecker>());
        interceptor.setPrimaryKey(this.context.getPrimaryKey());
        interceptor.setAlreadyLoaded(this.alreadyLoaded);
        return interceptor;
    }

    public UpdateProxyInterceptor<T> buildForUpdate() {
        log.debug("Build update proxy interceptor for entity of class {}", (Object)this.context.getEntityMeta().getClassName());
        UpdateProxyInterceptor<T> interceptor = new UpdateProxyInterceptor<T>();
        EntityMeta entityMeta = this.context.getEntityMeta();
        String className = this.context.getEntityClass().getCanonicalName();
        Validator.validateNotNull(this.target, "Target object for interceptor of '%s' should not be null", className);
        Validator.validateNotNull(entityMeta.getGetterMetas(), "Getters metadata for interceptor of '%s' should not be null", className);
        Validator.validateNotNull(entityMeta.getSetterMetas(), "Setters metadata for interceptor of '%s' should not be null", className);
        Validator.validateNotNull(entityMeta.getIdMeta(), "Id metadata for '%s' should not be null", className);
        interceptor.setTarget(this.target);
        interceptor.setEntityOperations(this.context);
        interceptor.setGetterMetas(entityMeta.getGetterMetas());
        interceptor.setSetterMetas(entityMeta.getSetterMetas());
        interceptor.setIdGetter(entityMeta.getIdMeta().getGetter());
        interceptor.setIdSetter(entityMeta.getIdMeta().getSetter());
        interceptor.setDirtyMap(new HashMap<Method, DirtyChecker>());
        interceptor.setPrimaryKey(this.context.getPrimaryKey());
        return interceptor;
    }

    public ProxyInterceptorBuilder<T> alreadyLoaded(Set<Method> alreadyLoaded) {
        this.alreadyLoaded = alreadyLoaded;
        return this;
    }
}

