/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.reflection;

import info.archinnov.achilles.exception.AchillesException;

public class ObjectInstantiator {
    public <T> T instantiate(Class<T> entityClass) {
        try {
            return entityClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new AchillesException("Cannot instantiate class of type " + entityClass.getCanonicalName() + ", did you forget to declare a default constructor ?", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AchillesException("Cannot instantiate class of type " + entityClass.getCanonicalName() + ", did you forget to declare a default constructor ?", (Throwable)e);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final ObjectInstantiator instance = new ObjectInstantiator();

        public ObjectInstantiator get() {
            return this.instance;
        }
    }
}

