/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.reflection;

import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.reflection.FieldAccessor;
import info.archinnov.achilles.internal.reflection.ObjectInstantiator;
import info.archinnov.achilles.internal.validation.Validator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionInvoker {
    private static final Logger log = LoggerFactory.getLogger(ReflectionInvoker.class);
    private FieldAccessor accessor = FieldAccessor.Singleton.INSTANCE.get();
    private ObjectInstantiator instantiator = ObjectInstantiator.Singleton.INSTANCE.get();

    public Object getPrimaryKey(Object entity, PropertyMeta idMeta) {
        Field field = idMeta.getField();
        if (log.isTraceEnabled()) {
            log.trace("Get primary key {} from instance {} of class {}", new Object[]{idMeta.getPropertyName(), entity, field.getDeclaringClass().getCanonicalName()});
        }
        if (entity != null) {
            try {
                return this.accessor.getValueFromField(field, entity);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AchillesException("Cannot get primary key from field '" + field.getName() + "' of type '" + field.getDeclaringClass().getCanonicalName() + "' from entity '" + entity + "'", (Throwable)e);
            }
        }
        return null;
    }

    public <T> T getValueFromField(Object target, Field field) {
        if (log.isTraceEnabled()) {
            log.trace("Get value from field {} from instance {} of class {}", new Object[]{field.getName(), target, field.getDeclaringClass().getCanonicalName()});
        }
        T value = null;
        if (target != null) {
            try {
                value = this.accessor.getValueFromField(field, target);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AchillesException("Cannot get value from field '" + field.getName() + "' of type '" + field.getDeclaringClass().getCanonicalName() + "' on instance '" + target + "'", (Throwable)e);
            }
        }
        log.trace("Found value : {}", value);
        return value;
    }

    public Object getValueFromField(Object target, Method getter) {
        if (log.isTraceEnabled()) {
            log.trace("Get value with getter {} from instance {} of class {}", new Object[]{getter.getName(), target, getter.getDeclaringClass().getCanonicalName()});
        }
        Object value = null;
        if (target != null) {
            try {
                value = getter.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new AchillesException("Cannot invoke '" + getter.getName() + "' of type '" + getter.getDeclaringClass().getCanonicalName() + "' on instance '" + target + "'", (Throwable)e);
            }
        }
        log.trace("Found value : {}", value);
        return value;
    }

    public <T> List<T> getListValueFromField(Object target, Field field) {
        return (List)this.getValueFromField(target, field);
    }

    public <T> Set<T> getSetValueFromField(Object target, Field field) {
        return (Set)this.getValueFromField(target, field);
    }

    public <K, V> Map<K, V> getMapValueFromField(Object target, Field field) {
        return (Map)this.getValueFromField(target, field);
    }

    public void setValueToField(Object target, Field field, Object args) {
        Class<?> type;
        if (log.isTraceEnabled()) {
            log.trace("Set value to field {} from instance {} of class {} with {}", new Object[]{field.getName(), target, field.getDeclaringClass().getCanonicalName(), args});
        }
        if ((type = field.getType()).isPrimitive()) {
            Validator.validateNotNull(args, "Cannot set null value to primitive type '%s' of field '%s' on instance of class'%s'", type.getCanonicalName(), field.getName(), field.getDeclaringClass().getCanonicalName());
        }
        if (target != null) {
            try {
                this.accessor.setValueToField(field, target, args);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AchillesException("Cannot set value to field '" + field.getName() + "' of type '" + field.getType().getCanonicalName() + "' on instance '" + target + "'", (Throwable)e);
            }
        }
    }

    public <T> T instantiate(Class<T> entityClass) {
        if (log.isTraceEnabled()) {
            log.trace("Instantiate entity class {}", entityClass);
        }
        return this.instantiator.instantiate(entityClass);
    }

    public static enum Singleton {
        INSTANCE;

        private final ReflectionInvoker instance = new ReflectionInvoker();

        public ReflectionInvoker get() {
            return this.instance;
        }
    }
}

