/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.cache;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.internal.statement.cache.CacheType;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.query.slice.SliceQueryProperties;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StatementCacheKey {
    private static final Function<Options.LWTPredicate, Options.LWTPredicate> DUPLICATE_LWT_PREDICATES = new Function<Options.LWTPredicate, Options.LWTPredicate>(){

        public Options.LWTPredicate apply(Options.LWTPredicate predicate) {
            return predicate.duplicate();
        }
    };
    private CacheType type;
    private Set<String> fields = new LinkedHashSet<String>();
    private Class<?> entityClass;
    private OptionsCacheKey optionsCacheKey;
    private Optional<SliceQueryProperties> sliceQueryPropertiesO = Optional.absent();

    public StatementCacheKey(CacheType type, Set<String> fields, Class<?> entityClass, Options options) {
        this.type = type;
        this.entityClass = entityClass;
        this.fields = fields;
        this.optionsCacheKey = OptionsCacheKey.fromOptions(options);
    }

    public StatementCacheKey(CacheType type, SliceQueryProperties sliceQueryProperties) {
        this.type = type;
        this.entityClass = sliceQueryProperties.getEntityMeta().getEntityClass();
        this.sliceQueryPropertiesO = Optional.fromNullable((Object)sliceQueryProperties);
    }

    public CacheType getType() {
        return this.type;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public <T> Class<T> getEntityClass() {
        return this.entityClass;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityClass, this.fields, this.type, this.optionsCacheKey, this.sliceQueryPropertiesO});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        StatementCacheKey other = (StatementCacheKey)o;
        return Objects.equals(this.entityClass, other.entityClass) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.optionsCacheKey, other.optionsCacheKey) && Objects.equals(this.sliceQueryPropertiesO, other.sliceQueryPropertiesO);
    }

    public String toString() {
        return "StatementCacheKey{type=" + Objects.toString((Object)this.type) + ", fields=" + Objects.toString(this.fields) + ", entityClass=" + Objects.toString(this.entityClass) + ", optionsCacheKey=" + Objects.toString(this.optionsCacheKey) + '}';
    }

    private static class OptionsCacheKey {
        private boolean hasTTL;
        private boolean hasTimestamp;
        private List<Options.LWTPredicate> lwtPredicates;

        private OptionsCacheKey(boolean hasTTL, boolean hasTimestamp, List<Options.LWTPredicate> lwtPredicates) {
            this.hasTTL = hasTTL;
            this.hasTimestamp = hasTimestamp;
            this.lwtPredicates = lwtPredicates;
        }

        private static OptionsCacheKey fromOptions(Options options) {
            return new OptionsCacheKey(options.hasTTL(), options.hasTimestamp(), (List<Options.LWTPredicate>)FluentIterable.from(options.getLwtPredicates()).transform(DUPLICATE_LWT_PREDICATES).toList());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            OptionsCacheKey other = (OptionsCacheKey)o;
            return Objects.equals(this.hasTTL, other.hasTTL) && Objects.equals(this.hasTimestamp, other.hasTimestamp) && Objects.equals(this.lwtPredicates, other.lwtPredicates);
        }

        public int hashCode() {
            return Objects.hash(this.hasTTL, this.hasTimestamp, this.lwtPredicates);
        }

        public String toString() {
            return "OptionsCacheKey{hasTTL=" + Objects.toString(this.hasTTL) + ", hasTimestamp=" + Objects.toString(this.hasTimestamp) + ", LWTPredicates=" + Objects.toString(this.lwtPredicates) + '}';
        }
    }
}

