/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.table;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.google.common.collect.ComparisonChain;
import java.util.List;

public class ColumnMetaDataComparator {
    public boolean isEqual(ColumnMetadata source, ColumnMetadata target) {
        boolean isEqual;
        String sourceName = source.getName();
        DataType sourceType = source.getType();
        List sourceTypeParams = sourceType.getTypeArguments();
        String targetName = target.getName();
        DataType targetType = target.getType();
        List targetTypeParams = targetType.getTypeArguments();
        boolean isPartiallyEqual = ComparisonChain.start().compare((Comparable)((Object)sourceName), (Comparable)((Object)targetName)).compare((Comparable)sourceType.getName(), (Comparable)targetType.getName()).compareFalseFirst(sourceType.isCollection(), targetType.isCollection()).result() == 0;
        boolean bothHaveTypeParameters = sourceTypeParams != null && targetTypeParams != null || sourceTypeParams == null && targetTypeParams == null;
        boolean bl = isEqual = isPartiallyEqual && bothHaveTypeParameters;
        if (isEqual && sourceTypeParams != null) {
            boolean bl2 = isEqual = sourceTypeParams.size() == targetTypeParams.size();
            if (isEqual) {
                for (int i = 0; i < sourceTypeParams.size(); ++i) {
                    boolean sameParamType;
                    DataType sourceParamType = (DataType)sourceTypeParams.get(i);
                    DataType targetParamType = (DataType)targetTypeParams.get(i);
                    boolean bl3 = sameParamType = ComparisonChain.start().compare((Comparable)sourceParamType.getName(), (Comparable)targetParamType.getName()).result() == 0;
                    if (sameParamType) continue;
                    return false;
                }
            }
        }
        return isEqual;
    }

    public static enum Singleton {
        INSTANCE;

        private final ColumnMetaDataComparator instance = new ColumnMetaDataComparator();

        public ColumnMetaDataComparator get() {
            return this.instance;
        }
    }
}

