/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.iterator;

import com.datastax.driver.core.Row;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.context.PersistenceContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AchillesIterator<T>
implements Iterator<T> {
    private static final Logger log = LoggerFactory.getLogger(AchillesIterator.class);
    private PersistenceContext context;
    private Iterator<Row> iterator;
    private EntityMeta meta;
    private boolean createProxy;
    private EntityMapper mapper = EntityMapper.Singleton.INSTANCE.get();
    private EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();

    public AchillesIterator(EntityMeta meta, boolean createProxy, PersistenceContext context, Iterator<Row> iterator) {
        this.context = context;
        this.iterator = iterator;
        this.meta = meta;
        this.createProxy = createProxy;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        log.trace("Does iterator has more element ? {}", (Object)hasNext);
        return hasNext;
    }

    @Override
    public T next() {
        log.trace("Fetch iterator next element");
        Object clusteredEntity = null;
        Row row = this.iterator.next();
        if (row != null) {
            clusteredEntity = this.meta.forOperations().instanciate();
            if (this.context.getStateHolderFacade().isClusteredCounter()) {
                this.mapper.setValuesToClusteredCounterEntity(row, this.meta, clusteredEntity);
                this.mapper.setPropertyToEntity(row, this.meta, this.meta.getIdMeta(), clusteredEntity, this.createProxy ? EntityMeta.EntityState.MANAGED : EntityMeta.EntityState.NOT_MANAGED);
            } else {
                this.mapper.setNonCounterPropertiesToEntity(row, this.meta, clusteredEntity, this.createProxy ? EntityMeta.EntityState.MANAGED : EntityMeta.EntityState.NOT_MANAGED);
            }
            this.meta.forInterception().intercept(clusteredEntity, Event.POST_LOAD);
            if (this.createProxy) {
                clusteredEntity = this.proxify(clusteredEntity);
            }
        }
        return clusteredEntity;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove clustered entity with iterator");
    }

    private T proxify(T clusteredEntity) {
        PersistenceContext duplicate = this.context.duplicate(clusteredEntity);
        return this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(clusteredEntity, duplicate.getEntityFacade());
    }
}

