/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.options;

import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.NotEqualCQLClause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.listener.LWTResultListener;
import info.archinnov.achilles.options.OptionsBuilder;
import info.archinnov.achilles.type.ConsistencyLevel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class Options {
    private static final Predicate<LWTPredicate> FILTER_LWT_CONDITION = new Predicate<LWTPredicate>(){

        public boolean apply(LWTPredicate predicate) {
            return !predicate.type().existentialCondition();
        }
    };
    Optional<ConsistencyLevel> consistency = Optional.absent();
    Optional<Integer> ttl = Optional.absent();
    Optional<Long> timestamp = Optional.absent();
    List<LWTPredicate> lwtPredicates = new ArrayList<LWTPredicate>();
    Optional<LWTResultListener> lwtResultListenerO = Optional.absent();
    List<FutureCallback<Object>> asyncListeners = new ArrayList<FutureCallback<Object>>();
    Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyO = Optional.absent();
    boolean createProxy = false;

    Options() {
    }

    public Optional<ConsistencyLevel> getConsistencyLevel() {
        return this.consistency;
    }

    public Optional<Integer> getTtl() {
        return this.ttl;
    }

    public Optional<Long> getTimestamp() {
        return this.timestamp;
    }

    public boolean hasConsistencyLevel() {
        return this.consistency.isPresent();
    }

    public boolean hasTTL() {
        return this.ttl.isPresent();
    }

    public boolean hasTimestamp() {
        return this.timestamp.isPresent();
    }

    public boolean isIfNotExists() {
        return this.lwtPredicates.size() == 1 && this.lwtPredicates.get(0).type() == LWTPredicate.LWTType.IF_NOT_EXISTS;
    }

    public boolean isIfExists() {
        return this.lwtPredicates.size() == 1 && this.lwtPredicates.get(0).type() == LWTPredicate.LWTType.IF_EXISTS;
    }

    public List<LWTCondition> getLwtConditions() {
        ImmutableList lwtPredicates1 = FluentIterable.from(this.lwtPredicates).filter(FILTER_LWT_CONDITION).toList();
        return lwtPredicates1;
    }

    public List<LWTPredicate> getLwtPredicates() {
        return this.lwtPredicates;
    }

    public boolean hasLWTConditions() {
        return CollectionUtils.isNotEmpty(this.lwtPredicates);
    }

    public Optional<LWTResultListener> getLWTResultListener() {
        return this.lwtResultListenerO;
    }

    public List<FutureCallback<Object>> getAsyncListeners() {
        return this.asyncListeners;
    }

    public boolean hasAsyncListeners() {
        return CollectionUtils.isNotEmpty(this.asyncListeners);
    }

    public Optional<com.datastax.driver.core.ConsistencyLevel> getSerialConsistency() {
        return this.serialConsistencyO;
    }

    public boolean shouldCreateProxy() {
        return this.createProxy;
    }

    public String toString() {
        return Objects.toStringHelper(Options.class).add("Consistency Level", this.consistency).add("Time to live", this.ttl).add("Timestamp", this.timestamp).add("IF NOT EXISTS ? ", this.isIfNotExists()).add("IF EXISTS ? ", this.isIfExists()).add("CAS conditions", this.lwtPredicates).add("CAS result listener optional", this.lwtResultListenerO).add("Async listeners", this.asyncListeners).add("Serial consistency", this.serialConsistencyO).add("Should create proxy", this.createProxy).toString();
    }

    public Options duplicateWithoutTtlAndTimestamp() {
        return OptionsBuilder.withConsistencyO(this.consistency).lwtPredicates(this.lwtPredicates).lwtResultListener((LWTResultListener)this.lwtResultListenerO.orNull()).lwtLocalSerial(this.serialConsistencyO.isPresent()).withAsyncListeners(this.asyncListeners).withProxy(this.createProxy);
    }

    public Options duplicateWithNewConsistencyLevel(ConsistencyLevel consistencyLevel) {
        return OptionsBuilder.withConsistency(consistencyLevel).withTtlO(this.ttl).withTimestampO(this.timestamp).lwtPredicates(this.lwtPredicates).lwtResultListener((LWTResultListener)this.lwtResultListenerO.orNull()).lwtLocalSerial(this.serialConsistencyO.isPresent()).withAsyncListeners(this.asyncListeners).withProxy(this.createProxy);
    }

    public Options duplicateWithNewTimestamp(Long timestamp) {
        return OptionsBuilder.withConsistencyO(this.consistency).withTtlO(this.ttl).withTimestamp(timestamp).lwtPredicates(this.lwtPredicates).lwtResultListener((LWTResultListener)this.lwtResultListenerO.orNull()).lwtLocalSerial(this.serialConsistencyO.isPresent()).withAsyncListeners(this.asyncListeners).withProxy(this.createProxy);
    }

    public static class LWTCondition
    extends LWTPredicate {
        private String columnName;
        private Object value;
        private LWTPredicate.LWTType type;

        @Override
        public LWTPredicate.LWTType type() {
            return this.type;
        }

        @Override
        public LWTPredicate duplicate() {
            return new LWTCondition(this.type, this.columnName);
        }

        private LWTCondition(LWTPredicate.LWTType type, String columnName) {
            this.type = type;
            this.columnName = columnName;
        }

        public LWTCondition(LWTPredicate.LWTType type, String columnName, Object value) {
            Validator.validateNotNull((Object)type, "Lightweight Transaction condition type cannot be null", new Object[0]);
            Validator.validateNotBlank(columnName, "Lightweight Transaction condition column cannot be blank", new Object[0]);
            this.type = type;
            this.columnName = columnName;
            this.value = value;
        }

        public void encodedValue(Object encodedValue) {
            this.value = encodedValue;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Object getValue() {
            return this.value;
        }

        public Clause toClause() {
            return this.type().buildCQLClause(this.columnName, this.value);
        }

        public Clause toClauseForPreparedStatement() {
            return this.type().buildCQLClauseForPreparedStatement(this.columnName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LWTCondition that = (LWTCondition)o;
            return Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.columnName, (Object)that.columnName) && Objects.equal((Object)this.value, (Object)that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type(), this.columnName, this.value});
        }

        public String toString() {
            return Objects.toStringHelper(Options.class).add("columnName", (Object)this.columnName).add("value", this.value).toString();
        }
    }

    public static class LWTIfExists
    extends LWTPredicate {
        @Override
        public LWTPredicate.LWTType type() {
            return LWTPredicate.LWTType.IF_EXISTS;
        }

        private LWTIfExists() {
        }

        @Override
        public LWTPredicate duplicate() {
            return Singleton.INSTANCE.instance;
        }

        public static enum Singleton {
            INSTANCE;

            private final LWTIfExists instance = new LWTIfExists();

            public LWTIfExists get() {
                return this.instance;
            }
        }
    }

    public static class LWTIfNotExists
    extends LWTPredicate {
        @Override
        public LWTPredicate.LWTType type() {
            return LWTPredicate.LWTType.IF_NOT_EXISTS;
        }

        @Override
        public LWTPredicate duplicate() {
            return Singleton.INSTANCE.instance;
        }

        private LWTIfNotExists() {
        }

        public static enum Singleton {
            INSTANCE;

            private final LWTIfNotExists instance = new LWTIfNotExists();

            public LWTIfNotExists get() {
                return this.instance;
            }
        }
    }

    public static abstract class LWTPredicate {
        public abstract LWTType type();

        public abstract LWTPredicate duplicate();

        public static enum LWTType {
            IF_NOT_EXISTS{

                @Override
                public boolean existentialCondition() {
                    return true;
                }

                @Override
                public Clause buildCQLClauseForPreparedStatement(String columnName) {
                    return null;
                }

                @Override
                public Clause buildCQLClause(String columnName, Object value) {
                    return null;
                }
            }
            ,
            IF_EXISTS{

                @Override
                public boolean existentialCondition() {
                    return true;
                }

                @Override
                public Clause buildCQLClauseForPreparedStatement(String columnName) {
                    return null;
                }

                @Override
                public Clause buildCQLClause(String columnName, Object value) {
                    return null;
                }
            }
            ,
            EQUAL_CONDITION{

                @Override
                public boolean existentialCondition() {
                    return false;
                }

                @Override
                public Clause buildCQLClauseForPreparedStatement(String columnName) {
                    return QueryBuilder.eq((String)columnName, (Object)QueryBuilder.bindMarker((String)columnName));
                }

                @Override
                public Clause buildCQLClause(String columnName, Object value) {
                    return QueryBuilder.eq((String)columnName, (Object)value);
                }
            }
            ,
            GT_CONDITION{

                @Override
                public boolean existentialCondition() {
                    return false;
                }

                @Override
                public Clause buildCQLClauseForPreparedStatement(String columnName) {
                    return QueryBuilder.gt((String)columnName, (Object)QueryBuilder.bindMarker((String)columnName));
                }

                @Override
                public Clause buildCQLClause(String columnName, Object value) {
                    return QueryBuilder.gt((String)columnName, (Object)value);
                }
            }
            ,
            GTE_CONDITION{

                @Override
                public boolean existentialCondition() {
                    return false;
                }

                @Override
                public Clause buildCQLClauseForPreparedStatement(String columnName) {
                    return QueryBuilder.gte((String)columnName, (Object)QueryBuilder.bindMarker((String)columnName));
                }

                @Override
                public Clause buildCQLClause(String columnName, Object value) {
                    return QueryBuilder.gte((String)columnName, (Object)value);
                }
            }
            ,
            LT_CONDITION{

                @Override
                public boolean existentialCondition() {
                    return false;
                }

                @Override
                public Clause buildCQLClauseForPreparedStatement(String columnName) {
                    return QueryBuilder.lt((String)columnName, (Object)QueryBuilder.bindMarker((String)columnName));
                }

                @Override
                public Clause buildCQLClause(String columnName, Object value) {
                    return QueryBuilder.lt((String)columnName, (Object)value);
                }
            }
            ,
            LTE_CONDITION{

                @Override
                public boolean existentialCondition() {
                    return false;
                }

                @Override
                public Clause buildCQLClauseForPreparedStatement(String columnName) {
                    return QueryBuilder.lte((String)columnName, (Object)QueryBuilder.bindMarker((String)columnName));
                }

                @Override
                public Clause buildCQLClause(String columnName, Object value) {
                    return QueryBuilder.lte((String)columnName, (Object)value);
                }
            }
            ,
            NOT_EQUAL_CONDITION{

                @Override
                public boolean existentialCondition() {
                    return false;
                }

                @Override
                public Clause buildCQLClauseForPreparedStatement(String columnName) {
                    return NotEqualCQLClause.build(columnName);
                }

                @Override
                public Clause buildCQLClause(String columnName, Object value) {
                    return NotEqualCQLClause.build(columnName, value);
                }
            };


            public abstract boolean existentialCondition();

            public abstract Clause buildCQLClauseForPreparedStatement(String var1);

            public abstract Clause buildCQLClause(String var1, Object var2);
        }
    }
}

