/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.context.facade.PersistenceManagerOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaConfig;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.persistence.operations.EntityValidator;
import info.archinnov.achilles.internal.persistence.operations.OptionsValidator;
import info.archinnov.achilles.internal.persistence.operations.SliceQueryExecutor;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.options.OptionsBuilder;
import info.archinnov.achilles.query.typed.TypedQueryValidator;
import info.archinnov.achilles.type.Empty;
import info.archinnov.achilles.type.IndexCondition;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractPersistenceManager.class);
    protected Map<Class<?>, EntityMeta> entityMetaMap;
    protected ConfigurationContext configContext;
    protected PersistenceContextFactory contextFactory;
    protected EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();
    protected OptionsValidator optionsValidator = OptionsValidator.Singleton.INSTANCE.get();
    protected EntityValidator entityValidator = EntityValidator.Singleton.INSTANCE.get();
    protected TypedQueryValidator typedQueryValidator = TypedQueryValidator.Singleton.INSTANCE.get();
    protected SliceQueryExecutor sliceQueryExecutor;
    protected DaoContext daoContext;

    protected AbstractPersistenceManager(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext) {
        this.entityMetaMap = entityMetaMap;
        this.configContext = configContext;
        this.daoContext = daoContext;
        this.contextFactory = contextFactory;
        this.sliceQueryExecutor = new SliceQueryExecutor(contextFactory, configContext, daoContext);
    }

    protected <T> AchillesFuture<T> asyncInsert(T entity, Options options) {
        this.entityValidator.validateEntity(entity, this.entityMetaMap);
        this.optionsValidator.validateOptionsForUpsert(entity, this.entityMetaMap, options);
        this.proxifier.ensureNotProxy(entity);
        PersistenceManagerOperations context = this.initPersistenceContext(entity, options);
        return context.insert(entity);
    }

    protected <T> AchillesFuture<T> asyncUpdate(T entity, Options options) {
        this.proxifier.ensureProxy(entity);
        T realObject = this.proxifier.getRealObject(entity);
        this.entityValidator.validateEntity(realObject, this.entityMetaMap);
        this.optionsValidator.validateOptionsForUpsert(entity, this.entityMetaMap, options);
        PersistenceManagerOperations context = this.initPersistenceContext(realObject, options);
        return context.update(entity);
    }

    protected <T> AchillesFuture<T> asyncInsertOrUpdate(T entity, Options options) {
        this.entityValidator.validateEntity(entity, this.entityMetaMap);
        if (this.proxifier.isProxy(entity)) {
            return this.asyncUpdate(entity, options);
        }
        return this.asyncInsert(entity, options);
    }

    protected <T> AchillesFuture<T> asyncDelete(T entity, Options options) {
        T realObject = this.proxifier.getRealObject(entity);
        this.entityValidator.validateEntity(realObject, this.entityMetaMap);
        PersistenceManagerOperations context = this.initPersistenceContext(realObject, options);
        return context.delete();
    }

    protected AchillesFuture<Empty> asyncDeleteById(Class<?> entityClass, Object primaryKey, Options options) {
        Validator.validateNotNull(entityClass, "The entity class should not be null for removal by id", new Object[0]);
        Validator.validateNotNull(primaryKey, "The primary key should not be null for removal by id", new Object[0]);
        PersistenceManagerOperations context = this.initPersistenceContext(entityClass, primaryKey, options);
        this.entityValidator.validatePrimaryKey(context.getIdMeta(), primaryKey);
        return context.deleteById();
    }

    protected <T> AchillesFuture<T> asyncFind(Class<T> entityClass, Object primaryKey, Options options) {
        Validator.validateNotNull(entityClass, "Entity class should not be null for find by id", new Object[0]);
        Validator.validateNotNull(primaryKey, "Entity primaryKey should not be null for find by id", new Object[0]);
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "The entity class '%s' is not managed by Achilles", entityClass.getCanonicalName());
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "The entity class '%s' is not managed by Achilles", entityClass.getCanonicalName());
        PersistenceManagerOperations context = this.initPersistenceContext(entityClass, primaryKey, options);
        this.entityValidator.validatePrimaryKey(context.getIdMeta(), primaryKey);
        return context.find(entityClass);
    }

    protected <T> T getProxyForUpdateInternal(Class<T> entityClass, Object primaryKey) {
        Validator.validateNotNull(entityClass, "Entity class should not be null for get proxy for update", new Object[0]);
        Validator.validateNotNull(primaryKey, "Entity primaryKey should not be null for get proxy for update", new Object[0]);
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "The entity class '%s' is not managed by Achilles", entityClass.getCanonicalName());
        PersistenceManagerOperations context = this.initPersistenceContext(entityClass, primaryKey, OptionsBuilder.noOptions());
        this.entityValidator.validatePrimaryKey(context.getIdMeta(), primaryKey);
        return context.getProxyForUpdate(entityClass);
    }

    protected <T> T initialize(T entity) {
        this.proxifier.ensureProxy(entity);
        T realObject = this.proxifier.getRealObject(entity);
        PersistenceManagerOperations context = this.initPersistenceContext(realObject, OptionsBuilder.noOptions());
        return context.initialize(entity);
    }

    protected <T> T removeProxy(T proxy) {
        return this.proxifier.removeProxy(proxy);
    }

    protected <T> List<T> removeProxy(List<T> proxies) {
        return this.proxifier.removeProxy(proxies);
    }

    protected <T> Set<T> removeProxy(Set<T> proxies) {
        return this.proxifier.removeProxy(proxies);
    }

    protected <T> EntityMeta validateSliceQueryInternal(Class<T> entityClass) {
        Validator.validateNotNull(entityClass, "The entityClass should be provided for slice query", new Object[0]);
        EntityMeta meta = this.entityMetaMap.get(entityClass);
        Validator.validateNotNull(meta, "The entity '%s' is not managed by achilles", entityClass.getName());
        Validator.validateTrue(meta.structure().isClusteredEntity(), "Cannot perform slice query on entity type '%s' because it is not a clustered entity", meta.getClassName());
        return meta;
    }

    protected <T> EntityMeta typedQueryInternal(Class<T> entityClass, Statement statement, Object ... boundValues) {
        log.debug("Execute typed query for entity class {}", entityClass);
        Validator.validateNotNull(entityClass, "The entityClass for typed query should not be null", new Object[0]);
        Validator.validateNotNull(statement, "The regularStatement for typed query should not be null", new Object[0]);
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "Cannot perform typed query because the entityClass '%s' is not managed by Achilles", entityClass.getCanonicalName());
        EntityMeta meta = this.entityMetaMap.get(entityClass);
        this.typedQueryValidator.validateTypedQuery(entityClass, statement, meta);
        return meta;
    }

    protected <T> Statement indexedQueryInternal(Class<T> entityClass, IndexCondition indexCondition) {
        EntityMeta entityMeta = this.entityMetaMap.get(entityClass);
        Validator.validateFalse(entityMeta.structure().isClusteredEntity(), "Index query is not supported for clustered entity. Please use typed query/native query", new Object[0]);
        Validator.validateNotNull(indexCondition, "Index condition should not be null", new Object[0]);
        entityMeta.forTranscoding().encodeIndexConditionValue(indexCondition);
        String indexColumnName = indexCondition.getColumnName();
        EntityMetaConfig metaConfig = entityMeta.config();
        Select.Where statement = QueryBuilder.select().from(metaConfig.getKeyspaceName(), metaConfig.getTableName()).where(QueryBuilder.eq((String)indexColumnName, (Object)QueryBuilder.bindMarker((String)indexColumnName)));
        return statement;
    }

    protected String serializeToJSON(Object entity) throws IOException {
        Validator.validateNotNull(entity, "Cannot serialize to JSON null entity", new Object[0]);
        ObjectMapper objectMapper = this.configContext.getMapperFor(entity.getClass());
        return objectMapper.writeValueAsString(entity);
    }

    protected <T> T deserializeFromJSON(Class<T> type, String serialized) throws IOException {
        Validator.validateNotNull(type, "Cannot deserialize from JSON if target type is null", new Object[0]);
        ObjectMapper objectMapper = this.configContext.getMapperFor(type);
        return (T)objectMapper.readValue(serialized, type);
    }

    protected Session getNativeSession() {
        return this.daoContext.getSession();
    }

    protected PersistenceManagerOperations initPersistenceContext(Class<?> entityClass, Object primaryKey, Options options) {
        return this.contextFactory.newContext(entityClass, primaryKey, options).getPersistenceManagerFacade();
    }

    protected PersistenceManagerOperations initPersistenceContext(Object entity, Options options) {
        return this.contextFactory.newContext(entity, options).getPersistenceManagerFacade();
    }

    protected Map<Class<?>, EntityMeta> getEntityMetaMap() {
        return this.entityMetaMap;
    }

    protected ConfigurationContext getConfigContext() {
        return this.configContext;
    }

    protected void setEntityMetaMap(Map<Class<?>, EntityMeta> entityMetaMap) {
        this.entityMetaMap = entityMetaMap;
    }

    protected void setConfigContext(ConfigurationContext configContext) {
        this.configContext = configContext;
    }
}

