/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.slice;

import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.schemabuilder.Create;
import java.util.List;

public enum BoundingMode {
    INCLUSIVE_BOUNDS(true, true),
    EXCLUSIVE_BOUNDS(false, false),
    INCLUSIVE_START_BOUND_ONLY(true, false),
    INCLUSIVE_END_BOUND_ONLY(false, true);

    private static final Function<String, Object> FROM_NAME_TO_BIND_MARKER;
    private final boolean inclusiveStart;
    private final boolean inclusiveEnd;

    private BoundingMode(boolean inclusiveStart, boolean inclusiveEnd) {
        this.inclusiveStart = inclusiveStart;
        this.inclusiveEnd = inclusiveEnd;
    }

    public void buildFromClusteringKeys(Select.Where where, Create.Options.ClusteringOrder clusteringOrder, List<String> fromClusteringKeysName) {
        if (clusteringOrder.getSorting() == Create.Options.ClusteringOrder.Sorting.ASC) {
            if (this.inclusiveStart) {
                where.and(QueryBuilder.gte(fromClusteringKeysName, (List)FluentIterable.from(fromClusteringKeysName).transform(FROM_NAME_TO_BIND_MARKER).toList()));
            } else {
                where.and(QueryBuilder.gt(fromClusteringKeysName, (List)FluentIterable.from(fromClusteringKeysName).transform(FROM_NAME_TO_BIND_MARKER).toList()));
            }
        } else if (this.inclusiveStart) {
            where.and(QueryBuilder.lte(fromClusteringKeysName, (List)FluentIterable.from(fromClusteringKeysName).transform(FROM_NAME_TO_BIND_MARKER).toList()));
        } else {
            where.and(QueryBuilder.lt(fromClusteringKeysName, (List)FluentIterable.from(fromClusteringKeysName).transform(FROM_NAME_TO_BIND_MARKER).toList()));
        }
    }

    public void buildToClusteringKeys(Select.Where where, Create.Options.ClusteringOrder clusteringOrder, List<String> toClusteringKeysName) {
        if (clusteringOrder.getSorting() == Create.Options.ClusteringOrder.Sorting.ASC) {
            if (this.inclusiveEnd) {
                where.and(QueryBuilder.lte(toClusteringKeysName, (List)FluentIterable.from(toClusteringKeysName).transform(FROM_NAME_TO_BIND_MARKER).toList()));
            } else {
                where.and(QueryBuilder.lt(toClusteringKeysName, (List)FluentIterable.from(toClusteringKeysName).transform(FROM_NAME_TO_BIND_MARKER).toList()));
            }
        } else if (this.inclusiveEnd) {
            where.and(QueryBuilder.gte(toClusteringKeysName, (List)FluentIterable.from(toClusteringKeysName).transform(FROM_NAME_TO_BIND_MARKER).toList()));
        } else {
            where.and(QueryBuilder.gt(toClusteringKeysName, (List)FluentIterable.from(toClusteringKeysName).transform(FROM_NAME_TO_BIND_MARKER).toList()));
        }
    }

    static {
        FROM_NAME_TO_BIND_MARKER = new Function<String, Object>(){

            public BindMarker apply(String name) {
                return QueryBuilder.bindMarker((String)name);
            }
        };
    }
}

