/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.typed;

import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.Statement;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.query.typed.AbstractTypedQuery;
import info.archinnov.achilles.query.typed.EntitiesWithPagingState;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedQuery<T>
extends AbstractTypedQuery<T> {
    private static final Logger log = LoggerFactory.getLogger(TypedQuery.class);

    public TypedQuery(Class<T> entityClass, DaoContext daoContext, ConfigurationContext configContext, Statement statement, EntityMeta meta, PersistenceContextFactory contextFactory, Object[] boundValues) {
        super(entityClass, daoContext, configContext, statement, meta, contextFactory, boundValues);
    }

    public TypedQuery<T> withProxy() {
        this.createProxy = true;
        return this;
    }

    public TypedQuery<T> withPagingState(PagingState pagingState) {
        this.pagingStateO = Optional.fromNullable((Object)pagingState);
        return this;
    }

    public TypedQuery<T> withPagingState(String pagingState) {
        this.pagingStateO = Optional.fromNullable((Object)PagingState.fromString((String)pagingState));
        return this;
    }

    public TypedQuery<T> withPagingState(byte[] pagingState) {
        this.pagingStateO = Optional.fromNullable((Object)PagingState.fromBytes((byte[])pagingState));
        return this;
    }

    public List<T> get() {
        log.debug("Get results for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncUtils.buildInterruptible(this.asyncGetInternal(new FutureCallback[0])).getImmediately().getEntities();
    }

    public EntitiesWithPagingState<T> getWithPagingState() {
        log.debug("Get results for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncUtils.buildInterruptible(this.asyncGetInternal(new FutureCallback[0])).getImmediately().toEntitiesWithPagingState();
    }

    public T getFirst() {
        log.debug("Get first result for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncUtils.buildInterruptible(this.asyncGetFirstInternal(new FutureCallback[0])).getImmediately();
    }

    public Iterator<T> iterator() {
        log.debug("Get iterator for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncIteratorInternal((Optional<Integer>)Optional.absent(), NO_CALLBACKS).getImmediately();
    }

    public Iterator<T> iterator(int fetchSize) {
        log.debug("Get iterator for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncIteratorInternal((Optional<Integer>)Optional.fromNullable((Object)fetchSize), NO_CALLBACKS).getImmediately();
    }
}

