/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.schemabuilder;

import com.datastax.driver.core.DataType;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import info.archinnov.achilles.schemabuilder.SchemaStatement;
import info.archinnov.achilles.schemabuilder.TableOptions;
import java.util.List;

public class Alter
extends SchemaStatement {
    private Optional<String> keyspaceName = Optional.absent();
    private String tableName;

    Alter(String keyspaceName, String tableName) {
        Alter.validateNotEmpty(keyspaceName, "Keyspace name");
        Alter.validateNotEmpty(tableName, "Table name");
        Alter.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        Alter.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
        this.keyspaceName = Optional.fromNullable((Object)keyspaceName);
    }

    Alter(String tableName) {
        Alter.validateNotEmpty(tableName, "Table name");
        Alter.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
    }

    public AlterColumn alterColumn(String columnName) {
        Alter.validateNotEmpty(columnName, "Column to be altered");
        Alter.validateNotKeyWord(columnName, String.format("The altered column name '%s' is not allowed because it is a reserved keyword", columnName));
        return new AlterColumn(this, columnName);
    }

    public AddColumn addColumn(String columnName) {
        Alter.validateNotEmpty(columnName, "Added column");
        Alter.validateNotKeyWord(columnName, String.format("The new column name '%s' is not allowed because it is a reserved keyword", columnName));
        return new AddColumn(this, columnName, false);
    }

    public AddColumn addStaticColumn(String columnName) {
        Alter.validateNotEmpty(columnName, "Added static column");
        Alter.validateNotKeyWord(columnName, String.format("The new static column name '%s' is not allowed because it is a reserved keyword", columnName));
        return new AddColumn(this, columnName, true);
    }

    public AddColumn addColumn(String columnName, boolean isStatic) {
        if (isStatic) {
            return this.addStaticColumn(columnName);
        }
        return this.addColumn(columnName);
    }

    public String dropColumn(String columnName) {
        Alter.validateNotEmpty(columnName, "Column to be dropped");
        Alter.validateNotKeyWord(columnName, String.format("The dropped column name '%s' is not allowed because it is a reserved keyword", columnName));
        return this.buildInternal() + " " + "DROP" + " " + columnName;
    }

    public RenameColumn renameColumn(String columnName) {
        Alter.validateNotEmpty(columnName, "Column to be renamed");
        Alter.validateNotKeyWord(columnName, String.format("The renamed column name '%s' is not allowed because it is a reserved keyword", columnName));
        return new RenameColumn(this, columnName);
    }

    public Options withOptions() {
        return new Options(this);
    }

    @Override
    String buildInternal() {
        StringBuilder alterStatement = new StringBuilder("\n").append("\t").append("ALTER TABLE");
        alterStatement.append(" ");
        if (this.keyspaceName.isPresent()) {
            alterStatement.append((String)this.keyspaceName.get()).append(".");
        }
        alterStatement.append(this.tableName);
        return alterStatement.toString();
    }

    public static class Options
    extends TableOptions<Options> {
        Options(Alter alter) {
            super(alter);
        }

        @Override
        String buildOptions() {
            List<String> commonOptions = super.buildCommonOptions();
            return "WITH" + " " + Joiner.on((String)" AND ").join(commonOptions);
        }

        @Override
        public String build() {
            return super.build() + " " + this.buildOptions();
        }
    }

    public static class RenameColumn {
        private final Alter alter;
        private final String columnName;

        RenameColumn(Alter alter, String columnName) {
            this.alter = alter;
            this.columnName = columnName;
        }

        public String to(String newColumnName) {
            StringBuilder statement = new StringBuilder(this.alter.buildInternal());
            SchemaStatement.validateNotEmpty(newColumnName, "New column name");
            SchemaStatement.validateNotKeyWord(newColumnName, String.format("The new column name '%s' is not allowed because it is a reserved keyword", newColumnName));
            statement.append(" ").append("RENAME").append(" ").append(this.columnName).append(" ").append("TO").append(" ").append(newColumnName);
            return statement.toString();
        }
    }

    public static class AddColumn {
        private final Alter alter;
        private final String columnName;
        private final boolean staticColumn;

        AddColumn(Alter alter, String columnName, boolean staticColumn) {
            this.alter = alter;
            this.columnName = columnName;
            this.staticColumn = staticColumn;
        }

        public String type(DataType type) {
            StringBuilder statement = new StringBuilder(this.alter.buildInternal());
            statement.append(" ").append("ADD").append(" ").append(this.columnName).append(" ").append(type.toString());
            if (this.staticColumn) {
                statement.append(" ").append("static");
            }
            return statement.toString();
        }
    }

    public static class AlterColumn {
        private final Alter alter;
        private final String columnName;

        AlterColumn(Alter alter, String columnName) {
            this.alter = alter;
            this.columnName = columnName;
        }

        public String type(DataType type) {
            StringBuilder statement = new StringBuilder(this.alter.buildInternal());
            statement.append(" ").append("ALTER").append(" ").append(this.columnName).append(" ").append("TYPE").append(" ").append(type.toString());
            return statement.toString();
        }
    }
}

