/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.schemabuilder;

import com.google.common.base.Optional;
import info.archinnov.achilles.schemabuilder.SchemaStatement;

public class Drop
extends SchemaStatement {
    private Optional<String> keyspaceName = Optional.absent();
    private String tableName;
    private Optional<Boolean> ifExists = Optional.absent();

    Drop(String keyspaceName, String tableName) {
        Drop.validateNotEmpty(keyspaceName, "Keyspace name");
        Drop.validateNotEmpty(tableName, "Table name");
        Drop.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        Drop.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
        this.keyspaceName = Optional.fromNullable((Object)keyspaceName);
    }

    Drop(String tableName) {
        Drop.validateNotEmpty(tableName, "Table name");
        Drop.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
    }

    public Drop ifExists(Boolean ifExists) {
        this.ifExists = Optional.fromNullable((Object)ifExists);
        return this;
    }

    @Override
    String buildInternal() {
        StringBuilder dropStatement = new StringBuilder("DROP TABLE");
        if (this.ifExists.isPresent() && ((Boolean)this.ifExists.get()).booleanValue()) {
            dropStatement.append(" ").append("IF EXISTS");
        }
        dropStatement.append(" ");
        if (this.keyspaceName.isPresent()) {
            dropStatement.append((String)this.keyspaceName.get()).append(".");
        }
        dropStatement.append(this.tableName);
        return dropStatement.toString();
    }

    public String build() {
        return this.buildInternal();
    }
}

