/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.UserType;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTypeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTypeBuilder.class);

    public static UserType buildUserType(ProtocolVersion version, CodecRegistry registry, String keyspace, String typeName, boolean frozen, Collection<UserType.Field> fields) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Creating UserType instance for UDT %s in keyspace %s", typeName, keyspace));
        }
        String plainKeyspace = keyspace.replaceAll("\"", "");
        String plainTypeName = typeName.replaceAll("\"", "");
        return new UserType(plainKeyspace, plainTypeName, frozen, fields, version, registry);
    }

    public static UserType.Field buildField(String name, DataType dataType) {
        String plainName = name.replaceAll("\"", "");
        return new UserType.Field(plainName, dataType);
    }
}

