/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.List;

public class MapEntryClause
extends Clause {
    private final String quotedColumnName;
    private final Object key;
    private final Object value;

    private MapEntryClause(String quotedColumnName, Object key, Object value) {
        this.quotedColumnName = quotedColumnName;
        this.key = key;
        this.value = value;
    }

    public static MapEntryClause of(String quotedColumnName, Object key, Object value) {
        return new MapEntryClause(quotedColumnName, key, value);
    }

    void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
        sb.append(this.quotedColumnName).append("[").append(this.key.toString()).append("]").append(" = ").append(this.value.toString());
        if (!Utils.containsBindMarker((Object)this.key)) {
            variables.add(this.key);
        }
        if (!Utils.containsBindMarker((Object)this.value)) {
            variables.add(this.value);
        }
    }

    String name() {
        return this.quotedColumnName;
    }

    Object firstValue() {
        return this.containsBindMarker() ? null : this.key;
    }

    boolean containsBindMarker() {
        return Utils.containsBindMarker((Object)this.key) && Utils.containsBindMarker((Object)this.value);
    }
}

