/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.configuration;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Session;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import info.archinnov.achilles.async.DefaultExecutorThreadFactory;
import info.archinnov.achilles.configuration.ConfigurationParameters;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internals.cache.StatementsCache;
import info.archinnov.achilles.internals.context.ConfigurationContext;
import info.archinnov.achilles.internals.factory.DefaultBeanFactory;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.types.ConfigMap;
import info.archinnov.achilles.json.DefaultJacksonMapperFactory;
import info.archinnov.achilles.json.JacksonMapperFactory;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.type.interceptor.Interceptor;
import info.archinnov.achilles.type.strategy.InsertStrategy;
import info.archinnov.achilles.type.strategy.NamingStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentExtractor {
    static final int DEFAULT_LRU_CACHE_SIZE = 10000;
    static final boolean DEFAULT_ENABLE_PRE_MUTATE_BEAN_VALIDATION = false;
    static final boolean DEFAULT_ENABLE_POST_LOAD_BEAN_VALIDATION = false;
    static final int DEFAULT_THREAD_POOL_MIN_THREAD_COUNT = 10;
    static final int DEFAULT_THREAD_POOL_MAX_THREAD_COUNT = 10;
    static final long DEFAULT_THREAD_POOL_THREAD_TTL = 60L;
    static final int DEFAULT_THREAD_POOL_QUEUE_SIZE = 1000;
    static final ThreadFactory DEFAULT_THREAD_POOL_THREAD_FACTORY = new DefaultExecutorThreadFactory();
    static final InsertStrategy DEFAULT_INSERT_STRATEGY = InsertStrategy.ALL_FIELDS;
    static final NamingStrategy DEFAULT_GLOBAL_NAMING_STRATEGY = NamingStrategy.LOWER_CASE;
    static final BeanFactory DEFAULT_BEAN_FACTORY = new DefaultBeanFactory();
    static final Integer DEFAULT_DML_RESULTS_DISPLAY_SIZE = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentExtractor.class);

    public static ConfigurationContext initConfigContext(Cluster cluster, ConfigMap configurationMap) {
        LOGGER.trace("Build ConfigurationContext from configuration map");
        ConfigurationContext configContext = new ConfigurationContext();
        configContext.setCurrentKeyspace(ArgumentExtractor.initKeyspaceName(configurationMap));
        configContext.setForceSchemaGeneration(ArgumentExtractor.initForceSchemaCreation(configurationMap));
        configContext.setManageEntities(ArgumentExtractor.initManagedEntities(configurationMap));
        configContext.setJacksonMapperFactory(ArgumentExtractor.initObjectMapperFactory(configurationMap));
        configContext.setDefaultReadConsistencyLevel(ArgumentExtractor.initDefaultReadConsistencyLevel(configurationMap));
        configContext.setDefaultWriteConsistencyLevel(ArgumentExtractor.initDefaultWriteConsistencyLevel(configurationMap));
        configContext.setDefaultSerialConsistencyLevel(ArgumentExtractor.initDefaultSerialConsistencyLevel(configurationMap));
        configContext.setReadConsistencyLevelMap(ArgumentExtractor.initReadConsistencyMap(configurationMap));
        configContext.setWriteConsistencyLevelMap(ArgumentExtractor.initWriteConsistencyMap(configurationMap));
        configContext.setSerialConsistencyLevelMap(ArgumentExtractor.initSerialConsistencyMap(configurationMap));
        configContext.setBeanValidator(ArgumentExtractor.initValidator(configurationMap));
        configContext.setPostLoadBeanValidationEnabled(ArgumentExtractor.initPostLoadBeanValidation(configurationMap));
        configContext.setInterceptors(ArgumentExtractor.initInterceptors(configurationMap));
        configContext.setPreparedStatementLRUCacheSize(ArgumentExtractor.initPreparedStatementsCacheSize(configurationMap));
        configContext.setGlobalInsertStrategy(ArgumentExtractor.initInsertStrategy(configurationMap));
        configContext.setGlobalNamingStrategy(ArgumentExtractor.initGlobalNamingStrategy(configurationMap));
        configContext.setSchemaNameProvider(ArgumentExtractor.initSchemaNameProvider(configurationMap));
        configContext.setExecutorService(ArgumentExtractor.initExecutorService(configurationMap));
        configContext.setProvidedExecutorService(ArgumentExtractor.initProvidedExecutorService(configurationMap));
        configContext.setDefaultBeanFactory(ArgumentExtractor.initDefaultBeanFactory(configurationMap));
        configContext.setSession(ArgumentExtractor.initSession(cluster, configurationMap));
        configContext.setProvidedSession(ArgumentExtractor.initProvidedSession(configurationMap));
        configContext.setStatementsCache(ArgumentExtractor.initStatementCache(configurationMap));
        configContext.setRuntimeCodecs(ArgumentExtractor.initRuntimeCodecs(configurationMap));
        configContext.setValidateSchema(ArgumentExtractor.initValidateSchema(configurationMap));
        configContext.setDMLResultsDisplaySize(ArgumentExtractor.initDMLResultsDisplayLimit(configurationMap));
        return configContext;
    }

    static boolean initValidateSchema(ConfigMap configurationMap) {
        LOGGER.trace("Extract 'schema validation enabled' from configuration map");
        return configurationMap.getTypedOr(ConfigurationParameters.VALIDATE_SCHEMA, true);
    }

    static boolean initForceSchemaCreation(ConfigMap configurationMap) {
        LOGGER.trace("Extract 'force table creation' from configuration map");
        return configurationMap.getTypedOr(ConfigurationParameters.FORCE_SCHEMA_GENERATION, false);
    }

    public static List<Class<?>> initManagedEntities(ConfigMap configMap) {
        LOGGER.trace("Extract managed entity classes from configuration map");
        return configMap.getTypedOr(ConfigurationParameters.MANAGED_ENTITIES, new ArrayList());
    }

    static JacksonMapperFactory initObjectMapperFactory(ConfigMap configurationMap) {
        LOGGER.trace("Extract object mapper factory from configuration map");
        JacksonMapperFactory jacksonMapperFactory = (JacksonMapperFactory)configurationMap.getTyped(ConfigurationParameters.JACKSON_MAPPER_FACTORY);
        if (jacksonMapperFactory == null) {
            ObjectMapper mapper = (ObjectMapper)configurationMap.getTyped(ConfigurationParameters.JACKSON_MAPPER);
            jacksonMapperFactory = mapper != null ? ArgumentExtractor.factoryFromMapper(mapper) : new DefaultJacksonMapperFactory();
        }
        return jacksonMapperFactory;
    }

    protected static JacksonMapperFactory factoryFromMapper(final ObjectMapper mapper) {
        return new JacksonMapperFactory(){

            @Override
            public <T> ObjectMapper getMapper(Class<T> type) {
                return mapper;
            }
        };
    }

    static Optional<ConsistencyLevel> initDefaultReadConsistencyLevel(ConfigMap configMap) {
        LOGGER.trace("Extract default read Consistency level from configuration map");
        return Optional.ofNullable(configMap.getTyped(ConfigurationParameters.CONSISTENCY_LEVEL_READ_DEFAULT));
    }

    static Optional<ConsistencyLevel> initDefaultWriteConsistencyLevel(ConfigMap configMap) {
        LOGGER.trace("Extract default read Consistency level from configuration map");
        return Optional.ofNullable(configMap.getTyped(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_DEFAULT));
    }

    static Optional<ConsistencyLevel> initDefaultSerialConsistencyLevel(ConfigMap configMap) {
        LOGGER.trace("Extract default write Consistency level from configuration map");
        return Optional.ofNullable(configMap.getTyped(ConfigurationParameters.CONSISTENCY_LEVEL_SERIAL_DEFAULT));
    }

    public static Map<String, ConsistencyLevel> initReadConsistencyMap(ConfigMap configMap) {
        LOGGER.trace("Extract read Consistency level map from configuration map");
        return (Map)configMap.getTypedOr(ConfigurationParameters.CONSISTENCY_LEVEL_READ_MAP, ImmutableMap.of());
    }

    public static Map<String, ConsistencyLevel> initWriteConsistencyMap(ConfigMap configMap) {
        LOGGER.trace("Extract write Consistency level map from configuration map");
        return (Map)configMap.getTypedOr(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_MAP, ImmutableMap.of());
    }

    public static Map<String, ConsistencyLevel> initSerialConsistencyMap(ConfigMap configMap) {
        LOGGER.trace("Extract serial Consistency level map from configuration map");
        return (Map)configMap.getTypedOr(ConfigurationParameters.CONSISTENCY_LEVEL_SERIAL_MAP, ImmutableMap.of());
    }

    public static Optional<String> initKeyspaceName(ConfigMap configurationMap) {
        return Optional.ofNullable(configurationMap.getTyped(ConfigurationParameters.KEYSPACE_NAME));
    }

    public static Session initSession(Cluster cluster, ConfigMap configurationMap) {
        LOGGER.trace("Extract or init Session from configuration map");
        return Optional.ofNullable(configurationMap.getTyped(ConfigurationParameters.NATIVE_SESSION)).orElseGet(() -> ArgumentExtractor.initKeyspaceName(configurationMap).map(arg_0 -> ((Cluster)cluster).connect(arg_0)).orElseGet(() -> ((Cluster)cluster).connect()));
    }

    public static boolean initProvidedSession(ConfigMap configurationMap) {
        LOGGER.trace("Is Session object provided or built internally ?");
        return Optional.ofNullable(configurationMap.getTyped(ConfigurationParameters.NATIVE_SESSION)).isPresent();
    }

    public static List<Interceptor<?>> initInterceptors(ConfigMap configurationMap) {
        LOGGER.trace("Extract or init Interceptors");
        ArrayList interceptors = (ArrayList)configurationMap.get((Object)ConfigurationParameters.EVENT_INTERCEPTORS);
        if (interceptors == null) {
            interceptors = new ArrayList();
        }
        return new ArrayList(new LinkedHashSet(interceptors));
    }

    static Validator initValidator(ConfigMap configurationMap) {
        LOGGER.trace("Extract or init Bean validation");
        Boolean enablePreMutateBeanValidation = configurationMap.getTypedOr(ConfigurationParameters.BEAN_VALIDATION_ENABLE, false);
        if (enablePreMutateBeanValidation.booleanValue()) {
            try {
                Validator defaultValidator = Validation.buildDefaultValidatorFactory().getValidator();
                return configurationMap.getTypedOr(ConfigurationParameters.BEAN_VALIDATION_VALIDATOR, defaultValidator);
            }
            catch (ValidationException vex) {
                throw new AchillesException("Cannot bootstrap ValidatorFactory for Bean Validation (JSR 303)", (Throwable)vex);
            }
        }
        return null;
    }

    static boolean initPostLoadBeanValidation(ConfigMap configMap) {
        LOGGER.trace("Extract or init Post Load Bean validation");
        return configMap.getTypedOr(ConfigurationParameters.POST_LOAD_BEAN_VALIDATION_ENABLE, false);
    }

    public static Integer initPreparedStatementsCacheSize(ConfigMap configMap) {
        LOGGER.trace("Extract or init prepared statements cache size");
        return configMap.getTypedOr(ConfigurationParameters.PREPARED_STATEMENTS_CACHE_SIZE, 10000);
    }

    public static InsertStrategy initInsertStrategy(ConfigMap configMap) {
        LOGGER.trace("Extract or init global Insert strategy");
        return configMap.getTypedOr(ConfigurationParameters.GLOBAL_INSERT_STRATEGY, DEFAULT_INSERT_STRATEGY);
    }

    public static NamingStrategy initGlobalNamingStrategy(ConfigMap configMap) {
        LOGGER.trace("Extract or init global Naming strategy");
        return configMap.getTypedOr(ConfigurationParameters.GLOBAL_NAMING_STRATEGY, DEFAULT_GLOBAL_NAMING_STRATEGY);
    }

    public static Optional<SchemaNameProvider> initSchemaNameProvider(ConfigMap configMap) {
        LOGGER.trace("Extract or init schema name provider");
        return Optional.ofNullable(configMap.getTyped(ConfigurationParameters.SCHEMA_NAME_PROVIDER));
    }

    public static ExecutorService initExecutorService(ConfigMap configMap) {
        LOGGER.trace("Extract or init executor service (thread pool)");
        return configMap.getTypedOr(ConfigurationParameters.EXECUTOR_SERVICE, ArgumentExtractor.initializeDefaultExecutor(configMap));
    }

    public static boolean initProvidedExecutorService(ConfigMap configMap) {
        LOGGER.trace("Is executor service provided or built internally ? ");
        return Optional.ofNullable(configMap.getTyped(ConfigurationParameters.EXECUTOR_SERVICE)).isPresent();
    }

    private static Supplier<ExecutorService> initializeDefaultExecutor(ConfigMap configMap) {
        return () -> {
            int minThreads = configMap.getTypedOr(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_MIN_THREAD, 10);
            int maxThreads = configMap.getTypedOr(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_MAX_THREAD, 10);
            long threadKeepAlive = configMap.getTypedOr(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_THREAD_KEEPALIVE, 60L);
            int queueSize = configMap.getTypedOr(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_QUEUE_SIZE, 1000);
            ThreadFactory threadFactory = configMap.getTypedOr(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_THREAD_FACTORY, DEFAULT_THREAD_POOL_THREAD_FACTORY);
            return new ThreadPoolExecutor(minThreads, maxThreads, threadKeepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory);
        };
    }

    private static BeanFactory initDefaultBeanFactory(ConfigMap configMap) {
        LOGGER.trace("Extract or init default bean factory");
        if (configMap.containsKey((Object)ConfigurationParameters.DEFAULT_BEAN_FACTORY)) {
            return (BeanFactory)configMap.getTyped(ConfigurationParameters.DEFAULT_BEAN_FACTORY);
        }
        return DEFAULT_BEAN_FACTORY;
    }

    private static StatementsCache initStatementCache(ConfigMap configMap) {
        LOGGER.trace("Extract or init default statement cache");
        if (configMap.containsKey((Object)ConfigurationParameters.STATEMENTS_CACHE)) {
            return (StatementsCache)configMap.getTyped(ConfigurationParameters.STATEMENTS_CACHE);
        }
        Integer cacheSize = ArgumentExtractor.initPreparedStatementsCacheSize(configMap);
        return new StatementsCache(cacheSize);
    }

    private static Map<CodecSignature<?, ?>, Codec<?, ?>> initRuntimeCodecs(ConfigMap configMap) {
        LOGGER.trace("Extract or init default runtime codecs");
        if (configMap.containsKey((Object)ConfigurationParameters.RUNTIME_CODECS)) {
            return (Map)configMap.getTyped(ConfigurationParameters.RUNTIME_CODECS);
        }
        return new HashMap();
    }

    private static Integer initDMLResultsDisplayLimit(ConfigMap configMap) {
        if (configMap.containsKey((Object)ConfigurationParameters.DML_RESULTS_DISPLAY_SIZE)) {
            Integer resultsDisplaySize = (Integer)configMap.getTyped(ConfigurationParameters.DML_RESULTS_DISPLAY_SIZE);
            return Integer.max(0, Integer.min(resultsDisplaySize, CassandraOptions.MAX_RESULTS_DISPLAY_SIZE));
        }
        return DEFAULT_DML_RESULTS_DISPLAY_SIZE;
    }
}

