/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.apt;

import com.datastax.driver.core.UDTValue;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import info.archinnov.achilles.annotations.UDT;
import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.VariableElementImpl;

public class AptUtils {
    private static boolean HAS_JAVAC_CLASSES = false;
    private static boolean HAS_ECJ_CLASSES = false;
    public final Elements elementUtils;
    public final Types typeUtils;
    public final Messager messager;
    public final Filer filer;

    public AptUtils(Elements elementUtils, Types typeUtils, Messager messager, Filer filer) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.messager = messager;
        this.filer = filer;
    }

    public static boolean isPrimitive(TypeMirror typeMirror) {
        return typeMirror.getKind().isPrimitive();
    }

    public static boolean isArray(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.ARRAY;
    }

    public static boolean isAnEnum(TypeMirror typeMirror) {
        return MoreTypes.asDeclared((TypeMirror)typeMirror).asElement().getKind() == ElementKind.ENUM;
    }

    public static boolean isAnEnum(Object enumValue) {
        return enumValue.getClass().isEnum();
    }

    public static List<? extends TypeMirror> getTypeArguments(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.DECLARED ? MoreTypes.asDeclared((TypeMirror)typeMirror).getTypeArguments() : Arrays.asList(new TypeMirror[0]);
    }

    public static List<? extends TypeMirror> getInterfaces(TypeMirror typeMirror) {
        return MoreElements.asType((Element)MoreTypes.asElement((TypeMirror)typeMirror)).getInterfaces();
    }

    public static boolean containsAnnotation(Set<Class<? extends Annotation>> annotationMirrors, Class<? extends Annotation> annotationClass) {
        return annotationMirrors.stream().filter(x -> x.equals(annotationClass)).findAny().isPresent();
    }

    public static long countElementsAnnotatedBy(Set<? extends TypeElement> typeElements, Class<? extends Annotation> annotationClass) {
        return typeElements.stream().filter(annotation -> AptUtils.isAnnotationOfType(annotation, annotationClass)).count();
    }

    public static boolean containsElementsAnnotatedBy(Set<? extends TypeElement> typeElements, Class<? extends Annotation> annotationClass) {
        return AptUtils.countElementsAnnotatedBy(typeElements, annotationClass) > 0L;
    }

    public static boolean containsAnnotation(AnnotationTree annotationTree, Class<? extends Annotation> annotationClass) {
        return annotationTree.getAnnotations().keySet().stream().filter(x -> x.equals(annotationClass)).findAny().isPresent();
    }

    public static List<TypeElement> getTypesAnnotatedBy(Set<? extends TypeElement> annotatedTypes, RoundEnvironment roundEnv, Class<? extends Annotation> annotationClass) {
        return AptUtils.getTypesAnnotatedByAsStream(annotatedTypes, roundEnv, annotationClass).collect(Collectors.toList());
    }

    public static Stream<TypeElement> getTypesAnnotatedByAsStream(Set<? extends TypeElement> annotatedTypes, RoundEnvironment roundEnv, Class<? extends Annotation> annotationClass) {
        return annotatedTypes.stream().filter(annotation -> AptUtils.isAnnotationOfType(annotation, annotationClass)).flatMap(annotation -> roundEnv.getElementsAnnotatedWith(annotationClass).stream()).map(MoreElements::asType);
    }

    public static Optional<TypedMap> extractTypedMap(AnnotationTree annotationTree, Class<? extends Annotation> annotationClass) {
        return annotationTree.getAnnotations().entrySet().stream().filter(x -> ((Class)x.getKey()).equals(annotationClass)).map(Map.Entry::getValue).findFirst();
    }

    public static TypeElement asTypeElement(TypeMirror typeMirror) {
        return MoreTypes.asTypeElement((TypeMirror)typeMirror);
    }

    public static boolean isAnnotationOfType(TypeElement element, Class<? extends Annotation> annotationClass) {
        return element.getKind() == ElementKind.ANNOTATION_TYPE && element.getQualifiedName().toString().equals(annotationClass.getCanonicalName());
    }

    public static boolean areSameByClass(AnnotationMirror am, Class<? extends Annotation> anno) {
        return AptUtils.areSameByName(am, anno.getCanonicalName().intern());
    }

    public static boolean areSameByName(AnnotationMirror am, String aname) {
        return AptUtils.annotationName(am) == aname;
    }

    public static final String annotationName(AnnotationMirror annotation) {
        TypeElement elm = (TypeElement)annotation.getAnnotationType().asElement();
        return elm.getQualifiedName().toString().intern();
    }

    public static Map<ExecutableElement, AnnotationValue> getElementValuesWithDefaults(AnnotationMirror annotMirror) {
        Map valMap = Optional.ofNullable(annotMirror.getElementValues()).map(x -> new HashMap(x)).orElse(new HashMap());
        ElementFilter.methodsIn(annotMirror.getAnnotationType().asElement().getEnclosedElements()).stream().map(annot -> Tuple2.of((Object)annot, (Object)annot.getDefaultValue())).filter(tuple2 -> tuple2._2() != null && !valMap.containsKey(tuple2._1())).forEach(tuple2 -> {
            AnnotationValue cfr_ignored_0 = (AnnotationValue)valMap.put(tuple2._1(), tuple2._2());
        });
        return valMap;
    }

    public static <T> T getElementValue(AnnotationMirror anno, CharSequence name, Class<T> expectedType, boolean useDefaults) {
        Map<ExecutableElement, AnnotationValue> valmap = useDefaults ? AptUtils.getElementValuesWithDefaults(anno) : anno.getElementValues();
        for (ExecutableElement elem : valmap.keySet()) {
            if (!elem.getSimpleName().contentEquals(name)) continue;
            AnnotationValue val = valmap.get(elem);
            return expectedType.cast(val.getValue());
        }
        return null;
    }

    public static <T> List<T> getElementValueArray(AnnotationMirror anno, CharSequence name, Class<T> expectedType, boolean useDefaults) {
        return AptUtils.getElementValue(anno, name, List.class, useDefaults).stream().map(elementVal -> expectedType.cast(elementVal.getValue())).collect(Collectors.toList());
    }

    public static javax.lang.model.element.Name getElementValueClassName(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        Type.ClassType ct = AptUtils.getElementValue(anno, name, Type.ClassType.class, useDefaults);
        return ((Symbol)ct.asElement()).getQualifiedName();
    }

    public static <T> Optional<Class<T>> getElementValueClass(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        javax.lang.model.element.Name cn = AptUtils.getElementValueClassName(anno, name, useDefaults);
        try {
            Class<?> cls = Class.forName(cn.toString());
            return Optional.of(cls);
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static <T extends Enum<T>> T getElementValueEnum(AnnotationMirror anno, CharSequence name, Class<T> t, boolean useDefaults) {
        Symbol.VarSymbol vs = AptUtils.getElementValue(anno, name, Symbol.VarSymbol.class, useDefaults);
        T value = Enum.valueOf(t, ((Name)vs.getSimpleName()).toString());
        return value;
    }

    public static TypeElement enclosingClass(Element elem) {
        Element result = elem;
        while (result != null && !result.getKind().isClass() && !result.getKind().isInterface()) {
            Element encl;
            result = encl = result.getEnclosingElement();
        }
        return (TypeElement)result;
    }

    public static VariableElement findFieldInType(TypeElement type, String name) {
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if (!field.getSimpleName().toString().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static boolean isJavaCompiler(VariableElement varElm) {
        return HAS_JAVAC_CLASSES && varElm instanceof Symbol.VarSymbol;
    }

    public static boolean isJavaCompiler(TypeElement typeElm) {
        return HAS_JAVAC_CLASSES && typeElm instanceof Symbol.ClassSymbol;
    }

    public static boolean isJavaCompiler(ExecutableElement executableElement) {
        return HAS_JAVAC_CLASSES && executableElement instanceof Symbol.MethodSymbol;
    }

    public static boolean isEclipseCompiler(VariableElement varElm) {
        return HAS_ECJ_CLASSES && varElm instanceof VariableElementImpl;
    }

    public static boolean isEclipseCompiler(TypeElement typeElm) {
        return HAS_ECJ_CLASSES && typeElm instanceof TypeElementImpl;
    }

    public static boolean isEclipseCompiler(ExecutableElement executableElement) {
        return HAS_ECJ_CLASSES && executableElement instanceof ExecutableElementImpl;
    }

    public static String getShortname(TypeName typeName) {
        return typeName.toString().replaceAll("[^.]+\\.", "");
    }

    public <T extends Annotation> Optional<T> getAnnotationOnClass(TypeMirror typeMirror, Class<T> annotationClass) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            return Optional.ofNullable(this.elementUtils.getTypeElement(MoreTypes.asDeclared((TypeMirror)this.erasure(typeMirror)).asElement().toString()).getAnnotation(annotationClass));
        }
        return Optional.empty();
    }

    public <T extends Annotation> Optional<T> getAnnotationOnClass(TypeElement typeElement, Class<T> annotationClass) {
        return Optional.ofNullable(this.elementUtils.getTypeElement(typeElement.getQualifiedName()).getAnnotation(annotationClass));
    }

    public TypeName extractTypeArgument(TypeName typeName, int argumentIndex) {
        this.validateTrue(typeName instanceof ParameterizedTypeName, "Type name %s is not an instance of ParameterizedTypeName", typeName);
        ParameterizedTypeName paramTypeName = (ParameterizedTypeName)typeName;
        this.validateTrue(paramTypeName.typeArguments.size() >= argumentIndex + 1, "Cannot get '%s' th argument from ParameterizedTypeName '%s' ", argumentIndex, paramTypeName);
        return (TypeName)paramTypeName.typeArguments.get(argumentIndex);
    }

    public boolean isAssignableFrom(Class<?> superClass, TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        switch (kind) {
            case BOOLEAN: {
                return superClass.equals(Boolean.TYPE);
            }
            case BYTE: {
                return superClass.equals(Byte.TYPE);
            }
            case SHORT: {
                return superClass.equals(Short.TYPE);
            }
            case INT: {
                return superClass.equals(Integer.TYPE);
            }
            case LONG: {
                return superClass.equals(Long.TYPE);
            }
            case CHAR: {
                return superClass.equals(Character.TYPE);
            }
            case FLOAT: {
                return superClass.equals(Float.TYPE);
            }
            case DOUBLE: {
                return superClass.equals(Float.TYPE);
            }
            case DECLARED: {
                return this.typeUtils.isAssignable(AptUtils.asTypeElement(typeMirror).asType(), this.elementUtils.getTypeElement(superClass.getCanonicalName()).asType());
            }
            case ARRAY: {
                TypeMirror componentType = MoreTypes.asArray((TypeMirror)typeMirror).getComponentType();
                Class<?> componentClass = superClass.getComponentType();
                return componentClass == null ? false : this.isAssignableFrom(componentClass, componentType);
            }
        }
        return false;
    }

    public ExecutableElement findGetter(TypeElement classElm, VariableElement elm, List<String> getterNames) {
        TypeMirror typeMirror = elm.asType();
        Optional<ExecutableElement> getter = ElementFilter.methodsIn(this.elementUtils.getAllMembers(classElm)).stream().filter(x -> getterNames.contains(x.getSimpleName().toString())).filter(x -> this.typeUtils.isSameType(x.getReturnType(), typeMirror)).findFirst();
        this.validateTrue(getter.isPresent(), "Cannot find getter of names '%s' for field '%s' in class '%s'", getterNames, elm.getSimpleName(), classElm.getQualifiedName());
        return getter.get();
    }

    public ExecutableElement findSetter(TypeElement classElm, VariableElement elm, String setterName) {
        TypeMirror typeMirror = elm.asType();
        Optional<ExecutableElement> setter = ElementFilter.methodsIn(this.elementUtils.getAllMembers(classElm)).stream().filter(x -> x.getSimpleName().contentEquals(setterName)).filter(x -> x.getParameters().size() == 1).filter(x -> x.getParameters().stream().map(Element::asType).filter(y -> this.typeUtils.isSameType((TypeMirror)y, typeMirror)).count() == 1L).filter(x -> x.getReturnType().getKind() == TypeKind.VOID).findFirst();
        this.validateTrue(setter.isPresent(), "Cannot find setter 'void %s(%s value)' for field '%s' in class '%s'", setterName, typeMirror, elm.getSimpleName(), classElm.getQualifiedName());
        return setter.get();
    }

    public void printError(String message, Object ... args) {
        this.print(Diagnostic.Kind.ERROR, message, args);
    }

    public void printWarning(String message, Object ... args) {
        this.print(Diagnostic.Kind.WARNING, message, args);
    }

    public void printMandatoryWarning(String message, Object ... args) {
        this.print(Diagnostic.Kind.MANDATORY_WARNING, message, args);
    }

    public void printNote(String message, Object ... args) {
        this.print(Diagnostic.Kind.NOTE, message, args);
    }

    public void print(Diagnostic.Kind kind, String message, Object ... args) {
        this.messager.printMessage(kind, String.format(message, args));
    }

    public TypeMirror erasure(TypeElement typeElement) {
        return this.typeUtils.erasure(typeElement.asType());
    }

    public TypeMirror erasure(TypeMirror typeMirror) {
        return this.typeUtils.erasure(typeMirror);
    }

    public void validateTrue(boolean condition, String message, Object ... params) {
        if (!condition) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(message, params));
            throw new AchillesBeanMappingException(String.format(message, params));
        }
    }

    public void validateFalse(boolean condition, String message, Object ... params) {
        if (condition) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(message, params));
            throw new AchillesBeanMappingException(String.format(message, params));
        }
    }

    public boolean isCompositeTypeForCassandra(TypeMirror typeMirror) {
        TypeMirror type = this.erasure(typeMirror);
        return this.isAssignableFrom(List.class, type) || this.isAssignableFrom(Set.class, type) || this.isAssignableFrom(Map.class, type) || this.isAssignableFrom(List.class, type) || this.isAssignableFrom(UDTValue.class, type) || this.getAnnotationOnClass(typeMirror, UDT.class).isPresent();
    }

    static {
        try {
            Class.forName("com.sun.tools.javac.code.Symbol");
            HAS_JAVAC_CLASSES = true;
        }
        catch (ClassNotFoundException e) {
            HAS_JAVAC_CLASSES = false;
        }
        try {
            Class.forName("org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl");
            HAS_ECJ_CLASSES = true;
        }
        catch (ClassNotFoundException e) {
            HAS_ECJ_CLASSES = false;
        }
    }
}

