/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.cache;

import com.datastax.driver.core.PreparedStatement;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.PreparedStatementGenerator;
import info.archinnov.achilles.type.SchemaNameProvider;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheKey {
    private final Class<?> entityClass;
    private final Operation operation;

    public CacheKey(Class<?> entityClass, Operation operation) {
        this.entityClass = entityClass;
        this.operation = operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        return Objects.equals(this.entityClass, cacheKey.entityClass) && Objects.equals((Object)this.operation, (Object)cacheKey.operation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityClass, this.operation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CacheKey{");
        sb.append("entityClass=").append(this.entityClass);
        sb.append(", operation=").append((Object)this.operation);
        sb.append('}');
        return sb.toString();
    }

    public static enum Operation {
        FIND{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare SELECT statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, FIND));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateSelectQuery(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        INSERT{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare INSERT statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, INSERT));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateInsert(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        INSERT_JSON{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare INSERT JSON statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, INSERT_JSON));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateInsertJSON(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        INSERT_STATIC{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare INSERT STATIC statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, INSERT_STATIC));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateInsertStatic(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        INSERT_IF_NOT_EXISTS{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare INSERT IF NOT EXISTS statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, INSERT_IF_NOT_EXISTS));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateInsertIfNotExists(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        INSERT_IF_NOT_EXISTS_JSON{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare INSERT JSON ... IF NOT EXISTS statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, INSERT_IF_NOT_EXISTS_JSON));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateInsertIfNotExistsJson(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        INSERT_STATIC_IF_NOT_EXISTS{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare INSERT STATIC IF NOT EXISTS statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, INSERT_STATIC_IF_NOT_EXISTS));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateInsertStaticIfNotExists(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        DELETE{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare DELETE statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, DELETE));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateDeleteByKeys(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        DELETE_IF_EXISTS{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare DELETE IF EXISTS statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, DELETE_IF_EXISTS));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateDeleteByKeysIfExists(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        DELETE_BY_PARTITION{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Prepare DELETE BY PARTITION statement for entity of type %s", meta.entityClass.getCanonicalName()));
                }
                Optional<SchemaNameProvider> provider = cassandraOptions.getSchemaNameProvider();
                PreparedStatement psFromCache = rte.getStaticCache(new CacheKey(meta.entityClass, DELETE_BY_PARTITION));
                return rte.maybePrepareIfDifferentSchemaNameFromCache(meta, psFromCache, provider, () -> PreparedStatementGenerator.generateDeleteByPartition(meta, provider)).orElse(psFromCache);
            }
        }
        ,
        UPDATE{

            @Override
            public PreparedStatement getPreparedStatement(RuntimeEngine rte, AbstractEntityProperty<?> meta, CassandraOptions cassandraOptions) {
                return null;
            }
        };

        private static final Logger LOGGER;

        public abstract PreparedStatement getPreparedStatement(RuntimeEngine var1, AbstractEntityProperty<?> var2, CassandraOptions var3);

        static {
            LOGGER = LoggerFactory.getLogger(Operation.class);
        }
    }
}

