/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codec;

import com.datastax.driver.core.utils.Bytes;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import info.archinnov.achilles.type.codec.Codec;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayPrimitiveCodec
implements Codec<byte[], ByteBuffer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteArrayPrimitiveCodec.class);

    public Class<byte[]> sourceType() {
        return byte[].class;
    }

    public Class<ByteBuffer> targetType() {
        return ByteBuffer.class;
    }

    public ByteBuffer encode(byte[] fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encoding byte[] '%s' to ByteBuffer", Bytes.toHexString((byte[])ByteBuffer.wrap(fromJava).duplicate().array())));
        }
        return ByteBuffer.wrap(fromJava);
    }

    public byte[] decode(ByteBuffer fromCassandra) {
        if (fromCassandra == null) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decoding ByteBuffer '%s' to byte[]", Bytes.toHexString((ByteBuffer)fromCassandra.duplicate())));
        }
        return this.readByteBuffer(fromCassandra);
    }

    private byte[] readByteBuffer(Object fromCassandra) {
        ByteBuffer byteBuffer = (ByteBuffer)fromCassandra;
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return bytes;
    }
}

