/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codec;

import info.archinnov.achilles.exception.AchillesTranscodingException;
import info.archinnov.achilles.type.codec.Codec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumNameCodec<ENUM>
implements Codec<ENUM, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumNameCodec.class);
    private final List<ENUM> enumValues;
    private final Class<ENUM> sourceType;

    public EnumNameCodec(List<ENUM> enumValues, Class<ENUM> sourceType) {
        this.enumValues = enumValues;
        this.sourceType = sourceType;
    }

    public static <TYPE> EnumNameCodec<TYPE> create(List<TYPE> enumTypes, Class<TYPE> sourceType) {
        return new EnumNameCodec<TYPE>(enumTypes, sourceType);
    }

    public Class<ENUM> sourceType() {
        return this.sourceType;
    }

    public Class<String> targetType() {
        return String.class;
    }

    public String encode(ENUM fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encoding enum %s to String", fromJava));
        }
        if (!fromJava.getClass().isEnum()) {
            throw new AchillesTranscodingException(String.format("Object '%s' to be encoded should be an enum", fromJava));
        }
        if (!this.enumValues.contains(fromJava)) {
            throw new AchillesTranscodingException(String.format("Cannot find matching enum values for '%s' from possible enum constants '%s' ", fromJava, this.enumValues));
        }
        return ((Enum)fromJava).name();
    }

    public ENUM decode(String fromCassandra) throws AchillesTranscodingException {
        if (fromCassandra == null) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decoding enum type %s from String %s", this.sourceType.getCanonicalName(), fromCassandra));
        }
        for (ENUM enumValue : this.enumValues) {
            if (!((Enum)enumValue).name().equals(fromCassandra)) continue;
            return enumValue;
        }
        throw new AchillesTranscodingException(String.format("Cannot find matching enum values for '%s' from possible enum constants '%s' ", fromCassandra, this.enumValues));
    }
}

