/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.codegen.ManagerCodeGen;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.FunctionSignature;
import info.archinnov.achilles.internals.parser.context.FunctionsContext;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.lang.model.element.Modifier;

public class ManagerFactoryCodeGen {
    public static ManagersAndDSLClasses buildInstance(AptUtils aptUtils, List<EntityMetaCodeGen.EntityMetaSignature> signatures, FunctionsContext functionsContext, GlobalParsingContext parsingContext) {
        ArrayList<TypeSpec> managerClasses = new ArrayList<TypeSpec>();
        ArrayList<TypeSpec> dslClasses = new ArrayList<TypeSpec>();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)parsingContext.managerFactoryClassName()).superclass((TypeName)TypeUtils.ABSTRACT_MANAGER_FACTORY).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(ManagerFactoryCodeGen.buildConstructor(signatures, functionsContext)).addMethod(ManagerFactoryCodeGen.buildGetCassandraVersion(parsingContext));
        for (EntityMetaCodeGen.EntityMetaSignature x : signatures) {
            ClassName managerType = ClassName.get((String)"info.archinnov.achilles.generated.manager", (String)(x.className + "_Manager"), (String[])new String[0]);
            ManagerCodeGen.ManagerAndDSLClasses managerAndDSLClasses = ManagerCodeGen.buildManager(parsingContext, aptUtils, x);
            managerClasses.add(managerAndDSLClasses.managerClass);
            dslClasses.addAll(managerAndDSLClasses.dslClasses);
            FieldSpec entityPropertyMeta = FieldSpec.builder((TypeName)x.typeName, (String)(x.fieldName + "_AchillesMeta"), (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).initializer("new $T()", new Object[]{x.typeName}).build();
            FieldSpec entityManager = FieldSpec.builder((TypeName)managerType, (String)(x.fieldName + "_Manager"), (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).initializer("new $T($T.class, $L, rte)", new Object[]{managerType, x.entityRawClass, x.fieldName + "_AchillesMeta"}).build();
            builder.addField(entityPropertyMeta).addField(entityManager).addMethod(ManagerFactoryCodeGen.buildManagerFor(x));
        }
        for (FunctionSignature functionSignature : functionsContext.functionSignatures) {
            builder.addField(ManagerFactoryCodeGen.buildFunctionProperty(functionSignature));
        }
        ParameterizedTypeName listOfUdtClassProperties = TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeUtils.genericType(TypeUtils.ABSTRACT_UDT_CLASS_PROPERTY, TypeUtils.WILDCARD)});
        builder.addMethod(ManagerFactoryCodeGen.getUDTClassProperties(parsingContext, (TypeName)listOfUdtClassProperties));
        return new ManagersAndDSLClasses(builder.build(), managerClasses, dslClasses);
    }

    private static FieldSpec buildFunctionProperty(FunctionSignature functionSignature) {
        String fieldName = functionSignature.name + "_FunctionProperty";
        CodeBlock keyspaceCodeBlock = functionSignature.keyspace.isPresent() ? CodeBlock.builder().add("$T.of($S)", new Object[]{TypeUtils.OPTIONAL, functionSignature.keyspace.get()}).build() : CodeBlock.builder().add("$T.empty()", new Object[]{TypeUtils.OPTIONAL}).build();
        StringJoiner functionParams = new StringJoiner(", ", "$T.asList(", ")");
        for (FunctionSignature.FunctionParamSignature parameterSignature : functionSignature.parameterSignatures) {
            functionParams.add("\"" + parameterSignature.targetCQLDataType + "\"");
        }
        CodeBlock parametersCodeBlock = CodeBlock.builder().add(functionParams.toString(), new Object[]{TypeUtils.ARRAYS}).build();
        CodeBlock functionProperty = CodeBlock.builder().add("new $T($L, $S, $S, $L)", new Object[]{TypeUtils.FUNCTION_PROPERTY, keyspaceCodeBlock, functionSignature.name.toLowerCase(), functionSignature.returnTypeSignature.targetCQLDataType, parametersCodeBlock}).build();
        return FieldSpec.builder((TypeName)TypeUtils.FUNCTION_PROPERTY, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(functionProperty).build();
    }

    private static MethodSpec buildGetCassandraVersion(GlobalParsingContext parsingContext) {
        ClassName cassandraVersionClass = ClassName.get(parsingContext.cassandraVersion.getClass());
        return MethodSpec.methodBuilder((String)"getCassandraVersion").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).addAnnotation(Override.class).returns((TypeName)TypeUtils.INTERNAL_CASSANDRA_VERSION).addStatement("return $T.INSTANCE", new Object[]{cassandraVersionClass}).build();
    }

    private static MethodSpec getUDTClassProperties(GlobalParsingContext parsingContext, TypeName listOfUdtClassProperties) {
        MethodSpec.Builder getUdtClassPropertiesBuilder = MethodSpec.methodBuilder((String)"getUdtClassProperties").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).addAnnotation(Override.class).returns(listOfUdtClassProperties).addStatement("final $T list = new $T<>()", new Object[]{listOfUdtClassProperties, TypeUtils.ARRAY_LIST});
        for (Map.Entry<TypeName, TypeSpec> entry : parsingContext.udtTypes.entrySet()) {
            getUdtClassPropertiesBuilder.addStatement("list.add($L.INSTANCE)", new Object[]{"info.archinnov.achilles.generated.meta.udt." + entry.getValue().name});
        }
        getUdtClassPropertiesBuilder.addStatement("return list", new Object[0]);
        return getUdtClassPropertiesBuilder.build();
    }

    private static MethodSpec buildConstructor(List<EntityMetaCodeGen.EntityMetaSignature> signatures, FunctionsContext functionsContext) {
        StringJoiner entityProperties = new StringJoiner(", ");
        StringJoiner functionProperties = new StringJoiner(", ");
        signatures.stream().map(x -> x.fieldName + "_AchillesMeta").forEach(entityProperties::add);
        functionsContext.functionSignatures.stream().map(signature -> signature.name + "_FunctionProperty").forEach(functionProperties::add);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeUtils.CLUSTER, "cluster", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)TypeUtils.CONFIGURATION_CONTEXT, "configContext", new Modifier[]{Modifier.FINAL}).addStatement("super($N, $N)", new Object[]{"cluster", "configContext"}).addStatement("this.entityProperties = $T.asList($L)", new Object[]{TypeUtils.ARRAYS, entityProperties.toString()}).addStatement("this.functionProperties = $T.asList($L)", new Object[]{TypeUtils.ARRAYS, functionProperties.toString()}).addStatement("this.entityClasses = this.entityProperties.stream().map(x -> x.entityClass).collect($T.toList())", new Object[]{TypeUtils.COLLECTORS}).addStatement("bootstrap()", new Object[0]).build();
    }

    private static MethodSpec buildManagerFor(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName returnType = ClassName.get((String)"info.archinnov.achilles.generated.manager", (String)(signature.className + "_Manager"), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)("for" + signature.className)).addJavadoc("Create a Manager for entity class $T", new Object[]{signature.entityRawClass}).addJavadoc("\n", new Object[0]).addJavadoc("@return $T", new Object[]{returnType}).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addStatement("return $L", new Object[]{signature.fieldName + "_Manager"}).returns((TypeName)returnType).build();
    }

    public static class ManagersAndDSLClasses {
        public final TypeSpec managerFactoryClass;
        public final List<TypeSpec> managerClasses;
        public final List<TypeSpec> dslClasses;

        public ManagersAndDSLClasses(TypeSpec managerFactoryClass, List<TypeSpec> managerClasses, List<TypeSpec> dslClasses) {
            this.managerFactoryClass = managerFactoryClass;
            this.managerClasses = managerClasses;
            this.dslClasses = dslClasses;
        }
    }
}

