/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.dsl;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import info.archinnov.achilles.internals.codegen.dsl.AbstractDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.update.UpdateDSLCodeGen;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import javax.lang.model.element.Modifier;

public interface JSONFunctionCallSupport {
    default public TypeSpec.Builder buildSelectFromJSON(EntityMetaCodeGen.EntityMetaSignature signature, String className, TypeName selectWhereJSONTypeName, TypeName selectEndJSONTypeName) {
        return TypeSpec.classBuilder((String)className).superclass((TypeName)TypeUtils.ABSTRACT_SELECT_FROM_JSON).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.constructorBuilder().addParameter(TypeUtils.SELECT_DOT_WHERE, "where", new Modifier[0]).addParameter((TypeName)TypeUtils.OPTIONS, "cassandraOptions", new Modifier[0]).addStatement("super(where, cassandraOptions)", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"where").addJavadoc("Generate a SELECT ... FROM ... <strong>WHERE</strong> ...", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T(where, cassandraOptions)", new Object[]{selectWhereJSONTypeName}).returns(selectWhereJSONTypeName).build()).addMethod(MethodSpec.methodBuilder((String)"without_WHERE_Clause").addJavadoc("Generate a SELECT statement <strong>without</strong> the <strong>WHERE</strong> clause", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T(where, cassandraOptions)", new Object[]{selectEndJSONTypeName}).returns(selectEndJSONTypeName).build());
    }

    default public MethodSpec buildToJSONFunctionCall() {
        TypeName STRING_TYPE = TypeUtils.determineTypeForFunctionParam(TypeUtils.STRING);
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{TypeUtils.ABSTRACT_CQL_COMPATIBLE_TYPE, TypeUtils.FUNCTION_CALL});
        AnnotationSpec unchecked = AnnotationSpec.builder((ClassName)ClassName.get(SuppressWarnings.class)).addMember("value", "$S", new Object[]{"rawtypes"}).build();
        MethodSpec.Builder toJSONFunctionBuilder = MethodSpec.methodBuilder((String)"toJson").addTypeVariable(typeVariableName).addAnnotation(unchecked).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("Call $S function with given parameters", new Object[]{"toJson"}).returns(STRING_TYPE).addParameter((TypeName)typeVariableName, "input", new Modifier[]{Modifier.FINAL}).addStatement("final $T<Object> params = new $T<>()", new Object[]{TypeUtils.LIST, TypeUtils.ARRAY_LIST}).addStatement("$T.validateFalse(input.isFunctionCall(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'toJson' function, it does not accept function call as argument, only simple column"}).addStatement("$T.validateFalse(input.hasLiteralValue(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'toJson' function, it does not accept literal value as argument, only simple column"}).addStatement("params.add($T.column((String)$L.getValue()))", new Object[]{TypeUtils.QUERY_BUILDER, "input"});
        TypeSpec.Builder toJSONAnonClassBuilder = TypeSpec.anonymousClassBuilder((String)"$T.empty()", (Object[])new Object[]{TypeUtils.OPTIONAL}).superclass(STRING_TYPE).addMethod(MethodSpec.methodBuilder((String)"isFunctionCall").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.BOOLEAN).addStatement("return true", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"functionName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeUtils.STRING).addStatement("return $S", new Object[]{"toJson"}).build()).addMethod(MethodSpec.methodBuilder((String)"parameters").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeName.OBJECT})).addStatement("return params", new Object[0]).build());
        return toJSONFunctionBuilder.addStatement("return $L", new Object[]{toJSONAnonClassBuilder.build()}).build();
    }

    default public void buildSetFromJSONToRelationClass(UpdateDSLCodeGen.ParentSignature parentSignature, FieldParser.FieldMetaSignature fieldMeta, TypeName newTypeName, AbstractDSLCodeGen.ReturnType returnType) {
        String param = parentSignature.parentFieldName.map(x -> x + "_" + fieldMeta.context.fieldName + "_element").orElse(fieldMeta.context.fieldName + "_element");
        String cqlColumn = parentSignature.parentQuotedCQLColumn.map(x -> x + "." + fieldMeta.context.quotedCqlColumn).orElse(fieldMeta.context.quotedCqlColumn);
        MethodSpec.Builder setFromJSONMethodBuilder = MethodSpec.methodBuilder((String)"Set_FromJSON").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = fromJson(?)</strong>", new Object[]{cqlColumn}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.of($S, $T.fromJson($T.bindMarker($S))))", new Object[]{TypeUtils.NON_ESCAPING_ASSIGNMENT, cqlColumn, TypeUtils.QUERY_BUILDER, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add($N)", new Object[]{param}).returns(newTypeName);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            setFromJSONMethodBuilder.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
        } else {
            setFromJSONMethodBuilder.addStatement("return $T.this", new Object[]{newTypeName});
        }
        parentSignature.parentBuilder.addMethod(setFromJSONMethodBuilder.build());
    }

    default public void buildEqFromJSONToRelationClass(TypeSpec.Builder relationClassBuilder, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ClassSignatureInfo nextSignature) {
        String methodName = "Eq_FromJson";
        MethodSpec fromJsonMethod = MethodSpec.methodBuilder((String)"Eq_FromJson").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L $L </strong>", new Object[]{fieldInfo.quotedCqlColumn, " = fromJson(?)"}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, fieldInfo.fieldName, new Modifier[0]).addStatement("where.and($T.eq($S, $T.fromJson($T.bindMarker($S))))", new Object[]{TypeUtils.QUERY_BUILDER, fieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, TypeUtils.QUERY_BUILDER, fieldInfo.quotedCqlColumn}).addStatement("boundValues.add($N)", new Object[]{fieldInfo.fieldName}).addStatement("encodedValues.add($N)", new Object[]{fieldInfo.fieldName}).returns(nextSignature.returnClassType).addStatement("return new $T(where, cassandraOptions)", new Object[]{nextSignature.returnClassType}).build();
        relationClassBuilder.addMethod(fromJsonMethod);
    }

    default public void buildJSONIndexRelationForMapEntry(TypeSpec.Builder relationClassBuilder, AbstractDSLCodeGen.IndexFieldSignatureInfo indexFieldInfo, TypeName returnClassType, AbstractDSLCodeGen.ReturnType returnType) {
        String paramKey = indexFieldInfo.fieldName + "_JSONKey";
        String paramValue = indexFieldInfo.fieldName + "_JSONValue";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"ContainsEntry_FromJSON").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L[fromJson(?)] = fromJson(?)</strong>", new Object[]{indexFieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, paramKey, new Modifier[0]).addParameter(TypeUtils.STRING, paramValue, new Modifier[0]).addStatement("where.and($T.of($S, $T.fromJson($T.bindMarker($S)), $T.fromJson($T.bindMarker($S))))", new Object[]{TypeUtils.MAP_ENTRY_CLAUSE, indexFieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, TypeUtils.QUERY_BUILDER, paramKey, TypeUtils.QUERY_BUILDER, TypeUtils.QUERY_BUILDER, paramValue}).addStatement("boundValues.add($N)", new Object[]{paramKey}).addStatement("boundValues.add($N)", new Object[]{paramValue}).addStatement("encodedValues.add($N)", new Object[]{paramKey}).addStatement("encodedValues.add($N)", new Object[]{paramValue}).returns(returnClassType);
        if (returnType == AbstractDSLCodeGen.ReturnType.THIS) {
            relationClassBuilder.addMethod(builder.addStatement("return $T.this", new Object[]{returnClassType}).build());
        } else {
            relationClassBuilder.addMethod(builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{returnClassType}).build());
        }
    }

    default public void buildJSONIndexRelationForMapKey(TypeSpec.Builder relationClassBuilder, AbstractDSLCodeGen.IndexFieldSignatureInfo indexFieldInfo, TypeName returnClassType, AbstractDSLCodeGen.ReturnType returnType) {
        String param = indexFieldInfo.fieldName + "_JSONKey";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"ContainsKey_FromJSON").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L CONTAINS KEY fromJson(?)</strong>", new Object[]{indexFieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, param, new Modifier[0]).addStatement("where.and($T.containsKey($S, $T.fromJson($T.bindMarker($S))))", new Object[]{TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add($N)", new Object[]{param}).returns(returnClassType);
        if (returnType == AbstractDSLCodeGen.ReturnType.THIS) {
            relationClassBuilder.addMethod(builder.addStatement("return $T.this", new Object[]{returnClassType}).build());
        } else {
            relationClassBuilder.addMethod(builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{returnClassType}).build());
        }
    }

    default public void buildJSONIndexRelationForMapValue(TypeSpec.Builder relationClassBuilder, AbstractDSLCodeGen.IndexFieldSignatureInfo indexFieldInfo, TypeName returnClassType, AbstractDSLCodeGen.ReturnType returnType) {
        String param = indexFieldInfo.fieldName + "_JSONValue";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"ContainsValue_FromJSON").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L CONTAINS fromJson(?)</strong>", new Object[]{indexFieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, param, new Modifier[0]).addStatement("where.and($T.contains($S, $T.fromJson($T.bindMarker($S))))", new Object[]{TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add($N)", new Object[]{param}).returns(returnClassType);
        if (returnType == AbstractDSLCodeGen.ReturnType.THIS) {
            relationClassBuilder.addMethod(builder.addStatement("return $T.this", new Object[]{returnClassType}).build());
        } else {
            relationClassBuilder.addMethod(builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{returnClassType}).build());
        }
    }

    default public void buildJSONIndexRelationForCollection(TypeSpec.Builder relationClassBuilder, AbstractDSLCodeGen.IndexFieldSignatureInfo indexFieldInfo, TypeName returnClassType, AbstractDSLCodeGen.ReturnType returnType) {
        String param = indexFieldInfo.fieldName + "_JSONElement";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"Contains_FromJson").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L CONTAINS fromJson(?)</strong>", new Object[]{indexFieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, param, new Modifier[0]).addStatement("where.and($T.contains($S, $T.fromJson($T.bindMarker($S))))", new Object[]{TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add($N)", new Object[]{param}).returns(returnClassType);
        if (returnType == AbstractDSLCodeGen.ReturnType.THIS) {
            relationClassBuilder.addMethod(builder.addStatement("return $T.this", new Object[]{returnClassType}).build());
        } else {
            relationClassBuilder.addMethod(builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{returnClassType}).build());
        }
    }

    default public void buildIfEqFromJSONToConditionClass(TypeSpec.Builder conditionClassBuilder, AbstractDSLCodeGen.FieldSignatureInfo fieldSignatureInfo, AbstractDSLCodeGen.ClassSignatureInfo currentSignature) {
        String methodName = "Eq_FromJSON";
        String fieldName = fieldSignatureInfo.fieldName;
        String quotedCqlColumn = fieldSignatureInfo.quotedCqlColumn;
        MethodSpec fromJsonMethod = MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate an ... <strong>IF $L = fromJson(?)</strong>", new Object[]{fieldName}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, fieldName, new Modifier[]{Modifier.FINAL}).addStatement("boundValues.add($N)", new Object[]{fieldName}).addStatement("encodedValues.add($N)", new Object[]{fieldName}).addStatement("where.onlyIf($T.eq($S, $T.fromJson($T.bindMarker($S))))", new Object[]{TypeUtils.QUERY_BUILDER, quotedCqlColumn, TypeUtils.QUERY_BUILDER, TypeUtils.QUERY_BUILDER, quotedCqlColumn}).addStatement("return $T.this", new Object[]{currentSignature.returnClassType}).returns(currentSignature.returnClassType).build();
        conditionClassBuilder.addMethod(fromJsonMethod);
    }

    default public MethodSpec buildAllColumnsJSON(TypeName newTypeName, TypeName whereTypeName, String privateFieldName) {
        return MethodSpec.methodBuilder((String)"allColumnsAsJSON_FromBaseTable").addJavadoc("Generate ... * FROM ...", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("final $T where = $L.json().all().from(meta.getKeyspace().orElse($S + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where()", new Object[]{whereTypeName, privateFieldName, "unknown_keyspace_for_"}).addStatement("return new $T(where, new $T())", new Object[]{newTypeName, TypeUtils.OPTIONS}).returns(newTypeName).build();
    }

    default public MethodSpec buildAllColumnsJSONWithSchemaProvider(TypeName newTypeName, TypeName whereTypeName, String privateFieldName) {
        return MethodSpec.methodBuilder((String)"allColumnsAsJSON_From").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("Generate ... * FROM ... using the given SchemaNameProvider", new Object[0]).addParameter((TypeName)TypeUtils.SCHEMA_NAME_PROVIDER, "schemaNameProvider", new Modifier[]{Modifier.FINAL}).addStatement("final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass)", new Object[0]).addStatement("final String currentTable = lookupTable(schemaNameProvider, meta.entityClass)", new Object[0]).addStatement("final $T where = $L.json().all().from(currentKeyspace, currentTable).where()", new Object[]{whereTypeName, privateFieldName}).addStatement("return new $T(where, $T.withSchemaNameProvider(schemaNameProvider))", new Object[]{newTypeName, TypeUtils.OPTIONS}).returns(newTypeName).build();
    }
}

