/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.dsl;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.codegen.dsl.AbstractDSLCodeGen;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.utils.NamingHelper;
import javax.lang.model.element.Modifier;

public interface LWTConditionsCodeGen {
    public void augmentLWTConditionClass(TypeSpec.Builder var1, AbstractDSLCodeGen.FieldSignatureInfo var2, AbstractDSLCodeGen.ClassSignatureInfo var3);

    default public void buildLWtConditionMethods(EntityMetaCodeGen.EntityMetaSignature signature, String parentFQCN, AbstractDSLCodeGen.ClassSignatureInfo currentSignature, boolean hasCounter, TypeSpec.Builder parentBuilder) {
        if (!hasCounter) {
            signature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.NORMAL || x.context.columnType == ColumnType.STATIC).forEach(x -> {
                AbstractDSLCodeGen.FieldSignatureInfo fieldSignatureInfo = AbstractDSLCodeGen.FieldSignatureInfo.of(x.context.fieldName, x.context.cqlColumn, x.sourceType);
                String conditionClassName = "If_" + NamingHelper.upperCaseFirst(x.context.fieldName);
                ClassName conditionClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(parentFQCN + "." + conditionClassName), (String[])new String[0]);
                TypeSpec.Builder conditionClassBuilder = TypeSpec.classBuilder((String)conditionClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildLWTConditionOnColumn("eq", fieldSignatureInfo, currentSignature.returnClassType)).addMethod(this.buildLWTConditionOnColumn("gt", fieldSignatureInfo, currentSignature.returnClassType)).addMethod(this.buildLWTConditionOnColumn("gte", fieldSignatureInfo, currentSignature.returnClassType)).addMethod(this.buildLWTConditionOnColumn("lt", fieldSignatureInfo, currentSignature.returnClassType)).addMethod(this.buildLWTConditionOnColumn("lte", fieldSignatureInfo, currentSignature.returnClassType)).addMethod(this.buildLWTNotEqual(fieldSignatureInfo, currentSignature.returnClassType));
                this.augmentLWTConditionClass(conditionClassBuilder, fieldSignatureInfo, currentSignature);
                parentBuilder.addType(conditionClassBuilder.build());
                parentBuilder.addMethod(MethodSpec.methodBuilder((String)("if_" + NamingHelper.upperCaseFirst(x.context.fieldName))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T()", new Object[]{conditionClassTypeName}).returns((TypeName)conditionClassTypeName).build());
            });
        }
    }

    default public MethodSpec buildLWTConditionOnColumn(String relation, AbstractDSLCodeGen.FieldSignatureInfo fieldSignatureInfo, TypeName currentType) {
        String methodName = NamingHelper.upperCaseFirst(relation);
        String fieldName = fieldSignatureInfo.fieldName;
        String quotedCqlColumn = fieldSignatureInfo.quotedCqlColumn;
        return MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate an ... <strong>IF $L $L ?</strong>", new Object[]{fieldName, AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(fieldSignatureInfo.typeName, fieldName, new Modifier[]{Modifier.FINAL}).addStatement("boundValues.add($N)", new Object[]{fieldName}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, fieldName, TypeUtils.OPTIONAL}).addStatement("where.onlyIf($T.$L($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, relation, quotedCqlColumn, TypeUtils.QUERY_BUILDER, quotedCqlColumn}).addStatement("return $T.this", new Object[]{currentType}).returns(currentType).build();
    }

    default public MethodSpec buildLWTNotEqual(AbstractDSLCodeGen.FieldSignatureInfo fieldSignatureInfo, TypeName currentType) {
        String methodName = "NotEq";
        String fieldName = fieldSignatureInfo.fieldName;
        String quotedCqlColumn = fieldSignatureInfo.quotedCqlColumn;
        return MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate an  ... <strong>IF $L != ?</strong>", new Object[]{fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(fieldSignatureInfo.typeName, fieldName, new Modifier[]{Modifier.FINAL}).addStatement("boundValues.add($N)", new Object[]{fieldName}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, fieldName, TypeUtils.OPTIONAL}).addStatement("where.onlyIf($T.of($S, $T.bindMarker($S)))", new Object[]{TypeUtils.NOT_EQ, quotedCqlColumn, TypeUtils.QUERY_BUILDER, quotedCqlColumn}).addStatement("return $T.this", new Object[]{currentType}).returns(currentType).build();
    }
}

