/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.dsl;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.codegen.dsl.AbstractDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.BaseSingleColumnRestriction;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.utils.NamingHelper;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public interface MultiColumnsSliceRestrictionCodeGen
extends BaseSingleColumnRestriction {
    default public void addSingleColumnSliceRestrictions(TypeSpec.Builder relationClassBuilder, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ClassSignatureInfo nextSignature, AbstractDSLCodeGen.ClassSignatureInfo lastSignature, AbstractDSLCodeGen.ReturnType returnType) {
        relationClassBuilder.addMethod(this.buildColumnInVarargs(nextSignature.returnClassType, fieldInfo, returnType)).addMethod(this.buildColumnRelation("gt", lastSignature.returnClassType, fieldInfo, returnType)).addMethod(this.buildColumnRelation("gte", lastSignature.returnClassType, fieldInfo, returnType)).addMethod(this.buildColumnRelation("lt", lastSignature.returnClassType, fieldInfo, returnType)).addMethod(this.buildColumnRelation("lte", lastSignature.returnClassType, fieldInfo, returnType)).addMethod(this.buildDoubleColumnRelation("gt", "lt", lastSignature.returnClassType, fieldInfo, returnType)).addMethod(this.buildDoubleColumnRelation("gt", "lte", lastSignature.returnClassType, fieldInfo, returnType)).addMethod(this.buildDoubleColumnRelation("gte", "lt", lastSignature.returnClassType, fieldInfo, returnType)).addMethod(this.buildDoubleColumnRelation("gte", "lte", lastSignature.returnClassType, fieldInfo, returnType));
    }

    default public void addMultipleColumnsSliceRestrictions(TypeSpec.Builder parentClassBuilder, String parentClassName, List<AbstractDSLCodeGen.FieldSignatureInfo> clusteringCols, AbstractDSLCodeGen.ClassSignatureInfo lastSignature, AbstractDSLCodeGen.ReturnType returnType) {
        for (int i = 2; i <= clusteringCols.size(); ++i) {
            List<AbstractDSLCodeGen.FieldSignatureInfo> fieldInfos = clusteringCols.stream().limit(i).collect(Collectors.toList());
            List<AbstractDSLCodeGen.FieldSignatureInfo> fieldInfosMinusOne = clusteringCols.stream().limit(i - 1).collect(Collectors.toList());
            String multiRelationName = fieldInfos.stream().map(x -> x.fieldName).reduce((a, b) -> a + "_" + b).get();
            ClassName multiRelationClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(parentClassName + "." + multiRelationName), (String[])new String[0]);
            TypeSpec multiRelationClass = TypeSpec.classBuilder((String)multiRelationName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildTuplesColumnRelation("gt", lastSignature.returnClassType, fieldInfos, returnType)).addMethod(this.buildTuplesColumnRelation("gte", lastSignature.returnClassType, fieldInfos, returnType)).addMethod(this.buildTuplesColumnRelation("lt", lastSignature.returnClassType, fieldInfos, returnType)).addMethod(this.buildTuplesColumnRelation("lte", lastSignature.returnClassType, fieldInfos, returnType)).addMethod(this.buildSymmetricColumnDoubleRelation("gt", "lt", lastSignature.returnClassType, fieldInfos, returnType)).addMethod(this.buildSymmetricColumnDoubleRelation("gt", "lte", lastSignature.returnClassType, fieldInfos, returnType)).addMethod(this.buildSymmetricColumnDoubleRelation("gte", "lt", lastSignature.returnClassType, fieldInfos, returnType)).addMethod(this.buildSymmetricColumnDoubleRelation("gte", "lte", lastSignature.returnClassType, fieldInfos, returnType)).addMethod(this.buildAsymmetricColumnDoubleRelation("gt", "lt", lastSignature.returnClassType, fieldInfos, fieldInfosMinusOne, returnType)).addMethod(this.buildAsymmetricColumnDoubleRelation("gt", "lte", lastSignature.returnClassType, fieldInfos, fieldInfosMinusOne, returnType)).addMethod(this.buildAsymmetricColumnDoubleRelation("gte", "lt", lastSignature.returnClassType, fieldInfos, fieldInfosMinusOne, returnType)).addMethod(this.buildAsymmetricColumnDoubleRelation("gte", "lte", lastSignature.returnClassType, fieldInfos, fieldInfosMinusOne, returnType)).addMethod(this.buildAsymmetricColumnDoubleRelation("gt", "lt", lastSignature.returnClassType, fieldInfosMinusOne, fieldInfos, returnType)).addMethod(this.buildAsymmetricColumnDoubleRelation("gt", "lte", lastSignature.returnClassType, fieldInfosMinusOne, fieldInfos, returnType)).addMethod(this.buildAsymmetricColumnDoubleRelation("gte", "lt", lastSignature.returnClassType, fieldInfosMinusOne, fieldInfos, returnType)).addMethod(this.buildAsymmetricColumnDoubleRelation("gte", "lte", lastSignature.returnClassType, fieldInfosMinusOne, fieldInfos, returnType)).build();
            parentClassBuilder.addType(multiRelationClass);
            parentClassBuilder.addMethod(AbstractDSLCodeGen.buildRelationMethod(multiRelationName, (TypeName)multiRelationClassTypeName));
        }
    }

    default public MethodSpec buildDoubleColumnRelation(String relation1, String relation2, TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        String methodName = NamingHelper.upperCaseFirst(relation1) + "_And_" + NamingHelper.upperCaseFirst(relation2);
        String param1 = fieldInfo.fieldName + "_" + NamingHelper.upperCaseFirst(relation1);
        String param2 = fieldInfo.fieldName + "_" + NamingHelper.upperCaseFirst(relation2);
        String column1 = fieldInfo.cqlColumn + "_" + NamingHelper.upperCaseFirst(relation2);
        String column2 = fieldInfo.cqlColumn + "_" + NamingHelper.upperCaseFirst(relation2);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L $L ? AND $L $L ?</strong>", new Object[]{fieldInfo.quotedCqlColumn, AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation1), fieldInfo.quotedCqlColumn, AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation2)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(fieldInfo.typeName, param1, new Modifier[0]).addParameter(fieldInfo.typeName, param2, new Modifier[0]).addStatement("where.and($T.$L($S,$T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, relation1, fieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, column1}).addStatement("where.and($T.$L($S,$T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, relation2, fieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, column2}).addStatement("boundValues.add($L)", new Object[]{param1}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldInfo.fieldName, param1, TypeUtils.OPTIONAL}).addStatement("boundValues.add($L)", new Object[]{param2}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldInfo.fieldName, param2, TypeUtils.OPTIONAL}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildDoubleTokenValueRelation(String relation1, String relation2, TypeName nextType, List<String> partitionKeyColumns, AbstractDSLCodeGen.ReturnType returnType) {
        String methodName = NamingHelper.upperCaseFirst(relation1) + "_And_" + NamingHelper.upperCaseFirst(relation2);
        String fcall = partitionKeyColumns.stream().collect(Collectors.joining(",", "token(", ")"));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L $L ? AND $L $L ?</strong>", new Object[]{fcall, AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation1), fcall, AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation2)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.OBJECT_LONG, "tokenValue1", new Modifier[0]).addParameter(TypeUtils.OBJECT_LONG, "tokenValue2", new Modifier[0]).addStatement("where.and($T.$L($S,$T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, relation1, fcall, TypeUtils.QUERY_BUILDER, "tokenValue1"}).addStatement("where.and($T.$L($S,$T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, relation2, fcall, TypeUtils.QUERY_BUILDER, "tokenValue2"}).addStatement("boundValues.add($N)", new Object[]{"tokenValue1"}).addStatement("encodedValues.add($N)", new Object[]{"tokenValue1"}).addStatement("boundValues.add($N)", new Object[]{"tokenValue2"}).addStatement("encodedValues.add($N)", new Object[]{"tokenValue2"}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildTuplesColumnRelation(String relation, TypeName nextType, List<AbstractDSLCodeGen.FieldSignatureInfo> fieldInfos, AbstractDSLCodeGen.ReturnType returnType) {
        String methodName = NamingHelper.upperCaseFirst(relation);
        StringJoiner paramsJoiner = new StringJoiner(",");
        StringJoiner dataTypeJoiner = new StringJoiner(",");
        fieldInfos.stream().map(x -> x.quotedCqlColumn.replaceAll("\"", "\\\\\"")).forEach(x -> paramsJoiner.add("\"" + x + "\""));
        String params = paramsJoiner.toString();
        String dataTypes = dataTypeJoiner.toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L $L ?</strong>", new Object[]{AbstractDSLCodeGen.formatColumnTuplesForJavadoc(params), AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("where.and($T.$L($T.asList($L), $T.asList($L).stream().map($T::bindMarker).collect($T.toList())))", new Object[]{TypeUtils.QUERY_BUILDER, relation, TypeUtils.ARRAYS, params, TypeUtils.ARRAYS, params, TypeUtils.QUERY_BUILDER, TypeUtils.COLLECTORS}).addStatement("final $T tupleType = rte.tupleTypeFactory.typeFor($L)", new Object[]{TypeUtils.TUPLE_TYPE, dataTypes});
        for (AbstractDSLCodeGen.FieldSignatureInfo x2 : fieldInfos) {
            builder.addParameter(x2.typeName, x2.fieldName, new Modifier[]{Modifier.FINAL}).addStatement("boundValues.add($L)", new Object[]{x2.fieldName}).addStatement("encodedValues.add(meta.$L.encodeFromJava($L, $T.of(cassandraOptions)))", new Object[]{x2.fieldName, x2.fieldName, TypeUtils.OPTIONAL});
        }
        builder.returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildSymmetricColumnDoubleRelation(String relation1, String relation2, TypeName nextType, List<AbstractDSLCodeGen.FieldSignatureInfo> fieldInfos, AbstractDSLCodeGen.ReturnType returnType) {
        String methodName = NamingHelper.upperCaseFirst(relation1) + "_And_" + NamingHelper.upperCaseFirst(relation2);
        StringJoiner paramsJoinerRelation1AsString = new StringJoiner(",");
        StringJoiner paramsJoinerRelation2AsString = new StringJoiner(",");
        fieldInfos.stream().map(x -> x.quotedCqlColumn.replaceAll("\"", "\\\\\"")).forEach(x -> {
            paramsJoinerRelation1AsString.add("\"" + x + "\"");
            paramsJoinerRelation2AsString.add("\"" + x + "\"");
        });
        String paramsRelation1AsString = paramsJoinerRelation1AsString.toString();
        String paramsRelation2AsString = paramsJoinerRelation2AsString.toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L $L ? AND $L $L ?</strong>", new Object[]{AbstractDSLCodeGen.formatColumnTuplesForJavadoc(paramsRelation1AsString), AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation1), AbstractDSLCodeGen.formatColumnTuplesForJavadoc(paramsRelation2AsString), AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation2)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("where.and($T.$L($T.asList($L), $T.asList($L).stream().map($T::bindMarker).collect($T.toList())))", new Object[]{TypeUtils.QUERY_BUILDER, relation1, TypeUtils.ARRAYS, paramsRelation1AsString, TypeUtils.ARRAYS, paramsRelation1AsString, TypeUtils.QUERY_BUILDER, TypeUtils.COLLECTORS}).addStatement("where.and($T.$L($T.asList($L), $T.asList($L).stream().map($T::bindMarker).collect($T.toList())))", new Object[]{TypeUtils.QUERY_BUILDER, relation2, TypeUtils.ARRAYS, paramsRelation2AsString, TypeUtils.ARRAYS, paramsRelation2AsString, TypeUtils.QUERY_BUILDER, TypeUtils.COLLECTORS});
        for (AbstractDSLCodeGen.FieldSignatureInfo x2 : fieldInfos) {
            String relation1Param = x2.fieldName + "_" + NamingHelper.upperCaseFirst(relation1);
            builder.addParameter(x2.typeName, relation1Param, new Modifier[]{Modifier.FINAL}).addStatement("boundValues.add($L)", new Object[]{relation1Param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($L, $T.of(cassandraOptions)))", new Object[]{x2.fieldName, relation1Param, TypeUtils.OPTIONAL});
        }
        for (AbstractDSLCodeGen.FieldSignatureInfo x2 : fieldInfos) {
            String relation2Param = x2.fieldName + "_" + NamingHelper.upperCaseFirst(relation2);
            builder.addParameter(x2.typeName, relation2Param, new Modifier[]{Modifier.FINAL}).addStatement("boundValues.add($L)", new Object[]{relation2Param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($L, $T.of(cassandraOptions)))", new Object[]{x2.fieldName, relation2Param, TypeUtils.OPTIONAL});
        }
        builder.returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildAsymmetricColumnDoubleRelation(String relation1, String relation2, TypeName nextType, List<AbstractDSLCodeGen.FieldSignatureInfo> fieldInfos1, List<AbstractDSLCodeGen.FieldSignatureInfo> fieldInfos2, AbstractDSLCodeGen.ReturnType returnType) {
        String methodName = fieldInfos1.stream().map(x -> x.fieldName).reduce((a, b) -> a + "_And_" + b).get() + "_" + NamingHelper.upperCaseFirst(relation1) + "_And_" + fieldInfos2.stream().map(x -> x.fieldName).reduce((a, b) -> a + "_And_" + b).get() + "_" + NamingHelper.upperCaseFirst(relation2);
        StringJoiner paramsJoinerRelation1AsString = new StringJoiner(",");
        StringJoiner paramsJoinerRelation2AsString = new StringJoiner(",");
        fieldInfos1.stream().map(x -> x.quotedCqlColumn.replaceAll("\"", "\\\\\"")).forEach(x -> paramsJoinerRelation1AsString.add("\"" + x + "\""));
        fieldInfos2.stream().map(x -> x.quotedCqlColumn.replaceAll("\"", "\\\\\"")).forEach(x -> paramsJoinerRelation2AsString.add("\"" + x + "\""));
        String paramsRelation1AsString = paramsJoinerRelation1AsString.toString();
        String paramsRelation2AsString = paramsJoinerRelation2AsString.toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L $L ? AND $L $L ?</strong>", new Object[]{AbstractDSLCodeGen.formatColumnTuplesForJavadoc(paramsRelation1AsString), AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation1), AbstractDSLCodeGen.formatColumnTuplesForJavadoc(paramsRelation2AsString), AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation2)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("where.and($T.$L($T.asList($L), $T.asList($L).stream().map($T::bindMarker).collect($T.toList())))", new Object[]{TypeUtils.QUERY_BUILDER, relation1, TypeUtils.ARRAYS, paramsRelation1AsString, TypeUtils.ARRAYS, paramsRelation1AsString, TypeUtils.QUERY_BUILDER, TypeUtils.COLLECTORS}).addStatement("where.and($T.$L($T.asList($L), $T.asList($L).stream().map($T::bindMarker).collect($T.toList())))", new Object[]{TypeUtils.QUERY_BUILDER, relation2, TypeUtils.ARRAYS, paramsRelation2AsString, TypeUtils.ARRAYS, paramsRelation2AsString, TypeUtils.QUERY_BUILDER, TypeUtils.COLLECTORS});
        for (AbstractDSLCodeGen.FieldSignatureInfo x2 : fieldInfos1) {
            String relation1Param = x2.fieldName + "_" + NamingHelper.upperCaseFirst(relation1);
            builder.addParameter(x2.typeName, relation1Param, new Modifier[]{Modifier.FINAL}).addStatement("boundValues.add($L)", new Object[]{relation1Param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($L, $T.of(cassandraOptions)))", new Object[]{x2.fieldName, relation1Param, TypeUtils.OPTIONAL});
        }
        for (AbstractDSLCodeGen.FieldSignatureInfo x2 : fieldInfos2) {
            String relation2Param = x2.fieldName + "_" + NamingHelper.upperCaseFirst(relation2);
            builder.addParameter(x2.typeName, relation2Param, new Modifier[]{Modifier.FINAL}).addStatement("boundValues.add($L)", new Object[]{relation2Param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($L, $T.of(cassandraOptions)))", new Object[]{x2.fieldName, relation2Param, TypeUtils.OPTIONAL});
        }
        builder.returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }
}

