/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.function;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import info.archinnov.achilles.internals.codegen.function.FunctionParameterTypesCodeGen;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.FunctionSignature;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;

public abstract class FunctionsRegistryCodeGen {
    public TypeSpec generateFunctionsRegistryClass(String className, List<FunctionSignature> functionSignatures) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        if (className.equals("SystemFunctions")) {
            builder.addJavadoc("This class is the common registry for all system functions", new Object[0]);
            this.buildAcceptAllMethodsForSystemFunction().forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        }
        return builder.build();
    }

    protected MethodSpec buildMethodForFunction(FunctionSignature signature) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)signature.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("Call $S function with given parameters", new Object[]{signature.getFunctionName()}).returns(signature.returnTypeForFunctionParam()).addStatement("final $T<Object> params = new $T<>()", new Object[]{TypeUtils.LIST, TypeUtils.ARRAY_LIST});
        signature.parameterSignatures.forEach(param -> {
            String paramName = param.name;
            builder.addParameter(param.typeForFunctionParam(), paramName, new Modifier[]{Modifier.FINAL}).beginControlFlow("if ($L.isFunctionCall())", new Object[]{paramName}).addStatement("params.add($L.buildRecursive())", new Object[]{paramName}).nextControlFlow("else", new Object[0]).addStatement("params.add($L.hasLiteralValue() ? $L.getValue() : $T.column((String)$L.getValue()))", new Object[]{paramName, paramName, TypeUtils.QUERY_BUILDER, paramName}).endControlFlow();
        });
        TypeSpec.Builder anonymousClassBuilder = TypeSpec.anonymousClassBuilder((String)"$T.empty()", (Object[])new Object[]{TypeUtils.OPTIONAL}).superclass(signature.returnTypeForFunctionParam()).addMethod(MethodSpec.methodBuilder((String)"isFunctionCall").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.BOOLEAN).addStatement("return true", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"functionName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeUtils.STRING).addStatement("return $S", new Object[]{signature.getFunctionName()}).build()).addMethod(MethodSpec.methodBuilder((String)"parameters").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeName.OBJECT})).addStatement("return params", new Object[0]).build());
        if (signature.getFunctionName().equals("cast")) {
            anonymousClassBuilder.addMethod(MethodSpec.methodBuilder((String)"targetCQLTypeName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)TypeUtils.DATATYPE).addStatement("return $T.$L()", new Object[]{TypeUtils.DATATYPE, TypeUtils.getNativeDataTypeFor(signature.returnTypeSignature.targetCQLTypeName)}).build());
        }
        TypeSpec anonymousClass = anonymousClassBuilder.build();
        return builder.addStatement("return $L", new Object[]{anonymousClass}).build();
    }

    protected List<MethodSpec> buildAcceptAllMethodsForSystemFunction() {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        TypeName LONG_TYPE = TypeUtils.determineTypeForFunctionParam(TypeUtils.OBJECT_LONG);
        TypeName INT_TYPE = TypeUtils.determineTypeForFunctionParam(TypeUtils.OBJECT_INT);
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{TypeUtils.ABSTRACT_CQL_COMPATIBLE_TYPE, TypeUtils.FUNCTION_CALL});
        AnnotationSpec unchecked = AnnotationSpec.builder((ClassName)ClassName.get(SuppressWarnings.class)).addMember("value", "$S", new Object[]{"rawtypes"}).build();
        TypeSpec.Builder tokenAnonClassBuilder = TypeSpec.anonymousClassBuilder((String)"$T.empty()", (Object[])new Object[]{TypeUtils.OPTIONAL}).superclass(LONG_TYPE).addMethod(MethodSpec.methodBuilder((String)"isFunctionCall").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.BOOLEAN).addStatement("return true", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"functionName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeUtils.STRING).addStatement("return $S", new Object[]{"token"}).build()).addMethod(MethodSpec.methodBuilder((String)"parameters").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeName.OBJECT})).addStatement("return params", new Object[0]).build());
        MethodSpec.Builder tokenFunctionBuilder = MethodSpec.methodBuilder((String)"token").addTypeVariable(typeVariableName).addAnnotation(unchecked).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("Call $S function with given parameters", new Object[]{"token"}).returns(LONG_TYPE).addParameter((TypeName)typeVariableName, "input", new Modifier[]{Modifier.FINAL}).addStatement("final $T<Object> params = new $T<>()", new Object[]{TypeUtils.LIST, TypeUtils.ARRAY_LIST}).addStatement("$T.validateFalse(input.isFunctionCall(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'token' function, it does not accept function call as argument, only simple column"}).addStatement("$T.validateFalse(input.hasLiteralValue(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'token' function, it does not accept literal value as argument, only simple column"}).addStatement("params.add($T.column((String)$L.getValue()))", new Object[]{TypeUtils.QUERY_BUILDER, "input"}).addStatement("return $L", new Object[]{tokenAnonClassBuilder.build()});
        methods.add(tokenFunctionBuilder.build());
        MethodSpec.Builder typeSafeTokenFunctionBuilder = MethodSpec.methodBuilder((String)"token").addAnnotation(unchecked).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("Call $S function with given parameters", new Object[]{"token"}).returns(LONG_TYPE).addParameter((TypeName)ClassName.get((String)"info.archinnov.achilles.generated.function", (String)FunctionParameterTypesCodeGen.PARTITION_KEYS_TYPE, (String[])new String[0]), "partitionKeys", new Modifier[]{Modifier.FINAL}).addStatement("final $T<Object> params = new $T<>()", new Object[]{TypeUtils.LIST, TypeUtils.ARRAY_LIST}).beginControlFlow("for ($T partitionKey: partitionKeys.getValue())", new Object[]{TypeUtils.STRING}).addStatement("params.add($T.column(partitionKey))", new Object[]{TypeUtils.QUERY_BUILDER}).endControlFlow().addStatement("return $L", new Object[]{tokenAnonClassBuilder.build()});
        methods.add(typeSafeTokenFunctionBuilder.build());
        MethodSpec.Builder writetimeFunctionBuilder = MethodSpec.methodBuilder((String)"writetime").addTypeVariable(typeVariableName).addAnnotation(unchecked).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("Call $S function with given parameters", new Object[]{"writetime"}).returns(LONG_TYPE).addParameter((TypeName)typeVariableName, "input", new Modifier[]{Modifier.FINAL}).addStatement("final $T<Object> params = new $T<>()", new Object[]{TypeUtils.LIST, TypeUtils.ARRAY_LIST}).addStatement("$T.validateFalse(input.isFunctionCall(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'writetime' function, it does not accept function call as argument, only simple column"}).addStatement("$T.validateFalse(input.hasLiteralValue(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'writetime' function, it does not accept literal value as argument, only simple column"}).addStatement("params.add($T.column((String)$L.getValue()))", new Object[]{TypeUtils.QUERY_BUILDER, "input"});
        TypeSpec.Builder writetimeAnonClassBuilder = TypeSpec.anonymousClassBuilder((String)"$T.empty()", (Object[])new Object[]{TypeUtils.OPTIONAL}).superclass(LONG_TYPE).addMethod(MethodSpec.methodBuilder((String)"isFunctionCall").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.BOOLEAN).addStatement("return true", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"functionName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeUtils.STRING).addStatement("return $S", new Object[]{"writetime"}).build()).addMethod(MethodSpec.methodBuilder((String)"parameters").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeName.OBJECT})).addStatement("return params", new Object[0]).build());
        methods.add(writetimeFunctionBuilder.addStatement("return $L", new Object[]{writetimeAnonClassBuilder.build()}).build());
        MethodSpec.Builder countNotNullFunctionBuilder = MethodSpec.methodBuilder((String)"countNotNull").addTypeVariable(typeVariableName).addAnnotation(unchecked).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("Call $S function with given parameters", new Object[]{"countNotNull"}).returns(LONG_TYPE).addParameter((TypeName)typeVariableName, "input", new Modifier[]{Modifier.FINAL}).addStatement("final $T<Object> params = new $T<>()", new Object[]{TypeUtils.LIST, TypeUtils.ARRAY_LIST}).addStatement("$T.validateFalse(input.isFunctionCall(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'countNotNull' function, it does not accept function call as argument, only simple column"}).addStatement("$T.validateFalse(input.hasLiteralValue(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'countNotNull' function, it does not accept literal value as argument, only simple column"}).addStatement("params.add($T.column((String)$L.getValue()))", new Object[]{TypeUtils.QUERY_BUILDER, "input"});
        TypeSpec.Builder countNotNullAnonClassBuilder = TypeSpec.anonymousClassBuilder((String)"$T.empty()", (Object[])new Object[]{TypeUtils.OPTIONAL}).superclass(LONG_TYPE).addMethod(MethodSpec.methodBuilder((String)"isFunctionCall").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.BOOLEAN).addStatement("return true", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"functionName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeUtils.STRING).addStatement("return $S", new Object[]{"count"}).build()).addMethod(MethodSpec.methodBuilder((String)"parameters").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeName.OBJECT})).addStatement("return params", new Object[0]).build());
        methods.add(countNotNullFunctionBuilder.addStatement("return $L", new Object[]{countNotNullAnonClassBuilder.build()}).build());
        MethodSpec.Builder ttllFunctionBuilder = MethodSpec.methodBuilder((String)"ttl").addTypeVariable(typeVariableName).addAnnotation(unchecked).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("Call $S function with given parameters", new Object[]{"countNotNull"}).returns(INT_TYPE).addParameter((TypeName)typeVariableName, "input", new Modifier[]{Modifier.FINAL}).addStatement("final $T<Object> params = new $T<>()", new Object[]{TypeUtils.LIST, TypeUtils.ARRAY_LIST}).addStatement("$T.validateFalse(input.isFunctionCall(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'ttl' function, it does not accept function call as argument, only simple column"}).addStatement("$T.validateFalse(input.hasLiteralValue(), $S)", new Object[]{TypeUtils.VALIDATOR, "Invalid argument for 'ttl' function, it does not accept literal value as argument, only simple column"}).addStatement("params.add($T.column((String)$L.getValue()))", new Object[]{TypeUtils.QUERY_BUILDER, "input"});
        TypeSpec.Builder ttlAnonClassBuilder = TypeSpec.anonymousClassBuilder((String)"$T.empty()", (Object[])new Object[]{TypeUtils.OPTIONAL}).superclass(INT_TYPE).addMethod(MethodSpec.methodBuilder((String)"isFunctionCall").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.BOOLEAN).addStatement("return true", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"functionName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeUtils.STRING).addStatement("return $S", new Object[]{"ttl"}).build()).addMethod(MethodSpec.methodBuilder((String)"parameters").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeName.OBJECT})).addStatement("return params", new Object[0]).build());
        methods.add(ttllFunctionBuilder.addStatement("return $L", new Object[]{ttlAnonClassBuilder.build()}).build());
        return methods;
    }
}

