/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.function;

import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.FunctionSignature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class InternalSystemFunctionRegistry {
    public static final List<FunctionSignature> SYSTEM_FUNCTIONS = new ArrayList<FunctionSignature>();
    public static final List<String> SYSTEM_FUNCTIONS_NAME = new ArrayList<String>();
    public static final String FQCN_PATTERN = ".+\\.([a-zA-Z0-9]+)".intern();
    public static final List<String> FORBIDDEN_KEYSPACES = Arrays.asList("system", "system_schema", "system_auth", "system_distributed", "system_traces", "dse_perf", "dse_system", "dse_security", "cfs", "cfs_archive", "solr_admin", "\"OpsCenter\"", "\"HiveMetaStore\"");
    public static final List<TypeName> NUMERIC_TYPES = Arrays.asList(TypeUtils.OBJECT_BYTE, TypeUtils.OBJECT_SHORT, TypeUtils.BIG_INT, TypeUtils.OBJECT_LONG, TypeUtils.OBJECT_FLOAT, TypeUtils.OBJECT_DOUBLE, TypeUtils.BIG_DECIMAL, TypeUtils.OBJECT_INT);

    static {
        NUMERIC_TYPES.stream().forEach(targetType -> {
            String targetCQLDataType = TypeUtils.DRIVER_TYPES_FUNCTION_PARAM_MAPPING.get(targetType);
            FunctionSignature.FunctionParamSignature returnTypeSignature = new FunctionSignature.FunctionParamSignature("returnType", (TypeName)targetType, (TypeName)targetType, targetCQLDataType);
            List<FunctionSignature.FunctionParamSignature> paramsSignature = Arrays.asList(new FunctionSignature.FunctionParamSignature("input", (TypeName)targetType, (TypeName)targetType, targetCQLDataType));
            SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "sum", "sum", returnTypeSignature, paramsSignature));
            SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "avg", "avg", returnTypeSignature, paramsSignature));
        });
        FunctionSignature.FunctionParamSignature timestampReturnSignature = new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.JAVA_UTIL_DATE, TypeUtils.JAVA_UTIL_DATE, "timestamp");
        FunctionSignature.FunctionParamSignature dateReturnSignature = new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.JAVA_DRIVER_LOCAL_DATE, TypeUtils.JAVA_DRIVER_LOCAL_DATE, "date");
        FunctionSignature.FunctionParamSignature timeuuidReturnSignature = new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.UUID, TypeUtils.UUID, "timeuuid");
        FunctionSignature.FunctionParamSignature uuidReturnSignature = new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.UUID, TypeUtils.UUID, "uuid");
        FunctionSignature.FunctionParamSignature byteBufferReturnSignature = new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.BYTE_BUFFER, TypeUtils.BYTE_BUFFER, "blob");
        FunctionSignature.FunctionParamSignature timestampInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.JAVA_UTIL_DATE, TypeUtils.JAVA_UTIL_DATE, "timestamp");
        FunctionSignature.FunctionParamSignature uuidInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.UUID, TypeUtils.UUID, "uuid");
        FunctionSignature.FunctionParamSignature timeUuidInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.UUID, TypeUtils.UUID, "timeuuid");
        FunctionSignature.FunctionParamSignature dateInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.JAVA_DRIVER_LOCAL_DATE, TypeUtils.JAVA_DRIVER_LOCAL_DATE, "date");
        FunctionSignature.FunctionParamSignature inetInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.INET_ADDRESS, TypeUtils.INET_ADDRESS, "inet");
        FunctionSignature.FunctionParamSignature booleanInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.OBJECT_BOOLEAN, TypeUtils.OBJECT_BOOLEAN, "boolean");
        FunctionSignature.FunctionParamSignature textInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.STRING, TypeUtils.STRING, "text");
        FunctionSignature.FunctionParamSignature longInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.OBJECT_LONG, TypeUtils.OBJECT_LONG, "long");
        FunctionSignature.FunctionParamSignature tinyintInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.OBJECT_BYTE, TypeUtils.OBJECT_BYTE, "tinyint");
        FunctionSignature.FunctionParamSignature varintInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.BIG_INT, TypeUtils.BIG_INT, "varint");
        FunctionSignature.FunctionParamSignature byteBufferInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.BYTE_BUFFER, TypeUtils.BYTE_BUFFER, "varint");
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "minTimeuuid", timeuuidReturnSignature, Arrays.asList(timestampInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "maxTimeuuid", timeuuidReturnSignature, Arrays.asList(timestampInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "toDate", dateReturnSignature, Arrays.asList(timeUuidInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "toDate", dateReturnSignature, Arrays.asList(timestampInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "toTimestamp", timestampReturnSignature, Arrays.asList(timeUuidInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "toTimestamp", timestampReturnSignature, Arrays.asList(dateInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "toUnixTimestamp", varintInput, Arrays.asList(timeUuidInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "toUnixTimestamp", varintInput, Arrays.asList(timestampInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "asciiAsBlob", byteBufferReturnSignature, Arrays.asList(textInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "bigintAsBlob", byteBufferReturnSignature, Arrays.asList(longInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "booleanAsBlob", byteBufferReturnSignature, Arrays.asList(booleanInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "counterAsBlob", byteBufferReturnSignature, Arrays.asList(new FunctionSignature.FunctionParamSignature("input", TypeUtils.OBJECT_LONG, TypeUtils.OBJECT_LONG, "counter"))));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "dateAsBlob", byteBufferReturnSignature, Arrays.asList(dateInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "decimalAsBlob", byteBufferReturnSignature, Arrays.asList(new FunctionSignature.FunctionParamSignature("input", TypeUtils.BIG_DECIMAL, TypeUtils.BIG_DECIMAL, "decimal"))));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "doubleAsBlob", byteBufferReturnSignature, Arrays.asList(new FunctionSignature.FunctionParamSignature("input", TypeUtils.OBJECT_DOUBLE, TypeUtils.OBJECT_DOUBLE, "double"))));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "floatAsBlob", byteBufferReturnSignature, Arrays.asList(new FunctionSignature.FunctionParamSignature("input", TypeUtils.OBJECT_FLOAT, TypeUtils.OBJECT_FLOAT, "float"))));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "inetAsBlob", byteBufferReturnSignature, Arrays.asList(inetInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "intAsBlob", byteBufferReturnSignature, Arrays.asList(new FunctionSignature.FunctionParamSignature("input", TypeUtils.OBJECT_INT, TypeUtils.OBJECT_INT, "int"))));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "smallintAsBlob", byteBufferReturnSignature, Arrays.asList(new FunctionSignature.FunctionParamSignature("input", TypeUtils.OBJECT_SHORT, TypeUtils.OBJECT_SHORT, "short"))));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "textAsBlob", byteBufferReturnSignature, Arrays.asList(textInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "timeAsBlob", byteBufferReturnSignature, Arrays.asList(longInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "timestampAsBlob", byteBufferReturnSignature, Arrays.asList(timestampInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "timeuuidAsBlob", byteBufferReturnSignature, Arrays.asList(timeUuidInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "tinyintAsBlob", byteBufferReturnSignature, Arrays.asList(tinyintInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "uuidAsBlob", byteBufferReturnSignature, Arrays.asList(uuidInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "varcharAsBlob", byteBufferReturnSignature, Arrays.asList(textInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "varintAsBlob", byteBufferReturnSignature, Arrays.asList(varintInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsAscii", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.STRING, TypeUtils.STRING, "ascii"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsBigint", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_LONG, TypeUtils.OBJECT_LONG, "bigint"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsBoolean", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_BOOLEAN, TypeUtils.OBJECT_BOOLEAN, "boolean"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsCounter", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_LONG, TypeUtils.OBJECT_LONG, "counter"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsDate", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.JAVA_DRIVER_LOCAL_DATE, TypeUtils.JAVA_DRIVER_LOCAL_DATE, "date"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsDecimal", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.BIG_DECIMAL, TypeUtils.BIG_DECIMAL, "decimal"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsDouble", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_DOUBLE, TypeUtils.OBJECT_DOUBLE, "double"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsFloat", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_FLOAT, TypeUtils.OBJECT_FLOAT, "float"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsInet", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.INET_ADDRESS, TypeUtils.INET_ADDRESS, "inet"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsInt", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_INT, TypeUtils.OBJECT_INT, "int"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsSmallint", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_SHORT, TypeUtils.OBJECT_SHORT, "smallint"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsText", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.STRING, TypeUtils.STRING, "text"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsTime", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_LONG, TypeUtils.OBJECT_LONG, "time"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsTimestamp", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.JAVA_UTIL_DATE, TypeUtils.JAVA_UTIL_DATE, "timestamp"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsTimeUUID", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.UUID, TypeUtils.UUID, "timeuuid"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsTinyint", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_BYTE, TypeUtils.OBJECT_BYTE, "tinyint"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsUUID", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.UUID, TypeUtils.UUID, "uuid"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsVarchar", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.STRING, TypeUtils.STRING, "varchar"), Arrays.asList(byteBufferInput)));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "blobAsVarint", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.BIG_INT, TypeUtils.BIG_INT, "varint"), Arrays.asList(byteBufferInput)));
        TypeUtils.NATIVE_TYPES_2_1.stream().filter(x -> !x.equals((Object)TypeUtils.LIST) && !x.equals((Object)TypeUtils.SET) && !x.equals((Object)TypeUtils.MAP)).filter(x -> !x.equals((Object)TypeUtils.JAVA_DRIVER_UDT_VALUE_TYPE) && !x.equals((Object)TypeUtils.JAVA_DRIVER_TUPLE_VALUE_TYPE)).forEach(nativeType -> {
            String targetCQLDataType = TypeUtils.DRIVER_TYPES_FUNCTION_PARAM_MAPPING.get(nativeType);
            FunctionSignature.FunctionParamSignature returnType = new FunctionSignature.FunctionParamSignature("returnType", (TypeName)nativeType, (TypeName)nativeType, targetCQLDataType);
            SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "min", returnType, Arrays.asList(new FunctionSignature.FunctionParamSignature("input", (TypeName)nativeType, (TypeName)nativeType, targetCQLDataType))));
            SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "max", returnType, Arrays.asList(new FunctionSignature.FunctionParamSignature("input", (TypeName)nativeType, (TypeName)nativeType, targetCQLDataType))));
        });
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "uuid", uuidReturnSignature, Arrays.asList(new FunctionSignature.FunctionParamSignature[0])));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "now", timeuuidReturnSignature, Arrays.asList(new FunctionSignature.FunctionParamSignature[0])));
        SYSTEM_FUNCTIONS.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "count", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.OBJECT_LONG, TypeUtils.OBJECT_LONG, "long"), Arrays.asList(new FunctionSignature.FunctionParamSignature[0])));
        SYSTEM_FUNCTIONS_NAME.addAll(SYSTEM_FUNCTIONS.stream().map(x -> x.name.toLowerCase()).collect(Collectors.toList()));
        SYSTEM_FUNCTIONS_NAME.add("token");
        SYSTEM_FUNCTIONS_NAME.add("ttl");
        SYSTEM_FUNCTIONS_NAME.add("writetime");
    }
}

