/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.meta;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Row;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.annotations.Consistency;
import info.archinnov.achilles.annotations.MaterializedView;
import info.archinnov.achilles.annotations.Strategy;
import info.archinnov.achilles.annotations.TTL;
import info.archinnov.achilles.annotations.Table;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.cassandra_version.CassandraFeature;
import info.archinnov.achilles.internals.codegen.meta.CommonBeanMetaCodeGen;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaColumnsForFunctionsCodeGen;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.metamodel.columns.ClusteringColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.columns.ComputedColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.KeyColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.PartitionKeyInfo;
import info.archinnov.achilles.internals.metamodel.index.IndexType;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.parser.validator.BeanValidator;
import info.archinnov.achilles.internals.parser.validator.FieldValidator;
import info.archinnov.achilles.internals.strategy.naming.InternalNamingStrategy;
import info.archinnov.achilles.internals.utils.NamingHelper;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;

public class EntityMetaCodeGen
implements CommonBeanMetaCodeGen {
    public static final Comparator<Tuple2<String, PartitionKeyInfo>> PARTITION_KEY_SORTER = Comparator.comparing(o -> ((PartitionKeyInfo)o._2()).order);
    public static final Comparator<Tuple2<String, ClusteringColumnInfo>> CLUSTERING_COLUMN_SORTER = Comparator.comparing(o -> ((ClusteringColumnInfo)o._2()).order);
    public static final Comparator<Tuple2<String, String>> BY_CQL_NAME_COLUMN_SORTER = Comparator.comparing(Tuple2::_1);
    private final AptUtils aptUtils;

    public EntityMetaCodeGen(AptUtils aptUtils) {
        this.aptUtils = aptUtils;
    }

    public EntityMetaSignature buildEntityMeta(AbstractEntityProperty.EntityType entityType, TypeElement elm, GlobalParsingContext globalParsingContext, List<FieldParser.FieldMetaSignature> fieldMetaSignatures, List<FieldParser.FieldMetaSignature> customConstructorFieldMetaSignatures) {
        TypeName rawClassTypeName = TypeUtils.getRawType(TypeName.get((TypeMirror)elm.asType()));
        Optional<Consistency> consistency = this.aptUtils.getAnnotationOnClass(elm, Consistency.class);
        Optional<TTL> ttl = this.aptUtils.getAnnotationOnClass(elm, TTL.class);
        Optional<Strategy> strategy = this.aptUtils.getAnnotationOnClass(elm, Strategy.class);
        Optional<Table> entityAnnot = this.aptUtils.getAnnotationOnClass(elm, Table.class);
        Optional<TypeName> viewBaseClass = AnnotationTree.findOptionalViewBaseClass(this.aptUtils, elm);
        this.aptUtils.validateFalse(entityAnnot.isPresent() && viewBaseClass.isPresent(), "Cannot have both @Table and @MaterializedView on the class '%s'", rawClassTypeName);
        if (entityType == AbstractEntityProperty.EntityType.VIEW) {
            this.aptUtils.validateTrue(viewBaseClass.isPresent(), "Missing @MaterializedView annotation on entity class '%s'", rawClassTypeName);
        }
        BeanValidator beanValidator = globalParsingContext.beanValidator();
        FieldValidator fieldValidator = globalParsingContext.fieldValidator();
        beanValidator.validateIsAConcreteClass(this.aptUtils, elm);
        beanValidator.validateNoDuplicateNames(this.aptUtils, rawClassTypeName, fieldMetaSignatures);
        beanValidator.validateHasPartitionKey(this.aptUtils, rawClassTypeName, fieldMetaSignatures);
        beanValidator.validateConstructor(this.aptUtils, rawClassTypeName, elm);
        boolean isCounter = beanValidator.isCounterTable(this.aptUtils, rawClassTypeName, fieldMetaSignatures);
        if (entityType == AbstractEntityProperty.EntityType.TABLE) {
            beanValidator.validateStaticColumns(this.aptUtils, rawClassTypeName, fieldMetaSignatures);
        } else if (entityType == AbstractEntityProperty.EntityType.VIEW && globalParsingContext.supportsFeature(CassandraFeature.MATERIALIZED_VIEW)) {
            beanValidator.validateNoStaticColumnsForView(this.aptUtils, rawClassTypeName, fieldMetaSignatures);
            this.aptUtils.validateFalse(isCounter, "The class '%s' cannot have counter columns because it is a materialized view", rawClassTypeName);
        }
        beanValidator.validateComputed(this.aptUtils, rawClassTypeName, fieldMetaSignatures);
        beanValidator.validateCqlColumnNotReservedWords(this.aptUtils, rawClassTypeName, fieldMetaSignatures);
        fieldValidator.validateCorrectKeysOrder(this.aptUtils, rawClassTypeName, fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).map(x -> Tuple2.of((Object)x.context.fieldName, (Object)((KeyColumnInfo)((Object)x.context.columnInfo)))).collect(Collectors.toList()), "@PartitionKey");
        fieldValidator.validateCorrectKeysOrder(this.aptUtils, rawClassTypeName, fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.CLUSTERING).map(x -> Tuple2.of((Object)x.context.fieldName, (Object)((KeyColumnInfo)((Object)x.context.columnInfo)))).collect(Collectors.toList()), "@ClusteringColumn");
        TypeName rawBeanType = TypeName.get((TypeMirror)this.aptUtils.erasure(elm));
        String className = elm.getSimpleName() + "_AchillesMeta";
        ClassName typeName = ClassName.get((String)"info.archinnov.achilles.generated.meta.entity", (String)className, (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addJavadoc("Meta class of all entities of type $T<br/>\n", new Object[]{rawBeanType}).addJavadoc("The meta class is responsible for<br/>\n", new Object[0]).addJavadoc("<ul>\n", new Object[0]).addJavadoc("   <li>determining runtime consistency levels (read/write,serial)<li/>\n", new Object[0]);
        if (entityType == AbstractEntityProperty.EntityType.TABLE) {
            builder.addJavadoc("   <li>determining runtime insert strategy<li/>\n", new Object[0]);
        }
        builder.addJavadoc("   <li>trigger event interceptors (if any)<li/>\n", new Object[0]).addJavadoc("   <li>map a $T back to an instance of $T<li/>\n", new Object[]{ClassName.get(Row.class), rawBeanType}).addJavadoc("   <li>determine runtime keyspace name using static annotations and runtime SchemaNameProvider (if any)<li/>\n", new Object[0]).addJavadoc("   <li>determine runtime table name using static annotations and runtime SchemaNameProvider (if any)<li/>\n", new Object[0]).addJavadoc("   <li>generate schema during bootstrap<li/>\n", new Object[0]).addJavadoc("   <li>validate schema during bootstrap<li/>\n", new Object[0]).addJavadoc("   <li>expose all property meta classes for encoding/decoding purpose on unitary columns<li/>\n", new Object[0]).addJavadoc("<ul/>\n", new Object[0]);
        builder.addAnnotation(TypeUtils.ACHILLES_META_ANNOT).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildEntityClass(rawClassTypeName)).addMethod(this.buildDerivedTableName(elm, globalParsingContext.namingStrategy)).addMethod(this.buildFieldNameToCqlColumn(fieldMetaSignatures)).addMethod(this.buildGetStaticReadConsistency(consistency)).addMethod(this.buildGetStaticNamingStrategy(strategy)).addMethod(this.buildPartitionKeys(fieldMetaSignatures, rawBeanType)).addMethod(this.buildClusteringColumns(fieldMetaSignatures, rawBeanType)).addMethod(this.buildNormalColumns(fieldMetaSignatures, rawBeanType)).addMethod(this.buildComputedColumns(fieldMetaSignatures, rawBeanType)).addMethod(this.buildConstructorInjectedColumns(customConstructorFieldMetaSignatures, rawBeanType));
        if (entityType == AbstractEntityProperty.EntityType.TABLE) {
            builder.superclass((TypeName)TypeUtils.genericType(TypeUtils.ABSTRACT_ENTITY_PROPERTY, rawBeanType)).addMethod(this.buildIsCounterTable(isCounter)).addMethod(this.buildStaticKeyspace(this.aptUtils.getAnnotationOnClass(elm, Table.class).get().keyspace())).addMethod(this.buildStaticTableOrViewName(this.aptUtils.getAnnotationOnClass(elm, Table.class).get().table())).addMethod(this.buildGetStaticWriteConsistency(consistency)).addMethod(this.buildGetStaticSerialConsistency(consistency)).addMethod(this.buildGetStaticTTL(ttl)).addMethod(this.buildGetStaticInsertStrategy(strategy)).addMethod(this.buildStaticColumns(fieldMetaSignatures, rawBeanType)).addMethod(this.buildCounterColumns(fieldMetaSignatures, rawBeanType));
        } else if (entityType == AbstractEntityProperty.EntityType.VIEW && globalParsingContext.supportsFeature(CassandraFeature.MATERIALIZED_VIEW)) {
            builder.superclass((TypeName)TypeUtils.genericType(TypeUtils.ABSTRACT_VIEW_PROPERTY, rawBeanType)).addMethod(this.buildStaticKeyspace(this.aptUtils.getAnnotationOnClass(elm, MaterializedView.class).get().keyspace())).addMethod(this.buildStaticTableOrViewName(this.aptUtils.getAnnotationOnClass(elm, MaterializedView.class).get().view())).addMethod(this.buildGetBaseEntityClass(viewBaseClass.get()));
        }
        builder.addMethod(this.buildNewInstanceFromCustomConstructor(customConstructorFieldMetaSignatures, rawClassTypeName));
        for (FieldParser.FieldMetaSignature x2 : fieldMetaSignatures) {
            builder.addField(x2.buildPropertyAsField());
        }
        builder.addType(EntityMetaColumnsForFunctionsCodeGen.createColumnsClassForFunctionParam(fieldMetaSignatures)).addField(this.buildColumnsField(className));
        return new EntityMetaSignature(entityType, builder.build(), elm.getSimpleName().toString(), (TypeName)typeName, rawBeanType, viewBaseClass, fieldMetaSignatures, customConstructorFieldMetaSignatures);
    }

    private MethodSpec buildNewInstanceFromCustomConstructor(List<FieldParser.FieldMetaSignature> customConstructorFieldMetaSignatures, TypeName rawClassTypeName) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"newInstanceFromCustomConstructor").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(TypeUtils.ROW, "row", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)TypeUtils.genericType(TypeUtils.LIST, TypeUtils.STRING), "cqlColumns", new Modifier[]{Modifier.FINAL}).returns(rawClassTypeName);
        if (customConstructorFieldMetaSignatures.size() > 0) {
            customConstructorFieldMetaSignatures.forEach(field -> methodSpec.addStatement("final $T $L_value = cqlColumns.contains($L.getColumnForSelect()) ? $L.decodeFromGettable(row): null", new Object[]{field.sourceType.box(), field.context.fieldName, field.context.fieldName, field.context.fieldName}));
            methodSpec.addStatement(customConstructorFieldMetaSignatures.stream().map(fieldMeta -> fieldMeta.context.fieldName + "_value").collect(Collectors.joining(",", "return new $T(", ")")), new Object[]{rawClassTypeName});
        } else {
            String errorMessage = "Cannot instantiate entity '" + rawClassTypeName.toString() + "' using custom constructor because no custom constructor (@EntityCreator) is defined";
            methodSpec.addStatement("throw new $T($S)", new Object[]{TypeName.get(UnsupportedOperationException.class), errorMessage});
        }
        return methodSpec.build();
    }

    private MethodSpec buildFieldNameToCqlColumn(List<FieldParser.FieldMetaSignature> parsingResults) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"fieldNameToCqlColumn").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.BIMAP, TypeUtils.STRING, TypeUtils.STRING)).addStatement("$T<$T,$T> map = $T.create($L)", new Object[]{TypeUtils.BIMAP, TypeUtils.STRING, TypeUtils.STRING, TypeUtils.HASHBIMAP, parsingResults.size()});
        parsingResults.stream().map(x -> Tuple2.of((Object)x.context.fieldName, (Object)x.context.quotedCqlColumn)).forEach(x -> builder.addStatement("map.put($S, $S)", new Object[]{x._1(), x._2()}));
        builder.addStatement("return map", new Object[0]);
        return builder.build();
    }

    private MethodSpec buildEntityClass(TypeName rawClassTypeName) {
        return MethodSpec.methodBuilder((String)"getEntityClass").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.classTypeOf(rawClassTypeName)).addStatement("return $T.class", new Object[]{rawClassTypeName}).build();
    }

    private MethodSpec buildStaticKeyspace(String staticValue) {
        Optional<String> keyspace = Optional.ofNullable(StringUtils.isBlank((CharSequence)staticValue) ? null : staticValue);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getStaticKeyspace").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, TypeUtils.STRING));
        if (keyspace.isPresent()) {
            return builder.addStatement("return $T.of($S)", new Object[]{TypeUtils.OPTIONAL, keyspace.get()}).build();
        }
        return this.emptyOption(builder);
    }

    private MethodSpec buildDerivedTableName(TypeElement elm, InternalNamingStrategy defaultStrategy) {
        Optional<Strategy> strategy = this.aptUtils.getAnnotationOnClass(elm, Strategy.class);
        String tableName = InternalNamingStrategy.inferNamingStrategy(strategy, defaultStrategy).apply(elm.getSimpleName().toString());
        return MethodSpec.methodBuilder((String)"getDerivedTableOrViewName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addStatement("return $S", new Object[]{tableName}).build();
    }

    private MethodSpec buildStaticTableOrViewName(String staticValue) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getStaticTableOrViewName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, TypeUtils.STRING));
        Optional<String> tableName = Optional.ofNullable(StringUtils.isBlank((CharSequence)staticValue) ? null : staticValue);
        if (tableName.isPresent()) {
            return builder.addStatement("return $T.of($S)", new Object[]{TypeUtils.OPTIONAL, tableName.get()}).build();
        }
        return this.emptyOption(builder);
    }

    private MethodSpec buildPartitionKeys(List<FieldParser.FieldMetaSignature> parsingResults, TypeName rawClassType) {
        StringJoiner joiner = new StringJoiner(",");
        parsingResults.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).map(x -> Tuple2.of((Object)x.context.fieldName, (Object)((PartitionKeyInfo)x.context.columnInfo))).sorted(PARTITION_KEY_SORTER).map(x -> (String)x._1()).forEach(x -> joiner.add((CharSequence)x));
        return MethodSpec.methodBuilder((String)"getPartitionKeys").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.propertyListType(rawClassType)).addStatement("return $T.asList($L)", new Object[]{TypeUtils.ARRAYS, joiner.toString()}).build();
    }

    private MethodSpec buildClusteringColumns(List<FieldParser.FieldMetaSignature> parsingResults, TypeName rawClassType) {
        StringJoiner joiner = new StringJoiner(",");
        parsingResults.stream().filter(x -> x.context.columnType == ColumnType.CLUSTERING).map(x -> Tuple2.of((Object)x.context.fieldName, (Object)((ClusteringColumnInfo)x.context.columnInfo))).sorted(CLUSTERING_COLUMN_SORTER).map(x -> (String)x._1()).forEach(x -> joiner.add((CharSequence)x));
        return MethodSpec.methodBuilder((String)"getClusteringColumns").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.propertyListType(rawClassType)).addStatement("return $T.asList($L)", new Object[]{TypeUtils.ARRAYS, joiner.toString()}).build();
    }

    private MethodSpec buildStaticColumns(List<FieldParser.FieldMetaSignature> parsingResults, TypeName rawClassType) {
        StringJoiner joiner = new StringJoiner(",");
        parsingResults.stream().filter(x -> x.context.columnType == ColumnType.STATIC || x.context.columnType == ColumnType.STATIC_COUNTER).map(x -> Tuple2.of((Object)x.context.cqlColumn, (Object)x.context.fieldName)).sorted(BY_CQL_NAME_COLUMN_SORTER).map(x -> (String)x._2()).forEach(x -> joiner.add((CharSequence)x));
        return MethodSpec.methodBuilder((String)"getStaticColumns").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.propertyListType(rawClassType)).addStatement("return $T.asList($L)", new Object[]{TypeUtils.ARRAYS, joiner.toString()}).build();
    }

    private MethodSpec buildComputedColumns(List<FieldParser.FieldMetaSignature> parsingResults, TypeName rawClassType) {
        StringJoiner joiner = new StringJoiner(",");
        parsingResults.stream().filter(x -> x.context.columnType == ColumnType.COMPUTED).map(x -> Tuple2.of((Object)((ComputedColumnInfo)x.context.columnInfo).alias, (Object)x.context.fieldName)).sorted(BY_CQL_NAME_COLUMN_SORTER).map(x -> (String)x._2()).forEach(x -> joiner.add((CharSequence)x));
        return MethodSpec.methodBuilder((String)"getComputedColumns").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.propertyListType(rawClassType)).addStatement("return $T.asList($L)", new Object[]{TypeUtils.ARRAYS, joiner.toString()}).build();
    }

    private MethodSpec buildConstructorInjectedColumns(List<FieldParser.FieldMetaSignature> constructorFieldMetaSignatures, TypeName rawClassType) {
        StringJoiner joiner = new StringJoiner(",");
        constructorFieldMetaSignatures.stream().map(x -> x.context.fieldName).forEach(x -> joiner.add((CharSequence)x));
        return MethodSpec.methodBuilder((String)"getConstructorInjectedColumns").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.propertyListType(rawClassType)).addStatement("return $T.asList($L)", new Object[]{TypeUtils.ARRAYS, joiner.toString()}).build();
    }

    private MethodSpec buildCounterColumns(List<FieldParser.FieldMetaSignature> parsingResults, TypeName rawClassType) {
        StringJoiner joiner = new StringJoiner(",");
        parsingResults.stream().filter(x -> x.context.columnType == ColumnType.COUNTER).map(x -> Tuple2.of((Object)x.context.cqlColumn, (Object)x.context.fieldName)).sorted(BY_CQL_NAME_COLUMN_SORTER).map(x -> (String)x._2()).forEach(x -> joiner.add((CharSequence)x));
        return MethodSpec.methodBuilder((String)"getCounterColumns").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.propertyListType(rawClassType)).addStatement("return $T.asList($L)", new Object[]{TypeUtils.ARRAYS, joiner.toString()}).build();
    }

    private MethodSpec buildNormalColumns(List<FieldParser.FieldMetaSignature> parsingResults, TypeName rawClassType) {
        StringJoiner joiner = new StringJoiner(",");
        parsingResults.stream().filter(x -> x.context.columnType == ColumnType.NORMAL).map(x -> Tuple2.of((Object)x.context.cqlColumn, (Object)x.context.fieldName)).sorted(BY_CQL_NAME_COLUMN_SORTER).map(x -> (String)x._2()).forEach(x -> joiner.add((CharSequence)x));
        return MethodSpec.methodBuilder((String)"getNormalColumns").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.propertyListType(rawClassType)).addStatement("return $T.asList($L)", new Object[]{TypeUtils.ARRAYS, joiner.toString()}).build();
    }

    private MethodSpec buildIsCounterTable(boolean isCounter) {
        return MethodSpec.methodBuilder((String)"isCounterTable").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TypeName.BOOLEAN).addStatement("return $L", new Object[]{isCounter}).build();
    }

    private MethodSpec buildGetStaticReadConsistency(Optional<Consistency> consistency) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getStaticReadConsistency").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, new TypeName[]{TypeUtils.CONSISTENCY_LEVEL}));
        if (consistency.isPresent()) {
            ConsistencyLevel consistencyLevel = consistency.get().read();
            this.aptUtils.validateFalse(consistencyLevel == ConsistencyLevel.SERIAL || consistencyLevel == ConsistencyLevel.LOCAL_SERIAL, "Static read consistency level cannot be SERIAL or LOCAL_SERIAL", new Object[0]);
            return builder.addStatement("return $T.of($T.$L)", new Object[]{TypeUtils.OPTIONAL, TypeUtils.CONSISTENCY_LEVEL, consistencyLevel.name()}).build();
        }
        return this.emptyOption(builder);
    }

    private MethodSpec buildGetStaticWriteConsistency(Optional<Consistency> consistency) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getStaticWriteConsistency").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, new TypeName[]{TypeUtils.CONSISTENCY_LEVEL}));
        if (consistency.isPresent()) {
            ConsistencyLevel consistencyLevel = consistency.get().write();
            this.aptUtils.validateFalse(consistencyLevel == ConsistencyLevel.SERIAL || consistencyLevel == ConsistencyLevel.LOCAL_SERIAL, "Static write consistency level cannot be SERIAL or LOCAL_SERIAL", new Object[0]);
            return builder.addStatement("return $T.of($T.$L)", new Object[]{TypeUtils.OPTIONAL, TypeUtils.CONSISTENCY_LEVEL, consistencyLevel.name()}).build();
        }
        return this.emptyOption(builder);
    }

    private MethodSpec buildGetStaticSerialConsistency(Optional<Consistency> consistency) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getStaticSerialConsistency").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, new TypeName[]{TypeUtils.CONSISTENCY_LEVEL}));
        if (consistency.isPresent()) {
            ConsistencyLevel consistencyLevel = consistency.get().serial();
            this.aptUtils.validateTrue(consistencyLevel == ConsistencyLevel.SERIAL || consistencyLevel == ConsistencyLevel.LOCAL_SERIAL, "Static serial consistency level should be SERIAL or LOCAL_SERIAL", new Object[0]);
            return builder.addStatement("return $T.of($T.$L)", new Object[]{TypeUtils.OPTIONAL, TypeUtils.CONSISTENCY_LEVEL, consistencyLevel.name()}).build();
        }
        return this.emptyOption(builder);
    }

    private MethodSpec buildGetStaticTTL(Optional<TTL> ttl) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getStaticTTL").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, TypeName.INT.box()));
        if (ttl.isPresent()) {
            return builder.addStatement("return $T.of($L)", new Object[]{TypeUtils.OPTIONAL, ttl.get().value()}).build();
        }
        return this.emptyOption(builder);
    }

    private MethodSpec buildGetStaticInsertStrategy(Optional<Strategy> strategy) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getStaticInsertStrategy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, new TypeName[]{TypeUtils.INSERT_STRATEGY}));
        if (strategy.isPresent()) {
            return builder.addStatement("return $T.of($T.$L)", new Object[]{TypeUtils.OPTIONAL, TypeUtils.INSERT_STRATEGY, strategy.get().insert().name()}).build();
        }
        return this.emptyOption(builder);
    }

    private MethodSpec buildGetBaseEntityClass(TypeName baseEntityRawType) {
        return MethodSpec.methodBuilder((String)"getBaseEntityClass").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeUtils.genericType(TypeUtils.CLASS, TypeUtils.WILDCARD)).addStatement("return $T.class", new Object[]{baseEntityRawType}).build();
    }

    private FieldSpec buildColumnsField(String parentClassName) {
        ClassName typeName = ClassName.get((String)"info.archinnov.achilles.generated.meta.entity", (String)(parentClassName + "." + "ColumnsForFunctions"), (String[])new String[0]);
        return FieldSpec.builder((TypeName)typeName, (String)"COLUMNS", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("Static class to expose $S fields for <strong>type-safe</strong> function calls", new Object[]{parentClassName}).initializer(CodeBlock.builder().addStatement("new $T()", new Object[]{typeName}).build()).build();
    }

    private ParameterizedTypeName propertyListType(TypeName rawClassType) {
        return TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeUtils.genericType(TypeUtils.ABSTRACT_PROPERTY, rawClassType, TypeUtils.WILDCARD, TypeUtils.WILDCARD)});
    }

    public static class EntityMetaSignature {
        public final TypeSpec sourceCode;
        public final String className;
        public final TypeName typeName;
        public final TypeName entityRawClass;
        public final String fieldName;
        public final List<FieldParser.FieldMetaSignature> fieldMetaSignatures;
        public final AbstractEntityProperty.EntityType entityType;
        public final Optional<TypeName> viewBaseClass;
        public final List<FieldParser.FieldMetaSignature> constructorInjectedFieldMetaSignatures;

        public EntityMetaSignature(AbstractEntityProperty.EntityType entityType, TypeSpec sourceCode, String className, TypeName typeName, TypeName entityRawClass, Optional<TypeName> viewBaseClass, List<FieldParser.FieldMetaSignature> fieldMetaSignatures, List<FieldParser.FieldMetaSignature> constructorInjectedFieldMetaSignatures) {
            this.entityType = entityType;
            this.sourceCode = sourceCode;
            this.className = className;
            this.typeName = typeName;
            this.entityRawClass = entityRawClass;
            this.viewBaseClass = viewBaseClass;
            this.fieldMetaSignatures = fieldMetaSignatures;
            this.fieldName = className.substring(0, 1).toLowerCase() + className.substring(1);
            this.constructorInjectedFieldMetaSignatures = constructorInjectedFieldMetaSignatures;
        }

        public boolean hasClustering() {
            return this.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.CLUSTERING).count() > 0L;
        }

        public boolean hasStatic() {
            return this.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.STATIC || x.context.columnType == ColumnType.STATIC_COUNTER).count() > 0L;
        }

        public boolean hasIndex() {
            return this.fieldMetaSignatures.stream().filter(x -> x.context.indexInfo.type != IndexType.NONE).count() >= 1L;
        }

        public boolean isCounterEntity() {
            return this.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.COUNTER || x.context.columnType == ColumnType.STATIC_COUNTER).count() > 0L;
        }

        public boolean isTable() {
            return this.entityType == AbstractEntityProperty.EntityType.TABLE;
        }

        public boolean isView() {
            return this.entityType == AbstractEntityProperty.EntityType.VIEW;
        }

        public String whereType(String fieldName, String suffix) {
            return suffix + "_" + NamingHelper.upperCaseFirst(fieldName);
        }

        public String endClassName(String suffix) {
            return suffix;
        }

        public String endReturnType(String dslSuffix, String suffix) {
            return this.className + dslSuffix + "." + suffix;
        }

        public String whereReturnType(String fieldName, String dslSuffix, String suffix) {
            return this.className + dslSuffix + "." + suffix + "_" + NamingHelper.upperCaseFirst(fieldName);
        }

        public String selectClassName() {
            return this.className + "_Select";
        }

        public String indexSelectClassName() {
            return this.className + "_SelectIndex";
        }

        public String selectFromReturnType() {
            return this.selectClassName() + "." + "F";
        }

        public String indexSelectFromReturnType() {
            return this.indexSelectClassName() + "." + "F";
        }

        public String selectFromTypedMapReturnType() {
            return this.selectClassName() + "." + "F_TM";
        }

        public String indexSelectFromTypedMapReturnType() {
            return this.indexSelectClassName() + "." + "F_TM";
        }

        public String selectFromJSONReturnType() {
            return this.selectClassName() + "." + "F_J";
        }

        public String indexSelectFromJSONReturnType() {
            return this.indexSelectClassName() + "." + "F_J";
        }

        public String selectColumnsReturnType() {
            return this.selectClassName() + "." + "Cols";
        }

        public String indexSelectColumnsReturnType() {
            return this.indexSelectClassName() + "." + "Cols";
        }

        public String selectColumnsTypedMapReturnType() {
            return this.selectClassName() + "." + "ColsTM";
        }

        public String indexSelectColumnsTypedMapReturnType() {
            return this.indexSelectClassName() + "." + "ColsTM";
        }

        public String selectWhereReturnType(String fieldName) {
            return this.selectClassName() + "." + "W" + "_" + NamingHelper.upperCaseFirst(fieldName);
        }

        public String indexSelectWhereReturnType() {
            return this.indexSelectClassName() + "." + "W";
        }

        public String selectWhereTypedMapReturnType(String fieldName) {
            return this.selectClassName() + "." + "W_TM" + "_" + NamingHelper.upperCaseFirst(fieldName);
        }

        public String indexSelectWhereTypedMapReturnType() {
            return this.indexSelectClassName() + "." + "W_TM";
        }

        public String selectWhereJSONReturnType(String fieldName) {
            return this.selectClassName() + "." + "W_J" + "_" + NamingHelper.upperCaseFirst(fieldName);
        }

        public String indexSelectWhereJSONReturnType() {
            return this.indexSelectClassName() + "." + "W_J";
        }

        public String selectEndReturnType() {
            return this.selectClassName() + "." + "E";
        }

        public String indexSelectEndReturnType() {
            return this.indexSelectClassName() + "." + "E";
        }

        public String selectEndTypedMapReturnType() {
            return this.selectClassName() + "." + "E_TM";
        }

        public String indexSelectEndTypedMapReturnType() {
            return this.indexSelectClassName() + "." + "E_TM";
        }

        public String selectEndJSONReturnType() {
            return this.selectClassName() + "." + "E_J";
        }

        public String indexSelectEndJSONReturnType() {
            return this.indexSelectClassName() + "." + "E_J";
        }

        public String deleteClassName() {
            return this.className + "_Delete";
        }

        public String deleteFromReturnType() {
            return this.deleteClassName() + "." + "F";
        }

        public String deleteColumnsReturnType() {
            return this.deleteClassName() + "." + "Cols";
        }

        public String deleteWhereReturnType(String fieldName) {
            return this.deleteClassName() + "." + "W" + "_" + NamingHelper.upperCaseFirst(fieldName);
        }

        public String deleteStaticClassName() {
            return this.className + "_DeleteStatic";
        }

        public String deleteStaticFromReturnType() {
            return this.deleteStaticClassName() + "." + "F";
        }

        public String deleteStaticColumnsReturnType() {
            return this.deleteStaticClassName() + "." + "Cols";
        }

        public String deleteStaticWhereReturnType(String fieldName) {
            return this.deleteStaticClassName() + "." + "W" + "_" + NamingHelper.upperCaseFirst(fieldName);
        }

        public String updateClassName() {
            return this.className + "_Update";
        }

        public String updateFromReturnType() {
            return this.updateClassName() + "." + "F";
        }

        public String updateColumnsReturnType() {
            return this.updateClassName() + "." + "Cols";
        }

        public String updateWhereReturnType(String fieldName) {
            return this.updateClassName() + "." + "W" + "_" + NamingHelper.upperCaseFirst(fieldName);
        }

        public String updateStaticClassName() {
            return this.className + "_UpdateStatic";
        }

        public String updateStaticFromReturnType() {
            return this.updateStaticClassName() + "." + "F";
        }

        public String updateStaticColumnsReturnType() {
            return this.updateStaticClassName() + "." + "Cols";
        }

        public String updateStaticWhereReturnType(String fieldName) {
            return this.updateStaticClassName() + "." + "W" + "_" + NamingHelper.upperCaseFirst(fieldName);
        }
    }
}

