/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.meta;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.codegen.function.FunctionParameterTypesCodeGen;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.columns.PartitionKeyInfo;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.strategy.naming.SnakeCaseNaming;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class EntityMetaColumnsForFunctionsCodeGen {
    private static final SnakeCaseNaming SNAKE_CASE_NAMING = new SnakeCaseNaming();

    public static final TypeSpec createColumnsClassForFunctionParam(List<FieldParser.FieldMetaSignature> parsingResults) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"ColumnsForFunctions").addJavadoc("Utility class to expose all fields with their CQL type for function call", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        parsingResults.stream().filter(x -> x.context.columnType != ColumnType.COMPUTED).forEach(parsingResult -> builder.addField(EntityMetaColumnsForFunctionsCodeGen.buildField(parsingResult)));
        builder.addField(EntityMetaColumnsForFunctionsCodeGen.buildPartitionKeysField(parsingResults));
        return builder.build();
    }

    private static final FieldSpec buildField(FieldParser.FieldMetaSignature fieldMetaSignature) {
        TypeName typeNameForFunctionParam = TypeUtils.determineTypeForFunctionParam(fieldMetaSignature.sourceType);
        String fieldName = SNAKE_CASE_NAMING.apply(fieldMetaSignature.context.fieldName).toUpperCase();
        String cqlColumn = fieldMetaSignature.context.quotedCqlColumn;
        return FieldSpec.builder((TypeName)typeNameForFunctionParam, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("<br/>\n", new Object[0]).addJavadoc("Field to be used for <em>manager.dsl().select().function(...)</em> call\n", new Object[0]).addJavadoc("<br/>\n", new Object[0]).addJavadoc("This is an alias for the field <strong>$S</strong>", new Object[]{fieldMetaSignature.context.fieldName}).initializer(CodeBlock.builder().add("new $T($T.empty()){\n", new Object[]{typeNameForFunctionParam, TypeUtils.OPTIONAL}).add("  @$T\n", new Object[]{TypeUtils.OVERRIDE_ANNOTATION}).beginControlFlow("  protected String cqlColumn()", new Object[0]).addStatement("    return $S", new Object[]{cqlColumn}).endControlFlow().add("  @$T\n", new Object[]{TypeUtils.OVERRIDE_ANNOTATION}).beginControlFlow("  public boolean isFunctionCall()", new Object[0]).addStatement("    return false", new Object[0]).endControlFlow().add("  }\n", new Object[0]).build()).build();
    }

    private static final FieldSpec buildPartitionKeysField(List<FieldParser.FieldMetaSignature> fieldMetaSignatures) {
        List cqlPartitionKeys = fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).map(x -> Tuple2.of((Object)x.context.quotedCqlColumn, (Object)((PartitionKeyInfo)x.context.columnInfo))).sorted(EntityMetaCodeGen.PARTITION_KEY_SORTER).map(x -> (String)x._1()).collect(Collectors.toList());
        ClassName partitionKeysType = ClassName.get((String)"info.archinnov.achilles.generated.function", (String)FunctionParameterTypesCodeGen.PARTITION_KEYS_TYPE, (String[])new String[0]);
        CodeBlock.Builder builder = CodeBlock.builder().add("new $T(new $T<$T>() {\n", new Object[]{partitionKeysType, TypeUtils.ARRAY_LIST, TypeUtils.STRING}).add(" {\n", new Object[0]);
        for (String cqlPartitionKey : cqlPartitionKeys) {
            builder.add(" add($S);", new Object[]{cqlPartitionKey});
        }
        CodeBlock initializer = builder.add(" }\n", new Object[0]).add("  })\n", new Object[0]).build();
        return FieldSpec.builder((TypeName)partitionKeysType, (String)"PARTITION_KEYS", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("<br/>\n", new Object[0]).addJavadoc("Field to be used with <em>SystemFunctions.token(xxx_AchillesMeta.COLUMNS.PARTITION_KEYS, \"tokens\")</em> call\n", new Object[0]).addJavadoc("<br/>\n", new Object[0]).initializer(initializer).build();
    }
}

