/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import info.archinnov.achilles.exception.AchillesLightWeightTransactionException;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.type.lightweighttransaction.LWTResultListener;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LWTHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LWTHelper.class);
    private static final String IF_NOT_EXIST_CLAUSE = " IF NOT EXISTS";
    private static final String IF_CLAUSE = " IF ";

    private static void notifyLWTError(Optional<List<LWTResultListener>> lwtResultListeners, LWTResultListener.LWTResult lwtResult) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Maybe notify listener of LWT error : %s", lwtResult));
        }
        if (lwtResultListeners.isPresent()) {
            for (LWTResultListener listener : lwtResultListeners.get()) {
                listener.onError(lwtResult);
            }
        } else {
            throw new AchillesLightWeightTransactionException(lwtResult);
        }
    }

    private static void notifyCASSuccess(Optional<List<LWTResultListener>> lwtResultListeners) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Maybe notify listener of LWT success", new Object[0]));
        }
        lwtResultListeners.ifPresent(list -> list.forEach(listener -> listener.onSuccess()));
    }

    private static boolean isLWTOperation(String queryString) {
        return queryString.contains(IF_CLAUSE);
    }

    private static boolean isLWTInsert(String queryString) {
        return queryString.contains(IF_NOT_EXIST_CLAUSE);
    }

    public static ResultSet triggerLWTListeners(Optional<List<LWTResultListener>> lwtResultListeners, ResultSet resultSet, String queryString) {
        if (LWTHelper.isLWTOperation(queryString)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Trigger LWT listeners for query : %s", queryString));
            }
            Row lwtResult = resultSet.one();
            if (!resultSet.wasApplied()) {
                TreeMap<String, Object> currentValues = new TreeMap<String, Object>();
                for (ColumnDefinitions.Definition columnDef : lwtResult.getColumnDefinitions()) {
                    String columnDefName = columnDef.getName();
                    Object columnValue = lwtResult.getObject(columnDefName);
                    currentValues.put(columnDefName, columnValue);
                }
                LWTResultListener.LWTResult.LWTOperation lwtOperation = LWTResultListener.LWTResult.LWTOperation.UPDATE;
                if (LWTHelper.isLWTInsert(queryString)) {
                    lwtOperation = LWTResultListener.LWTResult.LWTOperation.INSERT;
                }
                LWTHelper.notifyLWTError(lwtResultListeners, new LWTResultListener.LWTResult(lwtOperation, TypedMap.fromMap(currentValues)));
            } else {
                LWTHelper.notifyCASSuccess(lwtResultListeners);
            }
        }
        return resultSet;
    }
}

