/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.action;

import com.datastax.driver.core.ExecutionInfo;
import com.google.common.util.concurrent.Uninterruptibles;
import info.archinnov.achilles.internals.dsl.AsyncAware;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public interface SelectAction<ENTITY>
extends AsyncAware {
    public Iterator<ENTITY> iterator();

    public Tuple2<Iterator<ENTITY>, ExecutionInfo> iteratorWithExecutionInfo();

    default public ENTITY getOne() {
        try {
            return (ENTITY)Uninterruptibles.getUninterruptibly(this.getOneAsync());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public Tuple2<ENTITY, ExecutionInfo> getOneWithStats() {
        try {
            return (Tuple2)Uninterruptibles.getUninterruptibly(this.getOneAsyncWithStats());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public CompletableFuture<ENTITY> getOneAsync() {
        return this.getListAsync().thenApply(list -> list.size() > 0 ? list.get(0) : null);
    }

    default public CompletableFuture<Tuple2<ENTITY, ExecutionInfo>> getOneAsyncWithStats() {
        return this.getListAsyncWithStats().thenApply(tuple2 -> ((List)tuple2._1()).size() > 0 ? Tuple2.of(((List)tuple2._1()).get(0), (Object)tuple2._2()) : Tuple2.of(null, (Object)tuple2._2()));
    }

    default public List<ENTITY> getList() {
        try {
            return (List)Uninterruptibles.getUninterruptibly(this.getListAsync());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public CompletableFuture<List<ENTITY>> getListAsync() {
        return this.getListAsyncWithStats().thenApply(Tuple2::_1);
    }

    default public Tuple2<List<ENTITY>, ExecutionInfo> getListWithStats() {
        try {
            return (Tuple2)Uninterruptibles.getUninterruptibly(this.getListAsyncWithStats());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    public CompletableFuture<Tuple2<List<ENTITY>, ExecutionInfo>> getListAsyncWithStats();
}

